-- The MIT License (MIT) Copyright © 2025  Olivia May and contributors
antigp.water_message = core.settings:get("antigp_water_message") or "Water usage is currently disabled for you. Please talk to an administrator."

core.register_privilege("water", {description = "Water use priv", give_to_singleplayer=false})

-- needed for 'bucket.lua'
antigp.water_nodes = {}
local water_nodes = antigp.water_nodes

if core.get_modpath("default") then
	water_nodes[#water_nodes + 1] = "default:water_source"
	water_nodes[#water_nodes + 1] = "default:water_flowing"
	water_nodes[#water_nodes + 1] = "default:river_water_source"
	water_nodes[#water_nodes + 1] = "default:river_water_flowing"
end
if core.get_modpath("everness") then
	water_nodes[#water_nodes + 1] = "everness:mineral_water_source"
	water_nodes[#water_nodes + 1] = "everness:mineral_water_flowing"
end

if core.get_modpath("mcl_core") then
	water_nodes[#water_nodes + 1] = "mcl_core:water_source"
	water_nodes[#water_nodes + 1] = "mcl_core:water_flowing"
end
if core.get_modpath("mclx_core") then
	water_nodes[#water_nodes + 1] = "mclx_core:river_water_source"
	water_nodes[#water_nodes + 1] = "mclx_core:river_water_flowing"
end

-- override on_place
local on_place_items = {}
local i
for i = 1, #water_nodes do
	on_place_items[i] = water_nodes[i]
end

if core.get_modpath("bucket") and core.get_modpath("default") then
	on_place_items[#on_place_items + 1] = "bucket:bucket_water"
	on_place_items[#on_place_items + 1] = "bucket:bucket_river_water"
	if core.get_modpath("everness") then
		on_place_items[#on_place_items + 1] = "everness:bucket_mineral_water"
	end
end

if core.get_modpath("mcl_buckets") then
	on_place_items[#on_place_items + 1] = "mcl_buckets:bucket_water"
	if core.get_modpath("mclx_core") then
		on_place_items[#on_place_items + 1] = "mcl_buckets:bucket_river_water"
	end
end

-- override on_use
local on_use_items = {}

if core.get_modpath("technic") then
	on_place_items[#on_place_items + 1] = "technic:water_can"
	on_use_items[#on_use_items + 1] = "technic:water_can"
	on_place_items[#on_place_items + 1] = "technic:river_water_can"
	on_use_items[#on_use_items + 1] = "technic:river_water_can"
end

local function make_override_func(old_func)
	if old_func == nil then return nil end

	return function(itemstack, player, pointed_thing)
		if player then
			local name = player:get_player_name()
			if not core.check_player_privs(name, {water = true}) then
				core.chat_send_player(name, antigp.water_message)
				return nil
			end
		end

		return old_func(itemstack, player, pointed_thing)
	end
end

for i = 1, #on_place_items do
	local item = on_place_items[i]
	local old_on_place = core.registered_items[item].on_place
	local old_on_secondary_use = core.registered_items[item].on_secondary_use
	core.override_item(item, {
		on_place = make_override_func(old_on_place),
		on_secondary_use = make_override_func(old_on_secondary_use),
	})
end

for i = 1, #on_use_items do
	local item = on_use_items[i]
	local old_on_use = core.registered_items[item].on_use
	core.override_item(item, {
		on_use = make_override_func(old_on_use)
	})
end

