-- The MIT License (MIT) Copyright © 2025  Olivia May and contributors
antigp.lava_message = core.settings:get("antigp_lava_message") or "Lava usage is currently disabled for you. Please talk to an administrator."

core.register_privilege("lava", {description = "Lava use priv", give_to_singleplayer=false})

-- needed for 'bucket.lua'
antigp.lava_nodes = {}
local lava_nodes = antigp.lava_nodes

if core.get_modpath("default") then
	lava_nodes[#lava_nodes + 1] = "default:lava_source"
	lava_nodes[#lava_nodes + 1] = "default:lava_flowing"
end

if core.get_modpath("everness") then
	if core.registered_items["everness:lava_source"] then
		lava_nodes[#lava_nodes + 1] = "everness:lava_source"
		lava_nodes[#lava_nodes + 1] = "everness:lava_flowing"
	end
end

if core.get_modpath("mcl_core") then
	lava_nodes[#lava_nodes + 1] = "mcl_core:lava_source"
	lava_nodes[#lava_nodes + 1] = "mcl_core:lava_flowing"
end
if core.get_modpath("mcl_nether") then
	lava_nodes[#lava_nodes + 1] = "mcl_nether:nether_lava_source"
	lava_nodes[#lava_nodes + 1] = "mcl_nether:nether_lava_flowing"
end

-- override on_place
local on_place_items = {}
local i
for i = 1, #lava_nodes do
	on_place_items[i] = lava_nodes[i]
end

if core.get_modpath("bucket") and core.get_modpath("default") then
	on_place_items[#on_place_items + 1] = "bucket:bucket_lava"
	if core.get_modpath("everness") and core.registered_items["everness:bucket_lava"] then
		on_place_items[#on_place_items + 1] = "everness:bucket_lava"
	end
end

if core.get_modpath("mcl_buckets") then
	on_place_items[#on_place_items + 1] = "mcl_buckets:bucket_lava"
end

-- override on_use
local on_use_items = {}

if core.get_modpath("technic") then
	on_place_items[#on_place_items + 1] = "technic:lava_can"
	on_use_items[#on_use_items + 1] = "technic:lava_can"
end

local function make_override_func(old_func)
	if old_func == nil then return nil end

	return function(itemstack, player, pointed_thing)
		if player then
			local name = player:get_player_name()
			if not core.check_player_privs(name, {lava = true}) then
				core.chat_send_player(name, antigp.lava_message)
				return nil
			end
		end

		return old_func(itemstack, player, pointed_thing)
	end
end

for i = 1, #on_place_items do
	local item = on_place_items[i]
	local old_on_place = core.registered_items[item].on_place
	local old_on_secondary_use = core.registered_items[item].on_secondary_use
	core.override_item(item, {
		on_place = make_override_func(old_on_place),
		on_secondary_use = make_override_func(old_on_secondary_use),
	})
end

for i = 1, #on_use_items do
	local item = on_use_items[i]
	local old_on_use = core.registered_items[item].on_use
	core.override_item(item, {
		on_use = make_override_func(old_on_use),
	})
end

