-- Copyright (c) 2024 Olivia May
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

-- The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
--
-- Simple mod that "glues" mods that modify the chat together.

local has_chat_anticurse = core.get_modpath("chat_anticurse")
local has_ranks = core.get_modpath("ranks")
local has_pronouns = core.get_modpath("pronouns")
local has_dcwebhook = core.get_modpath("dcwebhook")
local has_towny_chat = core.get_modpath("towny_chat")
--TODO: chat3

-- Copied from ranks mod
-- [local function] Get colour
local function get_colour(colour)
	if type(colour) == "table" and core.rgba then
		return core.rgba(colour.r, colour.g, colour.b, colour.a)
	elseif type(colour) == "string" then
		return colour
	else
		return "#ffffff"
	end
end
--

local function update_nametag(player, name)
	local ranks_prefix = nil
	if has_ranks then
		local rank = ranks.get_rank(name)

		if rank then
			local def = ranks.get_def(rank)
			if def.prefix then

				local colour = get_colour(def.colour)
				local prefix = core.colorize(colour, def.prefix)
				ranks_prefix = prefix
			end
		end
	end

	local pronouns_str = nil
	if has_pronouns then
		local pronouns_list = pronouns.get(name)
		local i = 0

		if #pronouns_list > 0 then
			pronouns_str = "("
			for i = 1, #pronouns_list - 1 do
				pronouns_str = pronouns_str .. pronouns_list[i] .."/"
			end
			pronouns_str =
				pronouns_str .. pronouns_list[#pronouns_list] .. ")"
		end
	end

	local str = {}
	local list = {ranks_prefix, name, pronouns_str}

	local i
	for i = 1, 3 do -- `3` length of `list`
		if list[i] then
			str[#str + 1] = list[i]
		end
	end

	player:set_properties({nametag = table.concat(str, " ")})
end

local func = function(name, message)
	if has_chat_anticurse then
		if chat_anticurse.is_curse_found(name, message) then
			return true
		end
	end

	local chat_name = name

	local ranks_prefix = nil
	local ranks_uncolored_prefix = nil
	if has_ranks then
		local rank = ranks.get_rank(name)

		if rank then
			local def = ranks.get_def(rank)
			if def.prefix then

				local colour = get_colour(def.colour)
				ranks_uncolored_prefix = def.prefix
				local prefix = core.colorize(colour, def.prefix)
				if def.babybox then
					message = ranks.babybox(message)
				end
				ranks_prefix = prefix
			end
		end
	end

	local pronouns_str = nil
	if has_pronouns then
		local pronouns_list = pronouns.get(name)
		local i = 0

		if #pronouns_list > 0 then
			pronouns_str = "("
			for i = 1, #pronouns_list - 1 do
				pronouns_str = pronouns_str .. pronouns_list[i] .."/"
			end
			pronouns_str =
				pronouns_str .. pronouns_list[#pronouns_list] .. ")"
		end
	end

	local towny_chat_str = nil
	if has_towny_chat then
		local res = towny.residents[name]
		if towny.chat.channels[name] == towny.chat.CHANNEL_GLOBAL then
			if res.town then
				towny_chat_str = "[" .. res.town.name .. "]"
			end
			chat_name = res:get_display_name()
		else
			return towny.chat.chat_message_func(name, message)
		end
	end

	local str = {}
	local list = {ranks_prefix, towny_chat_str, "<" .. chat_name .. ">", pronouns_str, message}

	local i
	for i = 1, 5 do -- `5` length of `list`
		if list[i] then
			str[#str + 1] = list[i]
		end
	end

	core.chat_send_all(table.concat(str, " "))

	if has_dcwebhook then
		local wrapped_name = core.settings:get("dcwebhook.name_wrapper") or "<**@1**>"
		wrapped_name = wrapped_name:gsub("@(.)", chat_name)

		str = {}
		list = {ranks_uncolored_prefix, towny_chat_str, wrapped_name, pronouns_str, message}
		for i = 1, 5 do -- `5` length of `list`
			if list[i] then
				str[#str + 1] = list[i]
			end
		end

		dcwebhook.send_webhook({content = table.concat(str, " ")})
	end

	update_nametag(core.get_player_by_name(name), name)

	return true
end

core.register_on_joinplayer(function (player)
	local name = player:get_player_name()

	update_nametag(player, name)
end)

-- this might be buggy in the future. insert at `2` otherwise commands
-- won't work
table.insert(core.registered_on_chat_messages, 2, func)
