local modname = core.get_current_modname()
local S = core.get_translator(modname)

core.register_node("mesecons_remote:receiver", {
	description = S("Remote Receiver"),
	tiles = {"receiver_off.png"},
	groups = {cracky = 2},
	mesecons = {receptor = {state = mesecon.state.off}},
})
core.register_node("mesecons_remote:receiver_on", {
	description = S("Remote Receiver"),
	tiles = {"receiver_on.png"},
	groups = {cracky = 2, not_in_creative_inventory = 1},
	drop = "mesecons_remote:receiver",
	mesecons = {receptor = {state = mesecon.state.on}},
})

-- return true if `r` is not receiver node
local function lever_mode(r)
	local nname = core.get_node(r).name

	if nname == "mesecons_remote:receiver" then
		core.swap_node(r, {name = "mesecons_remote:receiver_on"})
		mesecon.receptor_on(r)
	elseif nname == "mesecons_remote:receiver_on" then
		core.swap_node(r, {name = "mesecons_remote:receiver"})
		mesecon.receptor_off(r)
	elseif nname ~= "ignore" then
		return true
	end

	return false
end
local button_time = 3
local function button_mode(r)
	local nname = core.get_node(r).name
	if nname == "mesecons_remote:receiver" then
		core.swap_node(r, {name = "mesecons_remote:receiver_on"})
		mesecon.receptor_on(r)
		core.after(button_time, function()
			if lever_mode(r) then
				return true
			end
		end)
	elseif nname == "mesecons_remote:receiver_on" then
		core.swap_node(r, {name = "mesecons_remote:receiver"})
		mesecon.receptor_off(r)
		core.after(button_time, function()
			if lever_mode(r) then
				return true
			end
		end)
	elseif nname ~= "ignore" then
		return true
	end

	return false
end

local desc = S("Remote")

local function update_desc(meta, receivers)
	local mode = ""
	if meta:get("mode") then
		mode = S("Button Mode")
	else
		mode = S("Lever Mode")
	end

	meta:set_string("description", desc .. " \n"
			.. #receivers .. " " .. S("Receiver(s)") .. " \n" .. mode)
end

local function get_receivers(meta)
	if not meta:get("receivers") then
		receivers = {}
		meta:set_string("receivers", core.serialize(receivers))
	else
		receivers = core.deserialize(meta:get("receivers"))
	end

	return receivers
end

local function on_rightclick(itemstack, player, pointed_thing)
	local meta = itemstack:get_meta()
	local receivers = get_receivers(meta)
	local pname = nil

	if player and player:is_player() then
		pname = player:get_player_name()
	end

	if meta:get("mode") then
		meta:set_string("mode", "")
		if pname then
			core.chat_send_player(pname, S("Set to lever mode."))
		end
	else
		meta:set_string("mode", "button")
		if pname then
			core.chat_send_player(pname, S("Set to button mode."))
		end
	end

	update_desc(meta, receivers)

	return itemstack
end

core.register_tool("mesecons_remote:remote", {
	description = desc,
	inventory_image = "remote.png",
	-- TODO: check for protection
	on_use = function(itemstack, user, pointed_thing)
		local meta = itemstack:get_meta()
		local receivers = get_receivers(meta)
		local pos = core.get_pointed_thing_position(pointed_thing)
		local pname = nil
		local i

		if user and user:is_player() then
			pname = user:get_player_name()
		end

		if not meta:get("receivers") then
			receivers = {}
			meta:set_string("receivers", core.serialize(receivers))
		else
			receivers = core.deserialize(meta:get("receivers"))
		end

		if pointed_thing.type == "node" and pos
				and (core.get_node(pos).name == "mesecons_remote:receiver"
				or core.get_node(pos).name == "mesecons_remote:receiver_on") then
			local removed = false

			for i = 1, #receivers do
				local r = receivers[i]
				if pos.x == r.x and pos.y == r.y and pos.z == r.z then
					table.remove(receivers, i)
					removed = true
					if pname then
						core.chat_send_player(pname, S("Receiver removed."))
					end
					break
				end
			end

			if not removed then
				receivers[#receivers + 1] = pos
				if pname then
					core.chat_send_player(pname, S("Receiver added."))
				end
			end
		else
			local func
			if meta:get("mode") then
				func = button_mode
			else
				func = lever_mode
			end

			for i = 1, #receivers do
				local r = receivers[i]
				if r == nil then break end
				if func(r) then
					table.remove(receivers, i)
					i = i - 1
				end
			end
		end
		meta:set_string("receivers", core.serialize(receivers))

		update_desc(meta, receivers)

		return itemstack
	end,
	on_place = on_rightclick,
	on_secondary_use = on_rightclick,
})

core.register_craft({
	output = "mesecons_remote:remote",
	recipe = {
		{"mesecons:wire_00000000_off", "mesecons:wire_00000000_off"},
		{"mesecons_materials:silicon", "default:steel_ingot"},
	},
})

-- clear remote data
core.register_craft({
	type = "shapeless",
	output = "mesecons_remote:remote",
	recipe = {
		"mesecons_remote:remote",
	},
})

core.register_craft({
	output = "mesecons_remote:receiver",
	recipe = {
		{"default:steel_ingot", "mesecons:wire_00000000_off", "default:steel_ingot"},
		{"mesecons:wire_00000000_off", "mesecons_materials:silicon", "mesecons:wire_00000000_off"},
		{"default:steel_ingot", "mesecons:wire_00000000_off", "default:steel_ingot"},
	},
})
