---@param player mt.PlayerObjectRef
local function check_and_lift_player(player)
  local pos = player:get_pos()
  if not pos then
    return
  end
  local node_below = minetest.get_node { x = pos.x, y = pos.y - 1, z = pos.z }
  if node_below.name == "air" then
    return
  else
    player:set_pos { x = pos.x, y = pos.y + 0.5, z = pos.z }
    minetest.after(0.01, check_and_lift_player, player)
  end
end

---@param player mt.PlayerObjectRef
local function start_lifting(player)
  minetest.after(0.1, check_and_lift_player, player)
end

minetest.register_on_joinplayer(start_lifting)
minetest.register_on_respawnplayer(start_lifting)
