--
-- Squill: Database engine for Luanti (formerly known as Minetest)
--
-- Copyright © 2025 by luk3yx
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Lesser General Public License as published by
-- the Free Software Foundation, either version 2.1 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Lesser General Public License for more details.
--
-- You should have received a copy of the GNU Lesser General Public License
-- along with this program.  If not, see <https://www.gnu.org/licenses/>.
--

squill = {}

-- Options for "return_mode" parameter
squill.RETURN_ALL_ROWS = nil
squill.RETURN_FIRST_ROW = 1
squill.RETURN_SINGLE_COLUMN = 2
squill.RETURN_SINGLE_VALUE = 3

local sq = {}
squill._internal = sq

local modpath = core.get_modpath("squill")
dofile(modpath .. "/storage.lua")
dofile(modpath .. "/schema.lua")
dofile(modpath .. "/parser.lua")
dofile(modpath .. "/parse_expr.lua")
dofile(modpath .. "/joins.lua")
dofile(modpath .. "/update_row.lua")

sq.bootstrap()

dofile(modpath .. "/dump.lua")
squill._internal = nil

-- Lazy load API wrappers
squill.compat = setmetatable({}, {__index = function(self, key)
    if key ~= "pgmoon" and key ~= "lsqlite3" then return end
    local api = dofile(modpath .. "/compat/" .. key .. ".lua")
    self[key] = api
    return api
end})

if core.settings:get_bool("squill.enable_gui") then
    if core.global_exists("flow") then
        dofile(modpath .. "/gui.lua")
    else
        core.register_chatcommand("squill", {
            privs = {server = true},
            func = function()
                return false, "You must install https://content.luanti.org/" ..
                    "packages/luk3yx/flow/ to be able to use the Squill GUI."
            end,
        })
    end
end

if core.global_exists("mtt") and mtt.enabled then
    dofile(modpath .. "/test.lua")

    local f = loadfile(modpath .. "/benchmark.lua")
    if f then
        f()
    end
end
