local sq = squill._internal

-- These are too small to warrant a separate file for each command

local function wrap_tx_func(self, func)
    local db_name = self.db_name
    return function()
        func(db_name)
        return {}
    end
end

function sq.cmds:begin()
    self:pop_if_equals("exclusive")
    self:pop_if_equals("transaction")
    return wrap_tx_func(self, sq.begin_transaction)
end

function sq.cmds:commit()
    self:pop_if_equals("transaction")
    return wrap_tx_func(self, sq.commit_transaction)
end

function sq.cmds:rollback()
    self:pop_if_equals("transaction")
    return wrap_tx_func(self, sq.rollback_transaction)
end
