local sq = squill._internal
local valid_identifier = sq.valid_identifier

local get_column_ids = sq.bootstrap_statement([[
    SELECT id FROM schema WHERE db_name = ? AND table = ?
]], squill.RETURN_SINGLE_COLUMN)

local delete_from_schema = sq.bootstrap_statement([[
    DELETE FROM schema WHERE db_name = ? AND table = ?
]])

local delete_from_uniques = sq.bootstrap_statement([[
    DELETE FROM uniques WHERE column_id = ?
]])

local delete_from_foreign_keys = sq.bootstrap_statement([[
    DELETE FROM foreign_keys WHERE child_id = ?
]])

return function(self)
    self:expect("table")

    local if_exists = self:pop_if_equals("if")
    if if_exists then
        self:expect("exists")
    end

    local table_name = self:next()
    self:assert(valid_identifier(table_name), "%q is not a valid table name", table_name)
    self:assert(table_name ~= "squill", "The 'squill' database is read-only")

    local db_name = self.db_name
    return function()
        sq.assert_no_transaction(db_name)

        local column_ids = get_column_ids(db_name, table_name)
        if if_exists and #column_ids == 0 then
            return
        end

        -- Delete all rows (will remove mod storage keys)
        sq.begin_transaction("squill")
        sq.begin_transaction(db_name)
        squill.exec(db_name, "DELETE FROM " .. table_name .. " WHERE TRUE")

        -- Remove the column info from the schema
        for _, column_id in ipairs(column_ids) do
            delete_from_uniques(column_id)
            delete_from_foreign_keys(column_id)
        end
        delete_from_schema(db_name, table_name)

        sq.commit_transaction(db_name, true)
        sq.commit_transaction("squill")

        sq.schema_vers[db_name] = (sq.schema_vers[db_name] or 0) + 1
        return {}
    end
end
