local sq = squill._internal

return function(self)
    local pragma = self:next()
    self:assert(pragma == "foreign_keys", "Pragma %q is unsupported", pragma)

    local db_name = self.db_name
    if not self:pop_if_equals("=") then
        return function()
            return {{[pragma] = not sq.foreign_keys_disabled[db_name]}}
        end, {pragma}
    end

    local str = self:next()
    local value = sq.coerce_to_boolean(str)
    self:assert(value ~= nil, "Not a valid boolean type: %q", str)

    return function()
        sq.foreign_keys_disabled[db_name] = not value
        sq.schema_vers[db_name] = (sq.schema_vers[db_name] or 0) + 1
        return {}
    end
end
