local sq = squill._internal
local format = string.format
local valid_identifier = sq.valid_identifier
return function(self)
    self:expect("from")

    local table_name = self:next()
    self:assert(valid_identifier(table_name), "%q is not a valid table name", table_name)

    local refs = {}
    for _, col in ipairs(self:list_columns(table_name)) do
        local row_ref, col_ref = self:get_col_ref(table_name, col)
        refs[col] = {row = row_ref, col = col_ref}
    end
    self:assert(next(refs), "The table %q does not exist", table_name)

    self:expect("where")

    self.table_lookup = {[table_name] = table_name}
    local where_clause = self:expr_to_lua(self:parse_expr())

    local returned_columns = {affected_rows = true}
    local returning = false
    local return_exprs_lua = {}
    if self:pop_if_equals("returning") then
        repeat
            local name = sq.parse_select_result_column(self, return_exprs_lua,
                returned_columns)
            return_exprs_lua[name] = self:expr_to_lua(return_exprs_lua[name])
        until not self:pop_if_equals(",")
        returning = true
    end

    -- Must be before insert_var_refs
    local delete_checks = {}
    self:add_foreign_key_pre_delete_checks(delete_checks, table_name, refs)

    -- Generate argument list
    local code = {}
    code[#code + 1] = self:create_function_def()
    self:insert_var_refs(code)

    code[#code + 1] = format("local length = %s", assert(self.lengths[table_name]))
    code[#code + 1] = "local previous_length = length"

    if returning then
        code[#code + 1] = "local res = {}"
    end

    -- Iterate backwards so deleting multiple rows will work
    code[#code + 1] = format("for rowid_%s = %s, 1, -1 do", table_name,
        assert(self.lengths[table_name]))
    code[#code + 1] = "if OPS.to_boolean(" .. where_clause .. ") then"

    table.insert_all(code, delete_checks)

    if returning then
        code[#code + 1] = "res[#res + 1] = {"
        for name, expr in pairs(return_exprs_lua) do
            code[#code + 1] = format("[%q] = %s,", name, expr)
        end
        code[#code + 1] = "}"
    end

    -- Delete rows by moving the last row over top of them (since order is not
    -- guaranteed)
    for _, ref in pairs(refs) do
        code[#code + 1] = format("%s = %s[length]", ref.row, ref.col)
        code[#code + 1] = format("%s[length] = nil", ref.col)
    end

    code[#code + 1] = "length = length - 1"

    code[#code + 1] = "end"

    code[#code + 1] = "end"

    code[#code + 1] = "local rows_deleted = previous_length - length"
    code[#code + 1] = "if rows_deleted > 0 then"
    for _, ref in pairs(refs) do
        code[#code + 1] = format(
            "assert(%s.length == previous_length, 'Corrupted database table!')",
            ref.col
        )
        code[#code + 1] = format("%s.length = length", ref.col)
    end

    self:add_set_columns(code, refs)
    code[#code + 1] = "end"

    if returning then
        code[#code + 1] = "res.affected_rows = rows_deleted"
        code[#code + 1] = "return res"
    else
        code[#code + 1] = "return {affected_rows = rows_deleted}"
    end
    code[#code + 1] = "end"

    return self:compile_lua(table.concat(code, "\n")), returned_columns
end
