-- Code generator helpers

local format = string.format
local select = select

local sq = squill._internal

local CodeBuf = {var_refs_inserted = false}
sq.CodeBuf = CodeBuf
CodeBuf.__index = CodeBuf

function CodeBuf.new()
    return setmetatable({}, CodeBuf)
end
-- string.buffer-style helpers
function CodeBuf:put(str)
    self[#self + 1] = str
end

function CodeBuf:putf(str, ...)
    for i = 1, select("#", ...) do
        if select(i, ...) == nil then
            error("Value " .. i .. " is nil (does not work in Lua 5.1)", 2)
        end
    end
    self[#self + 1] = format(str, ...)
end

-- Convert the environment to local variables
local stmt_env = sq.stmt_env
local stmt_localise
do
    local list = {}
    for var_name in pairs(stmt_env) do
        list[#list + 1] = var_name
    end
    local names = table.concat(list, ", ")
    stmt_localise = format("local %s = %s", names, names)
end

sq.PARAM_VAR_PREFIX = "param_"
function CodeBuf:_create_function_def(parser)
    local args = {}
    for i = 1, parser.param_count do
        args[i] = sq.PARAM_VAR_PREFIX .. i
    end

    return format(
        "%s\nreturn function(%s)\nbegin_stmt(%q, %d)",
        stmt_localise,
        table.concat(args, ", "),
        parser.db_name, parser.schema_ver
    )
end

-- Includes the child CodeBuf into this CodeBuf.
function CodeBuf:insert_all(child)
    assert(not child._used)
    child._used = true

    table.insert_all(self, child)
end

-- Compiles the CodeBuf and returns a function
function CodeBuf:compile(parser)
    assert(not self._used)
    self._used = true

    -- Add the function definition
    table.insert(self, 1, self:_create_function_def(parser))
    self:put("end")

    local lua = table.concat(self, "\n")
    if parser.is_explain then
        return lua
    end

    -- print('*** COMPILING ***', parser._code, lua)
    local f
    if loadstring then
        f = assert(loadstring(lua, parser._code))
        if f then setfenv(f, stmt_env) end
    else
        f = assert(load(lua, parser._code, "t", stmt_env))
    end
    return f()

    -- local func = f()
    -- return function(...)
    --     print('*** RUNNING ***', ...)
    --     print(parser._code)
    --     print(lua)
    --     return func(...)
    -- end
end
