local sq = squill._internal
local valid_identifier = sq.valid_identifier
return function(parser)
    parser:expect("from")

    local env = sq.Env.new(parser)
    local table_name = parser:next()
    parser:assert(valid_identifier(table_name), "%q is not a valid table name", table_name)

    local refs = {}
    for _, col in ipairs(env:list_columns(table_name)) do
        local row_ref, col_ref = env:get_col_ref(table_name, col)
        refs[col] = {row = row_ref, col = col_ref}
    end
    parser:assert(next(refs), "The table %q does not exist", table_name)

    parser:expect("where")

    env.table_lookup[table_name] = table_name
    local where_clause = env:expr_to_lua(parser:parse_expr())

    local returned_columns = {affected_rows = true}
    local returning = false
    local return_exprs_lua = {}
    if parser:pop_if_equals("returning") then
        repeat
            local name = sq.parse_select_result_column(parser, return_exprs_lua,
                returned_columns)
            return_exprs_lua[name] = env:expr_to_lua(return_exprs_lua[name])
        until not parser:pop_if_equals(",")
        returning = true
    end

    local code = sq.CodeBuf.new()

    -- Must be before insert_var_refs
    local delete_checks = sq.CodeBuf.new()
    env:add_foreign_key_pre_delete_checks(delete_checks, table_name, refs)

    -- Generate argument list
    env:insert_var_refs(code)

    code:putf("local length = %s", assert(env.lengths[table_name]))
    code:put("local previous_length = length")

    if returning then
        code:put("local res = {}")
    end

    -- Iterate backwards so deleting multiple rows will work
    code:putf("for rowid_%s = %s, 1, -1 do", table_name,
        assert(env.lengths[table_name]))
    code:put("if OPS.to_boolean(" .. where_clause .. ") then")

    code:insert_all(delete_checks)

    if returning then
        code:put("res[#res + 1] = {")
        for name, expr in pairs(return_exprs_lua) do
            code:putf("[%q] = %s,", name, expr)
        end
        code:put("}")
    end

    -- Delete rows by moving the last row over top of them (since order is not
    -- guaranteed)
    for _, ref in pairs(refs) do
        code:putf("%s = %s[length]", ref.row, ref.col)
        code:putf("%s[length] = nil", ref.col)
    end

    code:put("length = length - 1")

    code:put("end")

    code:put("end")

    code:put("local rows_deleted = previous_length - length")
    code:put("if rows_deleted > 0 then")
    for _, ref in pairs(refs) do
        code:putf(
            "assert(%s.length == previous_length, 'Corrupted database table!')",
            ref.col
        )
        code:putf("%s.length = length", ref.col)
    end

    env:add_set_columns(code, refs)
    code:put("end")

    if returning then
        code:put("res.affected_rows = rows_deleted")
        code:put("return res")
    else
        code:put("return {affected_rows = rows_deleted}")
    end

    return code:compile(parser), returned_columns
end
