-- Migrate old schema table versions
local sq = squill._internal

local function append(table_name, row)
    local new_length
    local to_set = {}
    for i, col_name in ipairs(sq.bootstrap_col_names[table_name]) do
        if table_name ~= "schema" or row[2] ~= "schema" or
                row[3] ~= col_name then
            local value = row[i]
            local col = sq.get_column("squill", table_name, col_name)
            if col_name == "id" then
                -- Find the largest ID
                assert(value == 0)
                for j = 1, col.length do
                    value = math.max(value, col[j] + 1)
                end
            end

            col.length = col.length + 1
            col[col.length] = value
            if new_length == nil then
                new_length = col.length
            else
                assert(col.length == new_length)
            end

            to_set[col_name] = col
        end
    end

    -- This is done in a separate loop in case there's an error in the middle
    -- of migrating
    for col_name, col in pairs(to_set) do
        sq.set_column("squill", table_name, col_name, col)
    end

    return new_length
end

-- Add "default_value" column if it doesn't exist
if sq.get_column("squill", "schema", "default_value", sq.BLOBS, true).length == 0 then
    core.log("action", "[squill] Migrating schema table...")
    local new_length = append(
        "schema",
        {"squill", "schema", "default_value", sq.BLOBS, 0, false, false}
    )
    sq.set_column("squill", "schema", "default_value", {
        type = sq.BLOBS,
        length = new_length,
    })
    core.log("action", "[squill] Schema table updated (DEFAULT column support)")
end
