-- Mostly for debugging
-- Do not rely on this
local sq = squill._internal
local cmds = sq.cmds

return function(self)
    if self:pop_if_equals("query") then
        self:expect("plan")
    end

    local cmd = self:next()
    self:assert(cmds[cmd], "Unsupported command")

    self.is_explain = true
    local code = cmds[cmd](self)
    self.is_explain = nil

    if type(code) ~= "string" then
        code = dump(code)
    end

    local title = "Internal implementation (do not rely on this output):"
    return function()
        local rows = {}
        -- Do some basic pretty printing
        local indent = 0
        for i, line in ipairs(code:split("\n", true)) do
            if line:sub(1, 3) == "end" or line:sub(1, 4) == "else" or
                    line:sub(1, 1) == "}" then
                indent = indent - 1
            end
            rows[i] = {[title] = ("\t"):rep(indent) .. line}
            if line:sub(-5) == " then" or line:sub(-3) == " do" or
                    line:sub(1, 16) == "return function(" or
                    line:sub(1, 15) == "local function " or
                    line:sub(-10) == "function()" or
                    line:sub(1, 4) == "else" or line:sub(-1) == "{" then
                indent = indent + 1
            end
        end
        return rows
    end, {title}
end
