local modname = core.get_current_modname()
local S = core.get_translator(modname)

dofile(core.get_modpath(modname) .. "/mod_spec.lua")

local GRAVESTONE_BLOCK = modname .. ":gravestone"
local AIR = "air"
local GRAVE_OWNER = "grave_owner"


core.register_node(GRAVESTONE_BLOCK, {
	drawtype = "mesh",
	mesh = "gravestone.obj",
	diggable = true,
	tiles = {modname .."_gravestone.png"},
	drop = "",
	description = S("Gravestone"),
	groups = {cracky=1, not_in_creative_inventory=1},
	mod_origin = modname,
	can_dig = function(pos, digger)
		local grave_meta = core.get_meta(pos)
		local grave_owner = grave_meta:get_string(GRAVE_OWNER)
		return (grave_owner == digger:get_player_name()) or
				core.is_creative_enabled(digger:get_player_name())
	end,
	after_dig_node = function(pos, _, old_meta, digger)
		-- Transmit inventory to the digging player
		local grave_meta = core.get_meta(pos)
		grave_meta:from_table(old_meta)
		local grave_inv = grave_meta:get_inventory()
		local player_inv = digger:get_inventory()
		for _, list_name in ipairs(inventory_lists) do
			local list = grave_inv:get_list(list_name)
			if list ~= nil then
				local inv
				-- 3d_armor
				if list_name == "armor" and armor then
					local _, armor_inv = armor:get_valid_player(digger, "3d_armor")
					inv = armor_inv
				else
					inv = player_inv
				end

				for _, stack in ipairs(list) do
					if stack:get_count() > 0 then
						grave_inv:remove_item(list_name, stack)
						local leftover
						local item = core.registered_items[stack:get_name()]
						-- mcl_armor specific
						if item.groups.armor == 1 then
							leftover = mcl_armor.equip(stack, digger, false)
						-- 3d_armor specific
						elseif item.armor_groups then
							leftover = armor:equip(digger, stack)
						else
							leftover = inv:add_item(list_name, stack)
						end
						if leftover:get_count() > 0 then
							minetest.add_item(pos, leftover)
						end
					end
				end
			end
		end

		local player_meta = digger:get_meta()
		local value = player_meta:get_string("latest_grave")
		if value then
			local meta_pos = vector.from_string(value)
			if meta_pos == pos then
				player_meta:set_string("latest_grave", nil)
			end
		end
	end,
	on_blast = function(_, _) end,
	on_flood = function(_, _, _) end,
})

core.register_privilege("deathpoint_tp", {
    description = S("Allows teleportation to the latest deathpoint"),
    give_to_singleplayer = false,
})

core.register_chatcommand("back", {
	params = '',
	privs = { deathpoint_tp = true },
	description = S("Teleports the player back to the latest deathpoint (if available)."),
	func = function(sender_name, param)
        local player = core.get_player_by_name(sender_name)
		local player_meta = player:get_meta()
		local value = player_meta:get_string("latest_grave")
		local pos = vector.from_string(value)
		if pos then
			player:set_pos(vector.new(pos.x, pos.y+1, pos.z))
			player_meta:set_string("latest_grave", nil)
		else
			core.chat_send_player(sender_name, S("Theres no deathpoint you can teleport to!"))
		end
    end,
})

local function get_gravestone_pos(pos)
	if core.get_node(pos).name == AIR then
		return pos
	end
	local res = nil
	while res == nil do
		res = core.find_node_near(pos, 8, { AIR })
		pos.y = pos.y + 8

		if res ~= nil then
			local below = res
			below.y = below.y - 1
			if not core.registered_nodes[core.get_node(below).name].buildable_to then
				res = nil
			end
		end
	end
	return res
end

core.register_on_dieplayer(function(player, _)
	local player_inv = player:get_inventory()
	local player_pos = vector.round(player:get_pos())
	local player_name = player:get_player_name()
	player_pos.y = player_pos.y + 1
	local grave_inv = nil
	for _, list_name in ipairs(inventory_lists) do
		local inv
		-- 3d_armor
		if list_name == "armor" and armor then
			local _, armor_inv = armor:get_valid_player(player, "3d_armor")
			inv = armor_inv
		else
			inv = player_inv
		end
		if not inv:is_empty(list_name) then
			if grave_inv == nil then
				local grave_pos = get_gravestone_pos(player_pos)
				if grave_pos == nil then
					core.chat_send_player(player_name, S("Couldn't create gravestone for deathpoint at position '@1'", tostring(player_pos)))
					return
				end

				local below=vector.new(grave_pos.x, grave_pos.y-1, grave_pos.z)
				local node_below = core.registered_nodes[core.get_node(below).name]
				if not (node_below.walkable or node_below.buildable) then
					if stone ~= nil then
						core.set_node(below, {name=stone})
					end
				end

				core.set_node(grave_pos, {name=GRAVESTONE_BLOCK})
				local grave_meta = core.get_meta(grave_pos)
				grave_meta:set_string(GRAVE_OWNER, player_name)
				grave_inv = grave_meta:get_inventory()
				local player_meta = player:get_meta()
				player_meta:set_string("latest_grave", tostring(grave_pos))
				core.chat_send_player(player_name, S("Gravestone spawned at position '@1'", tostring(grave_pos)))
			end

			grave_inv:set_size(list_name, inv:get_size(list_name))
			local list = inv:get_list(list_name)
			if list ~= nil then
				for _, data in ipairs(list) do
					if data:get_count() > 0 then
						grave_inv:add_item(list_name, data)
						inv:remove_item(list_name, data)
					end
				end
			end
		end
	end
end)
