local S = minetest.get_translator(minetest.get_current_modname())

-- BLOCK AND INGOT
-- Ancient Ingot
core.register_craftitem("m16b_ancient_armor:ancient_ingot", {
	description = S("Ancient Ingot"),
	_doc_items_longdesc = S("Ancient Ingot. It is used to craft armor and tools."),
	inventory_image = "m16b_ancient_ingot.png",
	groups = { craftitem=1 },
})

minetest.register_craft({
	output = "m16b_ancient_armor:ancient_ingot",
	recipe = {
		{"mcl_sculk:sculk", "mcl_core:gold_ingot"},
		{"mcl_core:gold_ingot", "mcl_sculk:sculk"},

	},
})

-- Ancient Ingot Block
core.register_node("m16b_ancient_armor:ancient_ingot_block", {
	description = S("Ancient Ingot Block"),
	_doc_items_longdesc = S("A block of ancient ingots is mostly a decorative block but also useful as a compact storage of ancient ingots."),
	tiles = {"m16b_ancient_ingot_block.png"},
	is_ground_content = false,
	groups = {pickaxey = 3, building_block = 1, beacon_block = 1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 5,
})

minetest.register_craft({
	output = "m16b_ancient_armor:ancient_ingot_block",
	recipe = {
		{"m16b_ancient_armor:ancient_ingot", "m16b_ancient_armor:ancient_ingot", "m16b_ancient_armor:ancient_ingot"},
		{"m16b_ancient_armor:ancient_ingot", "m16b_ancient_armor:ancient_ingot", "m16b_ancient_armor:ancient_ingot"},
		{"m16b_ancient_armor:ancient_ingot", "m16b_ancient_armor:ancient_ingot", "m16b_ancient_armor:ancient_ingot"},
	},
})


-- ARMOR
-- Ancient Armor
mcl_armor.register_set({
	name = "ancient",
	descriptions = {
		head = S("Ancient Helmet"),
		torso = S("Ancient Chestplate"),
		legs = S("Ancient Leggings"),
		feet = S("Ancient Boots"),
	},	durability = 600,
	enchantability = 18,
	points = {
		head = 4,
		torso = 9,
		legs = 6,
		feet = 4,
	},
	groups = { fire_immune=1 },
	toughness = 3,
	repair_material = "mcl_sculk:sculk",
	sound_equip = "mcl_armor_equip_leather",
	sound_unequip = "mcl_armor_unequip_leather",
})

minetest.register_craft({
	output = "m16b_ancient_armor:helmet_ancient",
	recipe = {
		{"mcl_sculk:catalyst", "m16b_ancient_armor:ancient_ingot", "mcl_sculk:catalyst"},
		{"m16b_ancient_armor:ancient_ingot", "", "m16b_ancient_armor:ancient_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_ancient_armor:chestplate_ancient",
	recipe = {
		{"m16b_ancient_armor:ancient_ingot", "", "m16b_ancient_armor:ancient_ingot"},
		{"mcl_sculk:catalyst", "m16b_ancient_armor:ancient_ingot", "mcl_sculk:catalyst"},
		{"m16b_ancient_armor:ancient_ingot", "mcl_sculk:catalyst", "m16b_ancient_armor:ancient_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_ancient_armor:leggings_ancient",
	recipe = {
		{"mcl_sculk:catalyst", "m16b_ancient_armor:ancient_ingot", "mcl_sculk:catalyst"},
		{"m16b_ancient_armor:ancient_ingot", "", "m16b_ancient_armor:ancient_ingot"},
		{"m16b_ancient_armor:ancient_ingot", "", "m16b_ancient_armor:ancient_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_ancient_armor:boots_ancient",
	recipe = {
		{"mcl_sculk:catalyst", "", "mcl_sculk:catalyst"},
		{"m16b_ancient_armor:ancient_ingot", "", "m16b_ancient_armor:ancient_ingot"},

	},
})


-- TOOLS
--Ancient set
mcl_tools.register_set("ancient", {
    craftable = true,
    material = "m16b_ancient_armor:ancient_ingot",
    uses = 2040,
    level = 6,
    speed = 10,
    max_drop_level = 4,
    groups = { dig_speed_class = 7, enchantability = 8, fire_immune = 1 }
}, {
    ["pick"] = {
        description = S("Ancient Pickaxe"),
        inventory_image = "m16b_ancient_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 5 }
        }
    },
    ["shovel"] = {
        description = S("Ancient Shovel"),
        inventory_image = "m16b_ancient_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 4 }
        }
    },
    ["sword"] = {
        description = S("Ancient Sword"),
        inventory_image = "m16b_ancient_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 10 }
        }
    },
    ["axe"] = {
        description = S("Ancient Axe"),
        inventory_image = "m16b_ancient_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 8 }
        }
    }
})
