local S = minetest.get_translator(minetest.get_current_modname())

--Copper set
mcl_tools.register_set("copper", {
    craftable = true,
    material = "mcl_copper:copper_ingot",
    uses = 230,
    level = 3,
    speed = 4,
    max_drop_level = 2,
    groups = { dig_speed_class = 2, enchantability = 10 }
}, {
    ["pick"] = {
        description = S("Copper Pickaxe"),
        inventory_image = "m16b_copper_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 3 }
        }
    },
    ["shovel"] = {
        description = S("Copper Shovel"),
        inventory_image = "m16b_copper_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 3 }
        }
    },
    ["sword"] = {
        description = S("Copper Sword"),
        inventory_image = "m16b_copper_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 5 }
        }
    },
    ["axe"] = {
        description = S("Copper Axe"),
        inventory_image = "m16b_copper_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 8 }
        }
    }
})

--Exposed set
mcl_tools.register_set("exposed", {
    craftable = true,
    material = "mcl_copper:copper_ingot",
    uses = 230,
    level = 3,
    speed = 4,
    max_drop_level = 2,
    groups = { dig_speed_class = 2, enchantability = 10 }
}, {
    ["pick"] = {
        description = S("Exposed Pickaxe"),
        inventory_image = "m16b_exposed_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 3 }
        }
    },
    ["shovel"] = {
        description = S("Exposed Shovel"),
        inventory_image = "m16b_exposed_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 3 }
        }
    },
    ["sword"] = {
        description = S("Exposed Sword"),
        inventory_image = "m16b_exposed_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 5 }
        }
    },
    ["axe"] = {
        description = S("Exposed Axe"),
        inventory_image = "m16b_exposed_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 8 }
        }
    }
})

--Weathered set
mcl_tools.register_set("weathered", {
    craftable = true,
    material = "mcl_copper:copper_ingot",
    uses = 230,
    level = 3,
    speed = 4,
    max_drop_level = 2,
    groups = { dig_speed_class = 2, enchantability = 10 }
}, {
    ["pick"] = {
        description = S("Weathered Pickaxe"),
        inventory_image = "m16b_weathered_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 3 }
        }
    },
    ["shovel"] = {
        description = S("Weathered Shovel"),
        inventory_image = "m16b_weathered_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 3 }
        }
    },
    ["sword"] = {
        description = S("Weathered Sword"),
        inventory_image = "m16b_weathered_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 5 }
        }
    },
    ["axe"] = {
        description = S("Weathered Axe"),
        inventory_image = "m16b_weathered_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 8 }
        }
    }
})

--Oxidized set
mcl_tools.register_set("oxidized", {
    craftable = true,
    material = "mcl_copper:copper_ingot",
    uses = 230,
    level = 3,
    speed = 4,
    max_drop_level = 2,
    groups = { dig_speed_class = 2, enchantability = 10 }
}, {
    ["pick"] = {
        description = S("Oxidized Pickaxe"),
        inventory_image = "m16b_oxidized_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 3 }
        }
    },
    ["shovel"] = {
        description = S("Oxidized Shovel"),
        inventory_image = "m16b_oxidized_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 3 }
        }
    },
    ["sword"] = {
        description = S("Oxidized Sword"),
        inventory_image = "m16b_oxidized_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 5 }
        }
    },
    ["axe"] = {
        description = S("Oxidized Axe"),
        inventory_image = "m16b_oxidized_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 8 }
        }
    }
})
