local S = minetest.get_translator(minetest.get_current_modname())

-- Copper
mcl_armor.register_set({
	name = "copper",
	descriptions = {
		head = S("Copper Helmet"),
		torso = S("Copper Chestplate"),
		legs = S("Copper Leggings"),
		feet = S("Copper Boots"),
	},	durability = 650,
	enchantability = 10,
	points = {
		head = 2,
		torso = 5,
		legs = 4,
		feet = 2,
	},
	craft_material = "mcl_copper:copper_ingot",
	repair_material = "mcl_copper:copper_ingot",
	sound_equip = "mcl_armor_equip_iron",
	sound_unequip = "mcl_armor_unequip_iron",
})

mcl_armor.register_set({
	name = "exposed",
	descriptions = {
		head = S("Exposed Copper Helmet"),
		torso = S("Exposed Copper Chestplate"),
		legs = S("Exposed Copper Leggings"),
		feet = S("Exposed Copper Boots"),
	},	durability = 640,
	enchantability = 12,
	points = {
		head = 3,
		torso = 5,
		legs = 4,
		feet = 2,
	},
	repair_material = "mcl_copper:copper_ingot",
	sound_equip = "mcl_armor_equip_iron",
	sound_unequip = "mcl_armor_unequip_iron",
})

mcl_armor.register_set({
	name = "weathered",
	descriptions = {
		head = S("Weathered Copper Helmet"),
		torso = S("Weathered Copper Chestplate"),
		legs = S("Weathered Copper Leggings"),
		feet = S("Weathered Copper Boots"),
	},	durability = 630,
	enchantability = 14,
	points = {
		head = 3,
		torso = 5,
		legs = 4,
		feet = 3,
	},
	repair_material = "mcl_copper:copper_ingot",
	sound_equip = "mcl_armor_equip_iron",
	sound_unequip = "mcl_armor_unequip_iron",
})

mcl_armor.register_set({
	name = "oxidized",
	descriptions = {
		head = S("Oxidized Copper Helmet"),
		torso = S("Oxidized Copper Chestplate"),
		legs = S("Oxidized Copper Leggings"),
		feet = S("Oxidized Copper Boots"),
	},	durability = 620,
	enchantability = 16,
	points = {
		head = 3,
		torso = 6,
		legs = 4,
		feet = 3,
	},
	repair_material = "mcl_copper:copper_ingot",
	sound_equip = "mcl_armor_equip_iron",
	sound_unequip = "mcl_armor_unequip_iron",
})

local modpath = minetest.get_modpath("m16b_copper_armors_tools")

dofile(modpath .. "/tools.lua")
dofile(modpath .. "/crafting.lua")
