local S = minetest.get_translator(minetest.get_current_modname())
local modpath = minetest.get_modpath("m16b_item_displayed")

-- Item Display
minetest.register_node("m16b_item_displayed:display",{
	description = S("Item Display"),
	_doc_items_longdesc = S("Displays items."),
	drawtype = "mesh",
	mesh = "m16b_display.obj",
	tiles = {"m16b_display.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	walkable = false,
	is_ground_content = false,
	stack_max = 16,
	selection_box = {
		type = "fixed",
			fixed = {-0.4375, -0.5, -0.4375, 0.4375, 0.375, 0.4375},
	},
	groups = {pickaxey = 1, building_block = 1},
	sounds = sounds,
	_mcl_hardness = 1.5,
	_mcl_blast_resistance = 1.5,
})

minetest.register_craft({
	output = "m16b_item_displayed:display",
	recipe = {
		{"", "mcl_core:stick", ""},
		{"mcl_core:stick", "", "mcl_core:stick"},
		{"mcl_core:stick", "mcl_core:stick", "mcl_core:stick"},
	},
})

dofile(modpath .. "/templates.lua")
dofile(modpath .. "/music_discs.lua")
dofile(modpath .. "/converted_crafting.lua")
