local S = minetest.get_translator(minetest.get_current_modname())

mcl_tools = mcl_tools or {}
mcl_tools.sets = mcl_tools.sets or {}
mcl_tools.commondefs = mcl_tools.commondefs or {}
mcl_tools.commondefs["trident"] = {
		longdesc = S("Tridents are powerful weapons, capable of both ranged and melee attacks. Their durability and strength make them formidable in combat."),
		groups = { weapon = 1, trident = 1 },
		diggroups = { swordy = {}, swordy_cobweb = {}, swordy_bamboo = {} },
		_mcl_diggroups = {
			swordy_cobweb = { speed = 15, level = 1, uses = 238 },
			swordy_bamboo = { speed = 45, level = 1, uses = 238 },
		}
	}

local wield_scale = mcl_vars.tool_wield_scale

local function on_tool_place(itemstack, placer, pointed_thing, tool)
	if pointed_thing.type ~= "node" then return end

	local rc = mcl_util.call_on_rightclick(itemstack, placer, pointed_thing)
	if rc ~= nil then return rc end

	if core.is_protected(pointed_thing.under, placer:get_player_name()) then
		core.record_protection_violation(pointed_thing.under, placer:get_player_name())
		return itemstack
	end

	local node = core.get_node(pointed_thing.under)
	local ndef = core.registered_nodes[node.name]
	if not ndef then
		return
	end

	if itemstack and type(ndef["_on_"..tool.."_place"]) == "function" then
		local itemstack, no_wear = ndef["_on_"..tool.."_place"](itemstack, placer, pointed_thing)
		if core.is_creative_enabled(placer:get_player_name()) or no_wear or not itemstack then
			return itemstack
		end

		-- Add wear using the usages of the tool defined in
		-- _mcl_diggroups. This assumes the tool only has one diggroups
		-- (which is the case in Mineclone).
		local tdef = core.registered_tools[itemstack:get_name()]
		if tdef and tdef._mcl_diggroups then
			for group, _ in pairs(tdef._mcl_diggroups) do
				itemstack:add_wear(mcl_autogroup.get_wear(itemstack:get_name(), group))
				return itemstack
			end
		end
		return itemstack
	end

	mcl_offhand.place(placer, pointed_thing)

	return itemstack
end

mcl_tools.tool_place_funcs = {}

function mcl_tools.get_default_tool_place_func(tool)
	return function(itemstack,placer,pointed_thing)
		return on_tool_place(itemstack,placer,pointed_thing,tool)
	end
end

for tool, _ in pairs(mcl_tools.commondefs) do
	mcl_tools.tool_place_funcs[tool] = mcl_tools.get_default_tool_place_func(tool)
end

local function get_tool_diggroups(materialdefs, toolname)
	local diggroups = mcl_tools.commondefs[toolname].diggroups

	for _, diggroup in pairs(diggroups) do
		diggroup.speed = materialdefs.speed
		diggroup.level = materialdefs.level
		diggroup.uses = toolname == "sword" and materialdefs.uses / 2 or materialdefs.uses
	end

	return diggroups
end

local function replace_material_tag(shape, material)
	local recipe = table.copy(shape)

	for _, line in ipairs(recipe) do
		for count, tag in ipairs(line) do
			if tag == "material" then
				line[count] = material
			end
		end
	end

	return recipe
end

local function get_punch_uses(toolname, materialdefs)
	if toolname == "sword" then return materialdefs.uses end
	return materialdefs.uses / 2
end

local function register_tool(setname, materialdefs, toolname, tooldefs, overrides)
	local mod = core.get_current_modname()
	local itemstring = mod..":"..toolname.."_"..setname
	local commondefs = mcl_tools.commondefs[toolname]
	local tcs = table.copy(tooldefs.tool_capabilities or {})
	tooldefs.tool_capabilities = nil
	overrides = table.copy(overrides or {})
	local tcs_overrides = overrides.tool_capabilities or {}
	overrides.tool_capabilities = nil
	local _mcl_diggroups = table.merge(get_tool_diggroups(materialdefs, toolname),
		commondefs._mcl_diggroups)
	local tooldefs = table.merge({
		_doc_items_longdesc = commondefs.longdesc,
		_doc_items_usagehelp = commondefs.usagehelp,
		_mcl_diggroups = _mcl_diggroups,
		_mcl_toollike_wield = true,
		_repair_material = materialdefs.material,
		groups = table.merge(commondefs.groups, materialdefs.groups, { offhand_item = 1 }),
		tool_capabilities = table.merge(tcs, {
			max_drop_level = materialdefs.max_drop_level,
			punch_attack_uses = get_punch_uses(toolname, materialdefs)
		}, tcs_overrides, overrides.toolname),
		on_place = mcl_tools.tool_place_funcs[toolname],
		sound = { breaks = "default_tool_breaks" },
		wield_scale = wield_scale,
		_placement_def = commondefs._placement_def
			or "placeable_on_actionable",
	}, tooldefs, overrides)

	core.register_tool(itemstring, tooldefs)

	if materialdefs.craftable then
		for _, shapes in ipairs(mcl_tools.commondefs[toolname].craft_shapes) do
			local recipe = replace_material_tag(shapes, materialdefs.material)

			core.register_craft({
				output = itemstring,
				recipe = recipe
			})
		end
	end
end

function mcl_tools.add_to_sets(toolname, commondefs, tools, overrides)
	if mcl_tools.commondefs[toolname] then
		local msg = "[mcl_tools] mod '%s' trying to register tool '%s' a second time"
		core.log("error", msg:format(core.get_current_modname(), toolname))
		return
	end

	mcl_tools.commondefs[toolname] = commondefs

	for setname, tooldefs in pairs(tools) do
		local materialdefs = mcl_tools.sets[setname]

		if materialdefs then
			register_tool(setname, materialdefs, toolname, tooldefs, overrides)
		else
			local msg = "[mcl_tools] mod '%s' trying to register tool '%s' for undefined set '%s'; dependency missing?"
			core.log("warning", msg:format(core.get_current_modname(), toolname, setname))
		end
	end
end

function mcl_tools.get_default_tool_place_func(tool)
	return function(itemstack,placer,pointed_thing)
		return on_tool_place(itemstack,placer,pointed_thing,tool)
	end
end

for tool, _ in pairs(mcl_tools.commondefs) do
	mcl_tools.tool_place_funcs[tool] = mcl_tools.get_default_tool_place_func(tool)
end

function mcl_tools.register_set(setname, materialdefs, tools, overrides)
	if mcl_tools.sets[setname] then
		local msg = "[mcl_tools] mod '%s' trying to register set '%s' a second time"
		core.log("error", msg:format(core.get_current_modname(), setname))
		return
	end

	mcl_tools.sets[setname] = materialdefs

	for tool, defs in pairs(tools) do
		if mcl_tools.commondefs[tool] then
			register_tool(setname, materialdefs, tool, defs, overrides)
		else
			local msg = "[mcl_tools] mod '%s' trying to register unknown tool '%s' for set '%s'"
			if tool == "hoe" then
				msg = msg .. "; dependency on 'mcl_farming' is needed"
			else
				msg = msg .. "; dependency missing?"
			end
			core.log("warning", msg:format(core.get_current_modname(), tool, setname))
		end
	end
end

local modpath = minetest.get_modpath("m16b_mystic_stones")
dofile(modpath .. "/tools/enchants.lua")
dofile(modpath .. "/tools/trident.lua")
