local S = minetest.get_translator(minetest.get_current_modname())

-- Tier 1
-- Firestone Coal
minetest.register_craftitem("m16b_mystic_stones:firestone_coal", {
	description = S("Firestone Coal"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_firestone_coal.png",
	groups = { craftitem = 1, coal=1, fire_immune = 1 },
	_mcl_burntime = 1140,
})

minetest.register_craft({
	output = "m16b_mystic_stones:firestone_coal",
	recipe = {
		{"mcl_core:coal_lump", "mcl_core:coal_lump", "mcl_core:coal_lump"},
		{"mcl_core:coal_lump", "m16b_mystic_stones:fire_stone", "mcl_core:coal_lump"},
		{"mcl_core:coal_lump", "mcl_core:coal_lump", "mcl_core:coal_lump"},

	},
})

-- Earth Pick
mcl_tools.register_set("earth", {
    material = "mcl_core:stone",
    craftable = false,
    uses = 2700,
    level = 6,
    speed = 9.5,
    max_drop_level = 5,
    groups = { dig_speed_class = 6, fire_immune = 1, enchantability = 15 }
}, {
    ["pick"] = {
        description = S("Earth Pick"),
        inventory_image = "m16b_earth_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.79,
            damage_groups = { fleshy = 5 }
        }
    }
})

minetest.register_craft({
	output = "m16b_mystic_stones:pick_earth",
	recipe = {
		{"mcl_core:stone_smooth", "mcl_raw_ores:raw_iron_block", "mcl_core:stone_smooth"},
		{"", "m16b_mystic_stones:earth_stone", ""},
		{"", "mcl_core:diamond", ""},

	},
})

-- Air Wings --
minetest.register_tool("m16b_mystic_stones:air_wings", {
	description = S("Air Wings"),
	_doc_items_longdesc = mcl_armor.longdesc,
	_doc_items_usagehelp = mcl_armor.usage,
	inventory_image = "m16b_inv_air_wings.png",
	groups = {
		armor = 1,
		armor_torso = 1,
		mcl_armor_uses = 1000,
		elytra = 1,
		enchantability = 9,
		rarity = 3,
        fire_immune = 1,
	},
	sounds = {
		_mcl_armor_equip = "mcl_armor_equip_leather",
		_mcl_armor_unequip = "mcl_armor_unequip_leather",
	},
	on_place = mcl_armor.equip_on_use,
	on_secondary_use = mcl_armor.equip_on_use,
	_mcl_armor_element = "torso",
	_mcl_armor_texture = "m16b_air_wings.png",
	_on_repair = mcl_armor.reenable_elytra,
})

minetest.register_craft({
    output = "m16b_mystic_stones:air_wings",
    recipe = {
        { "mcl_mobitems:feather", "mcl_wool:white", "mcl_mobitems:feather" },
        { "mcl_mobitems:feather", "m16b_mystic_stones:air_stone", "mcl_mobitems:feather" },
        { "mcl_mobitems:feather", "", "mcl_mobitems:feather" },
    },
})

-- Tier 2

-- Dovrebbe avere già fire aspect al crafting
-- Il fire aspect deve essere molto alto
-- Flame Sword (WIP)
mcl_tools.register_set("flame", {
    material = "mcl_mobitems:blaze_rod",
    craftable = false,
    uses = 3500,
    level = 6,
    speed = 1,
    max_drop_level = 5,
    groups = { dig_speed_class = 6, fire_immune = 1, enchantability = 15 }
}, {
    ["sword"] = {
        description = S("Flame Sword (WIP)"),
        inventory_image = "m16b_flame_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.79,
            damage_groups = { fleshy = 16 }
        }
    }
})  

minetest.register_craft({
	output = "m16b_mystic_stones:sword_flame",
	recipe = {
		{"mcl_fire:fire_charge", "mcl_nether:magma", "mcl_fire:fire_charge"},
		{"mcl_fire:fire_charge", "m16b_mystic_stones:flame_stone", "mcl_fire:fire_charge"},
		{"mcl_buckets:bucket_lava", "mcl_mobitems:blaze_rod", "mcl_buckets:bucket_lava"},

	},
})

-- River Armor
mcl_armor.register_set({
	name = "river",
	descriptions = {
		head = S("River Helmet"),
		torso = S("River Chestplate"),
		legs = S("River Leggings"),
		feet = S("River Boots"),        
	},
	groups = {rarity = 1, fire_immune = 1 },
	durability = 2500,
	enchantability = 13,
	points = {
		head = 7,
		torso = 8,
		legs = 8,
		feet = 7,
	},
	repair_material = "mcl_ocean:prismarine",
	sound_equip = "mcl_armor_equip_iron",
	sound_unequip = "mcl_armor_unequip_iron",
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_river",
	recipe = {
        {"mcl_ocean:prismarine", "m16b_mystic_stones:river_stone", "mcl_ocean:prismarine"},
        {"mcl_ocean:prismarine", "", "mcl_ocean:prismarine"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_river",
	recipe = {
        {"mcl_ocean:prismarine", "", "mcl_ocean:prismarine"},
        {"mcl_ocean:prismarine", "m16b_mystic_stones:river_stone", "mcl_ocean:prismarine"},
        {"mcl_ocean:prismarine", "mcl_ocean:prismarine", "mcl_ocean:prismarine"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_river",
	recipe = {
        {"mcl_ocean:prismarine", "mcl_ocean:prismarine", "mcl_ocean:prismarine"},
        {"mcl_ocean:prismarine", "m16b_mystic_stones:river_stone", ""},
        {"mcl_ocean:prismarine", "", "mcl_ocean:prismarine"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_river",
	recipe = {
        {"", "", ""},
        {"mcl_ocean:prismarine", "m16b_mystic_stones:river_stone", "mcl_ocean:prismarine"},
        {"mcl_ocean:prismarine", "mcl_ocean:prismarine", "mcl_ocean:prismarine"},

	},
})

-- Tier 3
-- Death Sword
mcl_tools.register_set("death", {
    material = "mcl_nether:soul_sand",
    craftable = false,
    uses = 100,
    level = 6,
    speed = 9.5,
    max_drop_level = 5,
    groups = { dig_speed_class = 6, fire_immune = 1 }
}, {
    ["sword"] = {
        description = S("Death Sword"),
        inventory_image = "m16b_death_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.79,
            damage_groups = { fleshy = 100 }
        }
    }
})

minetest.register_craft({
	output = "m16b_mystic_stones:sword_death",
	recipe = {
		{"mcl_nether:soul_sand", "mcl_heads:wither_skeleton", "mcl_nether:soul_sand"},
		{"mcl_flowers:wither_rose", "m16b_mystic_stones:death_stone", "mcl_flowers:wither_rose"},
		{"mcl_flowers:wither_rose", "mcl_flowers:wither_rose", "mcl_flowers:wither_rose"},

	},
})

-- Wand of lightnings
minetest.register_tool("m16b_mystic_stones:wand_of_lightings", {
	description = "Wand of Lightnings",
	inventory_image = "m16b_wand.png",
	range = 10,
	groups = { tool = 1, fire_immune = 1 },
	wield_scale = 2,

	on_use = function(itemstack, user, pointed_thing)
		if not pointed_thing then return end

		if pointed_thing.type == "object" then
			lightning.strike(pointed_thing.ref:get_pos())
		elseif pointed_thing.type == "node" then
			lightning.strike(pointed_thing.above)
		else
			return
		end

		if not minetest.is_creative_enabled(user:get_player_name()) then
			-- The wand has 5000 uses
        	itemstack:add_wear(65535 / 5000)
		end

		-- Without making sure the player is alive with user:get_hp() > 0, the player can duplicate the wand by committing
		-- suicide with the wand, b/c they'll get the wand back after death
		if user:get_hp() > 0 then
        	return itemstack
		end
    end
})

minetest.register_craft({
    output = "m16b_mystic_stones:wand_of_lightings",
    recipe = {
        { "mcl_copper:copper_ingot", "mcl_lightning_rods:rod", "mcl_copper:copper_ingot" },
        { "", "m16b_mystic_stones:dungeon_stone", "" },
        { "", "mcl_lightning_rods:rod", "" },
    },
})


-- Tier 4


--[[
-- Dovrebbe dare al giocatore un effetto do water breathing di 12 minuti
-- Da sistemare e da studiare un modo per dare l'effetto al giocatore quando viene mangiato l'oggetto.

-- Stone Of Water Breathing
minetest.register_craftitem("m16b_mystic_stones:water_breathing_stone", {
	description = S("Stone Of Water Breathing (WIP)"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_water_breathing_stone.png",
	groups = { craftitem = 1, fire_immune = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:water_breathing_stone",
	recipe = {
		{"mcl_ocean_kelp", "mcl_potions:water_breathing", "mcl_flowers:waterlily"},
		{"mcl_potions:water_breathing", "m16b_mystic_stones:water_stone", "mcl_potions:water_breathing"},
		{"mcl_flowers:waterlily", "mcl_potions:water_breathing", "mcl_ocean_kelp"},

	},
})

-- Tier 2

-- River Armor
mcl_armor.register_set({
	name = "river",
	descriptions = {
		head = S("River Helmet"),
		torso = S("River Chestplate"),
		legs = S("River Leggings"),
		feet = S("River Boots"),        
	},
	groups = {rarity = 1},
	durability = 2500,
	enchantability = 13,
	points = {
		head = 7,
		torso = 8,
		legs = 8,
		feet = 7,
	},
	repair_material = "mcl_ocean:prismarine",
	sound_equip = "mcl_armor_equip_iron",
	sound_unequip = "mcl_armor_unequip_iron",
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_river",
	recipe = {
        {"mcl_ocean:prismarine", "m16b_mystic_stones:river_stone", "mcl_ocean:prismarine"},
        {"mcl_ocean:prismarine", "", "mcl_ocean:prismarine"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_river",
	recipe = {
        {"mcl_ocean:prismarine", "", "mcl_ocean:prismarine"},
        {"mcl_ocean:prismarine", "m16b_mystic_stones:river_stone", "mcl_ocean:prismarine"},
        {"mcl_ocean:prismarine", "mcl_ocean:prismarine", "mcl_ocean:prismarine"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_river",
	recipe = {
        {"mcl_ocean:prismarine", "mcl_ocean:prismarine", "mcl_ocean:prismarine"},
        {"mcl_ocean:prismarine", "m16b_mystic_stones:river_stone", ""},
        {"mcl_ocean:prismarine", "", "mcl_ocean:prismarine"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_river",
	recipe = {
        {"", "", ""},
        {"mcl_ocean:prismarine", "m16b_mystic_stones:river_stone", "mcl_ocean:prismarine"},
        {"mcl_ocean:prismarine", "mcl_ocean:prismarine", "mcl_ocean:prismarine"},

	},
})

-- Dovrebbe avere fortuna incorporato

-- Cave Pick
mcl_tools.register_set("cave", {
    material = "mcl_deepslate:deepslate",
    craftable = false,
    uses = 3000,
    level = 6,
    speed = 9.5,
    max_drop_level = 5,
    groups = { dig_speed_class = 6, fire_immune = 1 }
}, {
    ["pick"] = {
        description = S("Cave Pick"),
        inventory_image = "m16b_cave_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.79,
            damage_groups = { fleshy = 6 }
        }
    }
})

minetest.register_craft({
	output = "m16b_mystic_stones:pick_cave",
	recipe = {
		{"mcl_deepslate:deepslate", "m16b_mystic_stones:pick_earth", "mcl_deepslate:deepslate"},
		{"", "m16b_mystic_stones:cave_stone", ""},
		{"", "mcl_core:diamond", ""},

	},
})

-- End Cannon
-- Spara delle ender pearl ad una distanza maggiore

-- Da fare
-- Potere del vento (wind stone)
-- (spara wind charge???)
-- Potere del wither (wither stone)

-- Tier 3
-- potere dell'end (end stone)
-- teletrasporto nell'end (0.0, -26997.5, 0.0)
-- potere infernale (infernal stone)
-- armatura con immunità dal fuoco???
-- potere oceanico (ocean stone)
-- rispirazione in acqua infinita??????
-- più depth strider
-- potere minerale (mineral stone)
-- piccone con fortuna che spacca un 3x3???

-- Tier 4
-- potere tsunami (tsunami stone)
-- rigenerazione in acqua???
-- potere ender (ender stone)
-- Casco anti enderman (zucca intagliata)
-- potere master (master stone)
-- volare??

-- Tier 5
-- potere dragon (dragon stone)
-- spara palle di fuoco di drago???
-- potere proibito (forbidden stone)
-- Testa Herobrine con poteri
-- spawnare entità alleate e noclip
]]--
