local S = core.get_translator(core.get_current_modname())

core.register_craftitem("m16b_mystic_stones:fire_wheat_seeds", {
	description = S("Fire Wheat Seeds"),
	_tt_help = S("Grows on fire farmland"),
	_doc_items_longdesc = S("Grows into a fire wheat plant."),
	_doc_items_usagehelp = S([[
		Place the fire wheat seeds on fire farmland (which can be created with a hoe) to plant a fire wheat plant.
		They grow in sunlight and grow faster on hydrated fire farmland.
	]]),
	groups = {craftitem = 1, compostability = 60},
	inventory_image = "m16b_fire_wheat_seeds.png",
	_mcl_places_plant = "m16b_mystic_stones:fire_wheat_1",
	on_place = function(itemstack, placer, pointed_thing)
		return mcl_farming:place_seed(itemstack, placer, pointed_thing, "m16b_mystic_stones:fire_wheat_1")
	end
})

local sel_heights = {
	-0.5+(5/16),
	-0.5+(8/16),
	-0.5+(10/16),
	-0.5+(12/16),
	-0.5+(13/16),
	-0.5+(14/16),
	-0.5+(15/16),
	-0.5+(16/16),
}

for i=1,7 do
	local create, name, longdesc
	if i == 1 then
		create = true
		name = S("Premature Fire Wheat Plant")
		longdesc = S([[
			Premature fire wheat plants grow on fire farmland under sunlight in 8 stages.
			On hydrated fire farmland, they grow faster. They can be harvested at any time but will only yield a profit when mature.
		]])
	else
		create = false
	end

	core.register_node("m16b_mystic_stones:fire_wheat_"..i, {
		description = S("Premature Fire Wheat Plant (Stage @1)", i),
		_doc_items_create_entry = create,
		_doc_items_entry_name = name,
		_doc_items_longdesc = longdesc,
		paramtype = "light",
		paramtype2 = "meshoptions",
		place_param2 = 3,
		sunlight_propagates = true,
		walkable = false,
		drawtype = "plantlike",
		drop = "m16b_mystic_stones:fire_wheat_seeds",
		tiles = {"m16b_fire_wheat_stage_"..(i-1)..".png"},
		inventory_image = "m16b_fire_wheat_stage_"..(i-1)..".png",
		wield_image = "m16b_fire_wheat_stage_"..(i-1)..".png",
		selection_box = {
			type = "fixed",
			fixed = {
				{-7/16, -0.5 ,-7/16, 7/16, sel_heights[i] ,7/16}
			},
		},
		groups = {dig_immediate=3, not_in_creative_inventory=1, plant=1,attached_node=1,
			dig_by_water=1,destroy_by_lava_flow=1, dig_by_piston=1, unsticky = 1},
		sounds = mcl_sounds.node_sound_leaves_defaults(),
		_mcl_hardness = 0,
		_mcl_baseitem = "m16b_mystic_stones:fire_wheat_seeds",
	})
end

core.register_node("m16b_mystic_stones:fire_wheat", {
	description = S("Mature Fire Wheat Plant"),
	_doc_items_longdesc = S([[
		Mature fire wheat plants are ready to be harvested for fire wheat and fire wheat seeds.
		They won't grow any further.
	]]),
	sunlight_propagates = true,
	paramtype = "light",
	paramtype2 = "meshoptions",
	place_param2 = 3,
	walkable = false,
	drawtype = "plantlike",
	tiles = {"m16b_fire_wheat_stage_7.png"},
	inventory_image = "m16b_fire_wheat_stage_7.png",
	wield_image = "m16b_fire_wheat_stage_7.png",
	drop = {
		max_items = 4,
		items = {
			{ items = {"m16b_mystic_stones:fire_wheat_seeds"} },
			{ items = {"m16b_mystic_stones:fire_wheat_seeds"}, rarity = 2},
			{ items = {"m16b_mystic_stones:fire_wheat_seeds"}, rarity = 5},
			{ items = {"m16b_mystic_stones:fire_wheat_item"} }
		}
	},
	groups = {dig_immediate=3, not_in_creative_inventory=1, plant=1, attached_node=1,
		dig_by_water=1,destroy_by_lava_flow=1, dig_by_piston=1, unsticky = 1},
	sounds = mcl_sounds.node_sound_leaves_defaults(),
	_mcl_hardness = 0,
	_mcl_fortune_drop = {
		discrete_uniform_distribution = true,
		items = {"m16b_mystic_stones:fire_wheat_seeds"},
		drop_without_fortune = {"m16b_mystic_stones:fire_wheat_item"},
		min_count = 1,
		max_count = 6,
		cap = 7
	},
	_mcl_baseitem = "m16b_mystic_stones:fire_wheat_seeds",
})

mcl_farming:add_plant("plant_fire_wheat", "m16b_mystic_stones:fire_wheat", {"m16b_mystic_stones:fire_wheat_1", "m16b_mystic_stones:fire_wheat_2", "m16b_mystic_stones:fire_wheat_3", "m16b_mystic_stones:fire_wheat_4", "m16b_mystic_stones:fire_wheat_5", "m16b_mystic_stones:fire_wheat_6", "m16b_mystic_stones:fire_wheat_7"}, 25, 20)

core.register_craftitem("m16b_mystic_stones:fire_wheat_item", {
	description = S("Fire Wheat"),
	_doc_items_longdesc = S("Fire Wheat is used in crafting."),
	_doc_items_usagehelp = S(""),
	inventory_image = "m16b_fire_wheat_harvested.png",
	groups = {craftitem = 1, compostability = 130},
})

local mod_screwdriver = core.get_modpath("screwdriver")
local on_rotate
if mod_screwdriver then
	on_rotate = screwdriver.rotate_3way
end

if core.get_modpath("doc") then
	for i=2,7 do
		doc.add_entry_alias("nodes", "m16b_mystic_stones:fire_wheat_1", "nodes", "m16b_mystic_stones:fire_wheat_"..i)
	end
end


local modpath = minetest.get_modpath("m16b_mystic_stones")

dofile(modpath .. "/plants/food.lua")
