local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)
--[[
local function get_story_book(cpos)
	local stack = ItemStack("mcl_books:written_book")
	local bookmeta = stack:get_meta()
	
	bookmeta:set_string("title", "Ancient House")
	bookmeta:set_string("author", "Unknown")
	bookmeta:set_string("description", "Unknown")

-- Ancient House story
	local pages = {
		"If you're reading this, it means I failed to defend the village.\nI was living in a peaceful and beautiful village when it happened...",
		"A stranger entered the village. We immediately welcomed him and took him around the village to see the various structures.\nFor a few months, everything seemed calm until the stranger didn't run away from the village.",
		"We didn't ask ourselves why he did it; we thought he was simply going to get supplies, but he disappeared.\nFrom the day he disappeared, the village was never the same:",
		"On the first day, pillagers attacked the village and destroyed many of the structures. On the second day, a huge storm set fire to many more, but that was only the beginning.",
		"On the third and fourth day, nothing happened, but the other villagers and I were still nervous because we didn't know when the next catastrophe might strike.",
		"On the fifth day, everything seemed calm, but he returned.\nThe stranger returned to the village, and within a day, the entire village was rebuilt.",
		"For weeks, we tried to ask him where he had gone or what he had done, but he wouldn't answer any of our questions.\nYears passed after his return, when terrible news arrived: the stranger was dead.",
		"As soon as they heard this news, the entire village began to reinforce the walls, add defenses, recruit soldiers, place lightning rods everywhere, and prepare for anything.",
		"But the one thing no one would have expected happened: one day, a miner found an underground structure with a chest.\nInside, there was a strange stone and a note.",
		"It was written in an ancient, arcane language that no one had ever seen before: it probably contained a warning about that strange stone, but we probably didn't follow it.",
		"A few days later, wizards and clerics were trying to understand the purpose of that strange stone when the houses began to sink into the ground.",
		"When it happened, I was inside my house and sank into the ground with it.\nFrom that moment on, I decided to write down what happened so that perhaps, in the future, someone would find this house and this book.",
		"In case you're reading this book, know this:\nThat stone had a strange design on it; it looked like a cave, but it also contained minerals.",
		"Anyway, I've been waiting for days for someone to find me; I'm starving and starting to run out of oxygen.\nI hope the other villagers are safe."
	}

	local fulltext = table.concat(pages, "\f")  -- "\f" is the page separator
	bookmeta:set_string("text", fulltext)

	return stack
end
]]--

-- Cloud Boat

mcl_structures.register_structure("cloud_boat",{
	place_on = {"mcl_core:packed_ice", "mcl_core:snowblock", "mcl_core:ice"},
	flags = "all_floors",
	solid_ground = true,
	make_foundation = true,
	chunk_probability = 1,
    y_max = 60,
    y_min = 1,
	biomes = { "IcePlainsSpikes", "IcePlains", "ColdTaiga", "Taiga", "MegaTaiga", "MegaSpruceTaiga" },
	sidelen = 20,
	filenames = {
		modpath.."/structures/schematics/m16b_cloud_boat.mts",
		modpath.."/structures/schematics/m16b_cloud_boat_treasure.mts",
		modpath.."/structures/schematics/m16b_cloud_boat_treasure_2.mts",
	},

loot = {
  ["mcl_chests:chest_small"] = {{
    stacks_min = 6,
    stacks_max = 8,
    items = {
      -- (100%)
      { itemstring = "mcl_mobitems:feather", weight = 100, amount_min = 5, amount_max = 10 },
      { itemstring = "mcl_books:book", weight = 100, func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end },   
      { itemstring = "mcl_core:glass", weight = 100, amount_min = 5, amount_max = 5 },
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 2, amount_max = 2 },
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 2, amount_max = 2 },
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 1, amount_max = 1 },

      -- (90%)
      { itemstring = "mcl_charges:wind_charge", weight = 90, amount_min = 1, amount_max = 3 },
      { itemstring = "mcl_core:diamond", weight = 90, amount_min = 1, amount_max = 2 },

      -- (70%)
      { itemstring = "mcl_charges:wind_charge", weight = 70, amount_min = 4, amount_max = 4 },
      { itemstring = "mcl_mobitems:breeze_rod", weight = 70, amount_min = 1, amount_max = 2 },

      --(50%)
      { itemstring = "m16b_mystic_stones:breeze_pillar", weight = 50, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_core:diamond", weight = 50, amount_min = 3, amount_max = 6 },
      { itemstring = "mcl_charges:wind_charge", weight = 50, amount_min = 5, amount_max = 10 },
      { itemstring = "mcl_core:glass", weight = 50, amount_min = 10, amount_max = 10 },

      -- (40%)
      { itemstring = "mcl_mobitems:breeze_rod", weight = 40, amount_min = 3, amount_max = 5 },
      { itemstring = "m16b_mystic_stones:breeze_brick", weight = 40, amount_min = 1, amount_max = 2 },
      { itemstring = "m16b_mystic_stones:breeze_block", weight = 40, amount_min = 1, amount_max = 2 },

      --(30%)
      { itemstring = "m16b_mystic_stones:breeze_pillar", weight = 30, amount_min = 2, amount_max = 4 },
      { itemstring = "mcl_core:sugar", weight = 30, amount_min = 3, amount_max = 7 },

--[[
      -- (25%)
      { itemstring = "mcl_books:written_book", weight = 25, func = function(stack, pr, pos)
	      local book = get_story_book(pos)
	      return book
      end },
]]--

      -- (20%)
      { itemstring = "m16b_mystic_stones:breeze_brick", weight = 20, amount_min = 3, amount_max = 5 },
      { itemstring = "m16b_mystic_stones:breeze_block", weight = 20, amount_min = 3, amount_max = 5 },
      { itemstring = "mcl_compass:compass", weight = 20, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_clock:clock", weight = 20, amount_min = 1, amount_max = 1 },

      -- (10%)
      { itemstring = "mcl_heads:zombie", weight = 10, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_sus_nodes:brush", weight = 10, amount_min = 1, amount_max = 1 },
      { itemstring = "m16b_mystic_stones:air_stone", weight = 10, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_core:diamond", weight = 10, amount_min = 5, amount_max = 10 },
      { itemstring = "mcl_candles:candle_1", weight = 10, amount_min = 5, amount_max = 15 },
      { itemstring = "mcl_potions:dragon_breath", weight = 10, amount_min = 1, amount_max = 3 },

      -- (5%)
      { itemstring = "mcl_heads:skeleton", weight = 5, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_mobitems:ghast_tear", weight = 5, amount_min = 5, amount_max = 5 },
      { itemstring = "m16b_mystic_stones:air_wings", weight = 5, amount_min = 1, amount_max = 1 },

      -- (2%)
      { itemstring = "mcl_throwing:ender_pearl", weight = 2, amount_min = 1, amount_max = 3 },
      { itemstring = "m16b_mystic_stones:wind_stone", weight = 10, amount_min = 1, amount_max = 1 },

      -- (1%)
      { itemstring = "air", weight = 1, amount_min = 0, amount_max = 1 },

    }
  }}
},

--[[
after_place = function(pos, rotation, pr)
	local chests = minetest.find_nodes_in_area_under_air(
		vector.offset(pos, -8, 0, -8),
		vector.offset(pos, 8, 2, 8),
		{"mcl_chests:chest_small"}
	)
	if chests and #chests > 0 then
		local chest_pos = chests[pr:next(1, #chests)]
		local inv = minetest.get_meta(chest_pos):get_inventory()
		inv:add_item("main", get_story_book(chest_pos))
	end
end,
]]--

})
