local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)

--[[
local function get_story_book2(cpos)
	local stack = ItemStack("mcl_books:written_book")
	local bookmeta = stack:get_meta()
	
	bookmeta:set_string("title", "Nether Camp")
	bookmeta:set_string("author", "Unknown")
	bookmeta:set_string("description", "Unknown")


-- Ancient House Story
	local pages = {
		"If you're reading this, it means I failed to defend the village.\nI was living in a peaceful and beautiful village when it happened...",
		"A stranger entered the village. We immediately welcomed him and took him around the village to see the various structures.\nFor a few months, everything seemed calm until the stranger didn't run away from the village.",
		"We didn't ask ourselves why he did it; we thought he was simply going to get supplies, but he disappeared.\nFrom the day he disappeared, the village was never the same:",
		"On the first day, pillagers attacked the village and destroyed many of the structures. On the second day, a huge storm set fire to many more, but that was only the beginning.",
		"On the third and fourth day, nothing happened, but the other villagers and I were still nervous because we didn't know when the next catastrophe might strike.",
		"On the fifth day, everything seemed calm, but he returned.\nThe stranger returned to the village, and within a day, the entire village was rebuilt.",
		"For weeks, we tried to ask him where he had gone or what he had done, but he wouldn't answer any of our questions.\nYears passed after his return, when terrible news arrived: the stranger was dead.",
		"As soon as they heard this news, the entire village began to reinforce the walls, add defenses, recruit soldiers, place lightning rods everywhere, and prepare for anything.",
		"But the one thing no one would have expected happened: one day, a miner found an underground structure with a chest.\nInside, there was a strange stone and a note.",
		"It was written in an ancient, arcane language that no one had ever seen before: it probably contained a warning about that strange stone, but we probably didn't follow it.",
		"A few days later, wizards and clerics were trying to understand the purpose of that strange stone when the houses began to sink into the ground.",
		"When it happened, I was inside my house and sank into the ground with it.\nFrom that moment on, I decided to write down what happened so that perhaps, in the future, someone would find this house and this book.",
		"In case you're reading this book, know this:\nThat stone had a strange design on it; it looked like a cave, but it also contained minerals.",
		"Anyway, I've been waiting for days for someone to find me; I'm starving and starting to run out of oxygen.\nI hope the other villagers are safe."
	}

	local fulltext = table.concat(pages, "\f")  -- "\f" is the page separator
	bookmeta:set_string("text", fulltext)

	return stack
end
]]--

-- Varkal Castel

mcl_structures.register_structure("varkal_castle", {
    place_on = {"mcl_core:grass_block", "mcl_core:dirt_with_grass", "mcl_core:stone"},
    flags = "all_floors",
    solid_ground = true,
    make_foundation = true,
    chunk_probability = 1,
    y_max = 100,
    y_min = 5,
    biomes = { "Plains", "Forest", "SunflowerPlains" },
    sidelen = 80,
    filenames = {
        modpath.."/structures/schematics/m16b_varkal_castle.mts",
    },

    after_place = function(pos)
        local p1 = vector.offset(pos, -40, -5, -40)
        local p2 = vector.offset(pos, 40, 40, 40)

        -- Esempio: attiva spawner o altri nodi
        local spawners = core.find_nodes_in_area(p1, p2, {"mcl_mobspawners:spawner"})
        for _, sp in pairs(spawners) do
            mcl_mobspawners.setup_spawner(sp, "mobs_mc:skeleton", 0, 14, 10, 8, 0)
        end
    end,

    loot = {
        ["mcl_chests:chest_small"] = {{
            stacks_min = 6,
            stacks_max = 10,
            items = {
                { itemstring = "mcl_core:apple_gold", weight = 80, amount_min = 1, amount_max = 2 },
                { itemstring = "mcl_armor:helmet_iron", weight = 60, amount_min = 1 },
                { itemstring = "mcl_armor:chestplate_iron", weight = 50, amount_min = 1 },
                { itemstring = "mcl_armor:leggings_iron", weight = 50, amount_min = 1 },
                { itemstring = "mcl_armor:boots_iron", weight = 50, amount_min = 1 },
                { itemstring = "mcl_weapons:sword_iron", weight = 40, amount_min = 1 },
                { itemstring = "mcl_mobitems:bone", weight = 90, amount_min = 3, amount_max = 7 },
                { itemstring = "mcl_enchanting:lapis", weight = 70, amount_min = 1, amount_max = 5 },
                { itemstring = "mcl_experience:bottle", weight = 60, amount_min = 2, amount_max = 3 },
                { itemstring = "mcl_books:book", weight = 30, func = function(stack, pr)mcl_enchanting.enchant_uniform_randomly(stack, {"protection", "sharpness", "power"}, pr)end },
            }
        }},
    }

--[[
after_place = function(pos, rotation, pr)
	local chests = minetest.find_nodes_in_area_under_air(
		vector.offset(pos, -6, -4, -6),
		vector.offset(pos, 6, 4, 6),
		{"mcl_chests:chest_small"}
	)
	if chests and #chests > 0 then
		local chest_pos = chests[pr:next(1, #chests)]
		local inv = minetest.get_meta(chest_pos):get_inventory()
		inv:add_item("main", ItemStack("mcl_ocean:prismarine")) -- per esempio
	end
end,
]]--

})
