local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)

local function get_story_book(cpos)
	local stack = ItemStack("mcl_books:written_book")
	local bookmeta = stack:get_meta()
	
	bookmeta:set_string("title", "Ancient House")
	bookmeta:set_string("author", "Unknown")
	bookmeta:set_string("description", "Unknown")

	local pages = {
		"If you're reading this, it means I failed to defend the village.\nI was living in a peaceful and beautiful village when it happened...",
		"A stranger entered the village. We immediately welcomed him and took him around the village to see the various structures.\nFor a few months, everything seemed calm until the stranger didn't run away from the village.",
		"We didn't ask ourselves why he did it; we thought he was simply going to get supplies, but he disappeared.\nFrom the day he disappeared, the village was never the same:",
		"On the first day, pillagers attacked the village and destroyed many of the structures. On the second day, a huge storm set fire to many more, but that was only the beginning.",
		"On the third and fourth day, nothing happened, but the other villagers and I were still nervous because we didn't know when the next catastrophe might strike.",
		"On the fifth day, everything seemed calm, but he returned.\nThe stranger returned to the village, and within a day, the entire village was rebuilt.",
		"For weeks, we tried to ask him where he had gone or what he had done, but he wouldn't answer any of our questions.\nYears passed after his return, when terrible news arrived: the stranger was dead.",
		"As soon as they heard this news, the entire village began to reinforce the walls, add defenses, recruit soldiers, place lightning rods everywhere, and prepare for anything.",
		"But the one thing no one would have expected happened: one day, a miner found an underground structure with a chest.\nInside, there was a strange stone and a note.",
		"It was written in an ancient, arcane language that no one had ever seen before: it probably contained a warning about that strange stone, but we probably didn't follow it.",
		"A few days later, wizards and clerics were trying to understand the purpose of that strange stone when the houses began to sink into the ground.",
		"When it happened, I was inside my house and sank into the ground with it.\nFrom that moment on, I decided to write down what happened so that perhaps, in the future, someone would find this house and this book.",
		"In case you're reading this book, know this:\nThat stone had a strange design on it; it looked like a cave, but it also contained minerals.",
		"Anyway, I've been waiting for days for someone to find me; I'm starving and starting to run out of oxygen.\nI hope the other villagers are safe."
	}

	local fulltext = table.concat(pages, "\f")  -- "\f" is the page separator
	bookmeta:set_string("text", fulltext)

	return stack
end

-- Ancient House

mcl_structures.register_structure("ancient_house",{
	place_on = {"mcl_deepslate:deepslate","mcl_sculk:sculk"},
	flags = "all_floors",
	solid_ground = true,
	make_foundation = true,
	chunk_probability = 1, --high prob since placement underground is relatively unlikely
    y_max = 12,
    y_min = -120,
	biomes = { "DeepDark" },
	sidelen = 32,
	filenames = {
		modpath.."/structures/schematics/m16b_ancient_house.mts",
		modpath.."/structures/schematics/m16b_ancient_house_2.mts",
	},

loot = {
  ["mcl_chests:chest_small"] = {{
    stacks_min = 6,
    stacks_max = 8,
    items = {
      -- (100%)
      { itemstring = "mcl_sculk:vein", weight = 100, amount_min = 1, amount_max = 3 },
      { itemstring = "mcl_mobitems:nametag", weight = 100, amount_min = 1, amount_max = 1 },

      -- (80%)
      { itemstring = "mcl_books:book", weight = 80, func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"mending"}, pr) end },

      --(50%)
      { itemstring = "mcl_copper:block_oxidized", weight = 50, amount_min = 1, amount_max = 1 },
      { itemstring = "m16b_mystic_stones:ancient_ingot", weight = 50, amount_min = 1, amount_max = 2 },

      -- (40%)
      { itemstring = "m16b_mystic_stones:shovel_ancient", weight = 40, amount_min = 1, amount_max = 1 },

      -- (25%)
      { itemstring = "mcl_armor:silence", weight = 25, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_armor:rib", weight = 25, amount_min = 2, amount_max = 2 },
      { itemstring = "mcl_books:written_book", weight = 25, func = function(stack, pr, pos)
	      local book = get_story_book(pos)
	      return book
      end },
      { itemstring = "mcl_core:apple_gold", weight = 25, amount_min = 3, amount_max = 3 },

      -- (20%)
      { itemstring = "m16b_mystic_stones:sword_ancient", weight = 20, amount_min = 1, amount_max = 1 },

      -- (15%)
      { itemstring = "m16b_mystic_stones:axe_ancient", weight = 15, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_sculk:sculk", weight = 15, amount_min = 4, amount_max = 10 },
      { itemstring = "m16b_mystic_stones:pick_ancient", weight = 15, amount_min = 1, amount_max = 1 },

      -- (10%)
      { itemstring = "mcl_sculk:catalyst", weight = 10, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_sculk:echo_shard", weight = 10, amount_min = 1, amount_max = 1 },
      { itemstring = "m16b_mystic_stones:stone", weight = 10, amount_min = 3, amount_max = 3 },

      -- (5%)
      { itemstring = "m16b_mystic_stones:ancient_ingot_block", weight = 5, amount_min = 1, amount_max = 1 },
      { itemstring = "m16b_mystic_stones:helmet_ancient", weight = 5 },
      { itemstring = "m16b_mystic_stones:chestplate_ancient", weight = 5 },
      { itemstring = "m16b_mystic_stones:leggings_ancient", weight = 5 },
      { itemstring = "m16b_mystic_stones:boots_ancient", weight = 5 },

      -- (2%)
      { itemstring = "m16b_mystic_stones:mineral_stone", weight = 2, amount_min = 1, amount_max = 1 },
    }
  }}
},

after_place = function(pos, rotation, pr)
	local chests = minetest.find_nodes_in_area_under_air(
		vector.offset(pos, -8, 0, -8),
		vector.offset(pos, 8, 2, 8),
		{"mcl_chests:chest_small"}
	)
	if chests and #chests > 0 then
		local chest_pos = chests[pr:next(1, #chests)]
		local inv = minetest.get_meta(chest_pos):get_inventory()
		inv:add_item("main", get_story_book(chest_pos))
	end
end,

})
