local S = minetest.get_translator(minetest.get_current_modname())

-- Lightning Tree
core.register_node("m16b_mystic_stones:lightning_tree",{
	description=S("Lightning Tree"),
tiles = {
		"m16b_light_tree_top.png",
		"m16b_light_tree_top.png",
		"m16b_light_tree_side.png",
		"m16b_light_tree_side.png",
		"m16b_light_tree_side.png",
		"m16b_light_tree_side.png"
	},
	groups = { handy = 1, axey = 1, material_wood=1, deco_block=1, mystic_stones_secondary = 1},
	_mcl_hardness = 1.5,
	_mcl_blast_resistance = 6,
})

-- Lightning Wood
core.register_node("m16b_mystic_stones:lightning_wood",{
	description=S("Lightning Wood"),
tiles = {"m16b_lightning_wood.png"},
	groups = { handy = 1, axey = 1, material_wood=1, deco_block=1, mystic_stones_secondary = 1},
	_mcl_hardness = 1.5,
	_mcl_blast_resistance = 6,
})

minetest.register_craft({
	output = "m16b_mystic_stones:lightning_wood 4",
	recipe = {
		{"m16b_mystic_stones:lightning_tree"},

	},
})

-- Lightning Slab and Stair
mcl_stairs.register_stair_and_slab("lightning_wood", {
	baseitem = "m16b_mystic_stones:lightning_wood",
	description_stair = S("Lightning Wood Stairs"),
	description_slab = S("Lightning Wood Slab"),
	overrides = {_mcl_stonecutter_recipes = { "m16b_mystic_stones:lightning_wood" }}
})

-- Lightning Door
mcl_doors:register_door("m16b_mystic_stones:lightning_door", {
	description = S("Lightning Door"),
	inventory_image = "m16b_lightning_door.png",
	groups = {handy = 1, axey = 1, material_wood=1, mystic_stones_secondary = 1},
	_mcl_hardness = 5,
	_mcl_blast_resistance = 5,
	tiles_bottom = {"m16b_lightning_door_lower.png^[transformFX", "m16b_lightning_door_lower.png"},
	tiles_top = {"m16b_lightning_door_upper.png^[transformFX", "m16b_lightning_door_upper.png"},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	sound_open = "doors_door_open",
	sound_close = "doors_door_close",
	sounds = mcl_sounds.node_sound_wood_defaults(),
})

minetest.register_craft({
	output = "m16b_mystic_stones:lightning_door 3",
	recipe = {
		{"m16b_mystic_stones:lightning_wood", "m16b_mystic_stones:lightning_wood"},
		{"m16b_mystic_stones:lightning_wood", "m16b_mystic_stones:lightning_wood"},
		{"m16b_mystic_stones:lightning_wood", "m16b_mystic_stones:lightning_wood"}
	}
})

-- Lightning Trapdoor
mcl_doors:register_trapdoor("m16b_mystic_stones:lightning_trapdoor", {
	description = S("Lightning Trapdoor"),
	tile_front = "m16b_lightning_trapdoor.png",
	tile_side = "m16b_lightning_trapdoor_side.png",
	wield_image = "m16b_lightning_trapdoor.png",
	groups = {handy = 1, axey = 1, material_wood=1, mystic_stones_secondary = 1},
	_mcl_hardness = 5,
	_mcl_blast_resistance = 5,
	sounds = mcl_sounds.node_sound_wood_defaults(),
	sound_open = "doors_door_open",
	sound_close = "doors_door_close",
})

minetest.register_craft({
	output = "m16b_mystic_stones:lightning_trapdoor",
	recipe = {
		{"m16b_mystic_stones:lightning_wood", "m16b_mystic_stones:lightning_wood", "m16b_mystic_stones:lightning_wood"},
		{"m16b_mystic_stones:lightning_wood", "m16b_mystic_stones:lightning_wood", "m16b_mystic_stones:lightning_wood"},
	}
})

--[[
-- Lightning Fence and Gate
mcl_fences.register_fence_and_fence_gate_def("lightning_wood", {
	tiles = { "mcl_fences_fence_red_nether_brick.png" },
	groups = { pickaxey = 1, fence_nether_brick = 1 },
	sounds = mcl_sounds.node_sound_stone_defaults(),
	_mcl_blast_resistance = core.registered_nodes["m16b_mystic_stones:lightning_wood"]._mcl_blast_resistance,
	_mcl_hardness = core.registered_nodes["m16b_mystic_stones:lightning_wood"]._mcl_hardness,
	_mcl_fences_baseitem = "m16b_mystic_stones:lightning_wood",
	_mcl_fences_stickreplacer = "m16b_mystic_stones:lightning_wood",
}, {
	description = S("Lightning Fence"),
	connects_to = { "group:fence_wood", "group:solid" },
}, {
	description = S("Lightning Gate"),
	_mcl_fences_sounds = {
		open = {
			spec = "mcl_fences_nether_brick_fence_gate_open"
		},
		close = {
			spec = "mcl_fences_nether_brick_fence_gate_close"
		}
	},
	_mcl_fences_output_amount = 2
})
]]--
