local S = minetest.get_translator(minetest.get_current_modname())

-- Strange Stone
minetest.register_craftitem("m16b_mystic_stones:stone", {
	description = S("Strange Stone"),
	_tt_help = core.colorize(mcl_colors.YELLOW, S("A strange item crafted by 6 blocks of stone.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone_base.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:stone 6",
	recipe = {
		{"mcl_core:stone", "mcl_core:stone"},
		{"mcl_core:stone", "mcl_core:stone"},
		{"mcl_core:stone", "mcl_core:stone"},

	},
})

-- Mystical Stones Tier 1 --
-- Mystic Stone Tier 1
minetest.register_craftitem("m16b_mystic_stones:mystic_stone", {
	description = S("Mystic Stone Tier 1"),
	_tt_help = core.colorize(mcl_colors.YELLOW, S("The first rune. Probably you can use it for some craftings.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:mystic_stone",
	recipe = {
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},
		{"mcl_core:diamond", "m16b_mystic_stones:stone", "mcl_core:diamond"},
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},

	},
})

-- Fire Stone
minetest.register_craftitem("m16b_mystic_stones:fire_stone", {
	description = core.colorize(mcl_colors.GOLD, S("Fire Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.GOLD, S("This isn't a normal stone. This is the first stone of fire element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_fire_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1, coal=1 },
	_mcl_burntime = 500,
})

minetest.register_craft({
	output = "m16b_mystic_stones:fire_stone",
	recipe = {
		{"mcl_fire:flint_and_steel", "mcl_mobitems:blaze_rod", "mcl_core:flint"},
		{"mcl_buckets:bucket_lava", "m16b_mystic_stones:mystic_stone", "mcl_fire:fire_charge"},
		{"mcl_core:flint", "mcl_mobitems:blaze_powder", "mcl_fire:flint_and_steel"},

	},
})

-- Water Stone
minetest.register_craftitem("m16b_mystic_stones:water_stone", {
	description = core.colorize(mcl_colors.BLUE, S("Water Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.BLUE, S("This isn't a normal stone. This is the first stone of water element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_water_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:water_stone",
	recipe = {
		{"mcl_flowers:waterlily", "mcl_potions:water", "mcl_ocean:kelp"},
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:mystic_stone", "mcl_buckets:bucket_water"},
		{"mcl_ocean:kelp", "mcl_potions:water", "mcl_flowers:waterlily"},

	},
})

-- Earth Stone
minetest.register_craftitem("m16b_mystic_stones:earth_stone", {
	description = core.colorize(mcl_colors.GREEN, S("Earth Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.GREEN, S("This isn't a normal stone. This is the first stone of earth element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_earth_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:earth_stone",
	recipe = {
		{"mcl_core:mossycobble", "mcl_core:cobble", "mcl_core:stonebrickmossy"},
		{"mcl_core:stone", "m16b_mystic_stones:mystic_stone", "mcl_core:stone"},
		{"mcl_core:stonebrickmossy", "mcl_core:cobble", "mcl_core:mossycobble"},

	},
})

-- Air Stone
minetest.register_craftitem("m16b_mystic_stones:air_stone", {
	description = core.colorize(mcl_colors.AQUA, S("Air Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.AQUA, S("This isn't a normal stone. This is the first stone of air element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_air_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:air_stone",
	recipe = {
		{"mcl_mobitems:feather", "mcl_core:glass", "mcl_mobitems:feather"},
		{"mcl_core:glass", "m16b_mystic_stones:mystic_stone", "mcl_core:glass"},
		{"mcl_mobitems:feather", "mcl_core:glass", "mcl_mobitems:feather"},

	},
})


-- Mystical Stones Tier 2 --
-- Mystic Stone Tier 2
minetest.register_craftitem("m16b_mystic_stones:mystic_stone2", {
	description = S("Mystic Stone Tier 2"),
	_tt_help = core.colorize(mcl_colors.YELLOW, S("The second tier of the rune. With this you can craft mystic stones of tier 2")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone2.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:mystic_stone2",
	recipe = {
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},
		{"mcl_core:diamond", "m16b_mystic_stones:mystic_stone", "mcl_core:diamond"},
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},

	},
})

-- Flame Stone
minetest.register_craftitem("m16b_mystic_stones:flame_stone", {
	description = core.colorize(mcl_colors.GOLD, S("Flame Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.GOLD, S("A flaming stone. This is the second stone of fire element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_flame_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1, coal=1 },
	_mcl_burntime = 1000,
})

minetest.register_craft({
	output = "m16b_mystic_stones:flame_stone",
	recipe = {
		{"mcl_mobitems:magma_cream", "m16b_mystic_stones:fire_stone", "mcl_mobitems:magma_cream"},
		{"m16b_mystic_stones:fire_stone", "m16b_mystic_stones:mystic_stone2", "m16b_mystic_stones:fire_stone"},
		{"mcl_mobitems:magma_cream", "m16b_mystic_stones:fire_stone", "mcl_mobitems:magma_cream"},

	},
})

-- River Stone
minetest.register_craftitem("m16b_mystic_stones:river_stone", {
	description = core.colorize(mcl_colors.BLUE, S("River Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.BLUE, S("A stone with river inside. This is the second stone of water element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_river_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:river_stone",
	recipe = {
		{"mcl_ocean:prismarine", "m16b_mystic_stones:water_stone", "mcl_ocean:prismarine"},
		{"m16b_mystic_stones:water_stone", "m16b_mystic_stones:mystic_stone2", "m16b_mystic_stones:water_stone"},
		{"mcl_ocean:prismarine", "m16b_mystic_stones:water_stone", "mcl_ocean:prismarine"},

	},
})

-- Cave Stone
minetest.register_craftitem("m16b_mystic_stones:cave_stone", {
	description = core.colorize(mcl_colors.GREEN, S("Cave Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.GREEN, S("A stone with a cave inside, but no minerals. This is the second stone of earth element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_cave_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:cave_stone",
	recipe = {
		{"mcl_deepslate:deepslate_cobbled", "m16b_mystic_stones:earth_stone", "mcl_deepslate:deepslate_cobbled"},
		{"m16b_mystic_stones:earth_stone", "m16b_mystic_stones:mystic_stone2", "m16b_mystic_stones:earth_stone"},
		{"mcl_deepslate:deepslate_cobbled", "m16b_mystic_stones:earth_stone", "mcl_deepslate:deepslate_cobbled"},

	},
})

-- Wind Stone
minetest.register_craftitem("m16b_mystic_stones:wind_stone", {
	description = core.colorize(mcl_colors.AQUA, S("Wind Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.AQUA, S("The stone of winds. This is the second (and final) stone of air element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_wind_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:wind_stone",
	recipe = {
		{"mcl_charges:wind_charge", "m16b_mystic_stones:air_stone", "mcl_charges:wind_charge"},
		{"m16b_mystic_stones:air_stone", "m16b_mystic_stones:mystic_stone2", "m16b_mystic_stones:air_stone"},
		{"mcl_charges:wind_charge", "m16b_mystic_stones:air_stone", "mcl_charges:wind_charge"},

	},
})

-- Wither Stone
minetest.register_craftitem("m16b_mystic_stones:wither_stone", {
	description = core.colorize(mcl_colors.DARK_GRAY, S("Wither Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.DARK_GRAY, S("A stone with a wither skull. This is the beginning of death.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_wither_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:wither_stone",
	recipe = {
		{"mcl_nether:soul_sand", "mcl_blackstone:soul_soil", "mcl_nether:soul_sand"},
		{"mcl_blackstone:soul_soil", "m16b_mystic_stones:mystic_stone2", "mcl_blackstone:soul_soil"},
		{"mcl_nether:soul_sand", "m16b_mystic_stones:earth_stone", "mcl_nether:soul_sand"},

	},
})

-- Void Stone
minetest.register_craftitem("m16b_mystic_stones:void_stone", {
	description = core.colorize(mcl_colors.DARK_PURPLE, S("Void Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.DARK_PURPLE, S("A stone with a tiny black void. This is the first stone of end element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_void_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:void_stone",
	recipe = {
		{"mcl_throwing:ender_pearl", "mcl_throwing:ender_pearl", "mcl_throwing:ender_pearl"},
		{"mcl_throwing:ender_pearl", "m16b_mystic_stones:mystic_stone2", "mcl_throwing:ender_pearl"},
		{"mcl_throwing:ender_pearl", "mcl_throwing:ender_pearl", "mcl_throwing:ender_pearl"},

	},
})

-- Mystical Stones Tier 3 --
-- Mystic Stone Tier 3
minetest.register_craftitem("m16b_mystic_stones:mystic_stone3", {
	description = S("Mystic Stone Tier 3"),
	_tt_help = core.colorize(mcl_colors.YELLOW, S("This is the rune of tier 3, it is more powerfull. With this you can craft mystic stones of tier 3.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone3.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:mystic_stone3",
	recipe = {
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},
		{"mcl_core:diamond", "m16b_mystic_stones:mystic_stone2", "mcl_core:diamond"},
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},

	},
})

-- Death Stone
minetest.register_craftitem("m16b_mystic_stones:death_stone", {
	description = core.colorize(mcl_colors.DARK_GRAY, S("Death Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.DARK_GRAY, S("The stone of the death. If you survive, is because you are very lucky.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_death_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:death_stone",
	recipe = {
		{"mcl_blackstone:soul_soil", "m16b_mystic_stones:wither_stone", "mcl_blackstone:soul_soil"},
		{"m16b_mystic_stones:wither_stone", "m16b_mystic_stones:mystic_stone3", "m16b_mystic_stones:wither_stone"},
		{"mcl_blackstone:soul_soil", "m16b_mystic_stones:wither_stone", "mcl_blackstone:soul_soil"},

	},
})

-- Infernal Stone
minetest.register_craftitem("m16b_mystic_stones:infernal_stone", {
	description = core.colorize(mcl_colors.GOLD, S("Infernal Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.GOLD, S("You feel very hot. No, you aren't in the nether.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_infernal_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1, coal=1 },
	_mcl_burntime = 1500,
})

minetest.register_craft({
	output = "m16b_mystic_stones:infernal_stone",
	recipe = {
		{"mcl_mobitems:blaze_powder", "m16b_mystic_stones:flame_stone", "mcl_mobitems:blaze_powder"},
		{"m16b_mystic_stones:flame_stone", "m16b_mystic_stones:mystic_stone3", "m16b_mystic_stones:flame_stone"},
		{"mcl_mobitems:blaze_powder", "m16b_mystic_stones:flame_stone", "mcl_mobitems:blaze_powder"},

	},
})

-- End Stone
minetest.register_craftitem("m16b_mystic_stones:end_stone", {
	description = core.colorize(mcl_colors.DARK_PURPLE, S("End Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.DARK_PURPLE, S("The tiny void becomes bigger and you see end's islands. This is the second stone of end element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_end_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:end_stone",
	recipe = {
		{"mcl_mobitems:shulker_shell", "m16b_mystic_stones:void_stone", "mcl_mobitems:shulker_shell"},
		{"m16b_mystic_stones:void_stone", "m16b_mystic_stones:mystic_stone3", "m16b_mystic_stones:void_stone"},
		{"mcl_mobitems:shulker_shell", "m16b_mystic_stones:void_stone", "mcl_mobitems:shulker_shell"},

	},
})

-- Ocean Stone
minetest.register_craftitem("m16b_mystic_stones:ocean_stone", {
	description = core.colorize(mcl_colors.BLUE, S("Ocean Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.BLUE, S("You follow the river and you see the big ocean in front of you. This is the third stone of water element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_ocean_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:ocean_stone",
	recipe = {
		{"mcl_core:ice", "m16b_mystic_stones:river_stone", "mcl_core:ice"},
		{"m16b_mystic_stones:river_stone", "m16b_mystic_stones:mystic_stone3", "m16b_mystic_stones:river_stone"},
		{"mcl_core:ice", "m16b_mystic_stones:river_stone", "mcl_core:ice"},

	},
})

-- Mineral Stone
minetest.register_craftitem("m16b_mystic_stones:mineral_stone", {
	description = core.colorize(mcl_colors.GREEN, S("Mineral Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.GREEN, S("This time the cave is full of minerals, there are diamonds, emeralds, lapis and more. This is the third (and final) stone of earth element.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mineral_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:mineral_stone",
	recipe = {
		{"mcl_core:diamond", "m16b_mystic_stones:cave_stone", "mcl_core:diamond"},
		{"m16b_mystic_stones:cave_stone", "m16b_mystic_stones:mystic_stone3", "m16b_mystic_stones:cave_stone"},
		{"mcl_core:diamond", "m16b_mystic_stones:cave_stone", "mcl_core:diamond"},

	},
})

-- Dungeon Stone
minetest.register_craftitem("m16b_mystic_stones:dungeon_stone", {
	description = core.colorize(mcl_colors.GRAY, S("Dungeon Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.GRAY, S("You look this stone and you notice that there is a chain on this. You have 2 options: continue to upgrade the rune or throw it away.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_dungeon_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:dungeon_stone",
	recipe = {
		{"mcl_core:diamond", "m16b_mystic_stones:water_stone", "mcl_core:diamond"},
		{"m16b_mystic_stones:air_stone", "m16b_mystic_stones:mystic_stone3", "m16b_mystic_stones:earth_stone"},
		{"mcl_core:diamond", "m16b_mystic_stones:fire_stone", "mcl_core:diamond"},

	},
})

-- Mystical Stones Tier 4 --
-- Mystic Stone Tier 4
minetest.register_craftitem("m16b_mystic_stones:mystic_stone4", {
	description = S("Mystic Stone Tier 4"),
	_tt_help = core.colorize(mcl_colors.YELLOW, S("You're starting to get bored with all these tiers, but then you remember why you started this journey...")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone4.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:mystic_stone4",
	recipe = {
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},
		{"mcl_core:diamond", "m16b_mystic_stones:mystic_stone3", "mcl_core:diamond"},
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},

	},
})

-- Master Stone
minetest.register_craftitem("m16b_mystic_stones:master_stone", {
	description = core.colorize(mcl_colors.GRAY, S("Master Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.GRAY, S("You look again the stone, this time the stone have 2 chains on them. You have 2 options: continue to upgrade the rune or throw it away. Choose wisely")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_master_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:master_stone",
	recipe = {
		{"mcl_core:diamond", "m16b_mystic_stones:water_stone", "mcl_core:diamond"},
		{"m16b_mystic_stones:air_stone", "m16b_mystic_stones:dungeon_stone", "m16b_mystic_stones:earth_stone"},
		{"mcl_core:diamond", "m16b_mystic_stones:fire_stone", "mcl_core:diamond"},

	},
})

-- Tsunami Stone
minetest.register_craftitem("m16b_mystic_stones:tsunami_stone", {
	description = core.colorize(mcl_colors.BLUE, S("Tsunami Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.BLUE, S("The ocean begins to move, the wind picks up, and in front of you you see a huge tsunami. This is the final stone of water element")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_tsunami_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:tsunami_stone",
	recipe = {
		{"mcl_core:diamond", "m16b_mystic_stones:ocean_stone", "mcl_core:diamond"},
		{"m16b_mystic_stones:air_stone", "m16b_mystic_stones:mystic_stone4", "m16b_mystic_stones:air_stone"},
		{"mcl_core:diamond", "m16b_mystic_stones:ocean_stone", "mcl_core:diamond"},

	},
})

-- Ender Stone
minetest.register_craftitem("m16b_mystic_stones:ender_stone", {
	description = core.colorize(mcl_colors.DARK_PURPLE, S("Ender Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.DARK_PURPLE, S("You look the stone, you look it for hours and the stone look you.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_ender_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:ender_stone",
	recipe = {
		{"mcl_end:chorus_flower", "m16b_mystic_stones:end_stone", "mcl_end:chorus_flower"},
		{"m16b_mystic_stones:end_stone", "m16b_mystic_stones:mystic_stone4", "m16b_mystic_stones:end_stone"},
		{"mcl_end:chorus_flower", "m16b_mystic_stones:end_stone", "mcl_end:chorus_flower"},

	},
})

-- Mystical Stones Tier 5 --
-- Mystic Stone Tier 5
minetest.register_craftitem("m16b_mystic_stones:mystic_stone5", {
	description = S("Mystic Stone Tier 5"),
	_tt_help = core.colorize(mcl_colors.YELLOW, S("Finally, the final rune. Now you can complete your quest.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_mystic_stone5.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:mystic_stone5",
	recipe = {
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},
		{"mcl_core:diamond", "m16b_mystic_stones:mystic_stone4", "mcl_core:diamond"},
		{"mcl_core:goldblock", "mcl_core:diamond", "mcl_core:goldblock"},

	},
})

-- Dragon Stone
minetest.register_craftitem("m16b_mystic_stones:dragon_stone", {
	description = core.colorize(mcl_colors.DARK_PURPLE, S("Dragon Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.DARK_PURPLE, S("Now you have the final boss into a stone. The power of the ender dragon is all in a simple stone. You are ready?")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_dragon_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:dragon_stone",
	recipe = {
		{"mcl_end:crystal", "m16b_mystic_stones:death_stone", "mcl_end:crystal"},
		{"m16b_mystic_stones:death_stone", "m16b_mystic_stones:ender_stone", "m16b_mystic_stones:death_stone"},
		{"mcl_end:crystal", "m16b_mystic_stones:death_stone", "mcl_end:crystal"},

	},
})

-- Forbidden Stone
minetest.register_craftitem("m16b_mystic_stones:forbidden_stone", {
	description = core.colorize(mcl_colors.GRAY, S("Forbidden Mystical Stone")),
	_tt_help = core.colorize(mcl_colors.GRAY, S("The stone now have 2 chains and a lock. You know that this stone is forbidden because it is too powerful and dangerous. Now you have one last choice: use this stone or try to burn it in the lava.")),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_forbidden_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:forbidden_stone",
	recipe = {
		{"m16b_mystic_stones:mineral_stone", "m16b_mystic_stones:infernal_stone", "m16b_mystic_stones:mystic_stone5"},
		{"m16b_mystic_stones:tsunami_stone", "mcl_potions:ominous", "m16b_mystic_stones:dragon_stone"},
		{"m16b_mystic_stones:wind_stone", "m16b_mystic_stones:death_stone", "m16b_mystic_stones:master_stone"},

	},
})




local modpath = minetest.get_modpath("m16b_mystic_stones")

dofile(modpath .. "/hud.lua")
dofile(modpath .. "/crafting/init.lua")
dofile(modpath .. "/structures/init.lua")
dofile(modpath .. "/m/init.lua")
dofile(modpath .. "/mobs/init.lua")
dofile(modpath .. "/plants/init.lua")
dofile(modpath .. "/mystic_items.lua")
dofile(modpath .. "/achievements.lua")
dofile(modpath .. "/blocks/init.lua")
dofile(modpath .. "/tools/tools.lua")
dofile(modpath .. "/enchant/enchantments.lua")
dofile(modpath .. "/armors/init.lua")
dofile(modpath .. "/armors/shields/amethyst.lua")
dofile(modpath .. "/souls_and_damnation/init.lua")
dofile(modpath .. "/guide_books/init.lua")
dofile(modpath .. "/biomes/init.lua")
