local S = core.get_translator("m16b_mystic_stones")
local mob_class = mcl_mobs.mob_class
local posing_humanoid = mcl_mobs.posing_humanoid

--###################
--################### VARKAL
--###################

local drops_common = {
    {
        name = "m16b_mystic_stones:varkal_soul",
        chance = 6.67, -- 15%
        min = 1,
        max = 1,
        looting = "common",
    },
--[[
    {
        name = "m16b_mystic_stones:varkal_letter",
        chance = 1, -- 100%
        min = 1,
        max = 1,
        looting = "common",
    },
]]--
    {
        name = "m16b_mystic_stones:damned_ingot",
        chance = 1.67, -- 60%
        min = 1,
        max = 1,
        looting = "rare",
    },
    {
        name = "m16b_mystic_stones:damnation_stone",
        chance = 1.25, -- 80%
        min = 1,
        max = 1,
        looting = "rare",
    },
    {
        name = "m16b_mystic_stones:helmet_reinforced_netherite",
        chance = 6.67, -- 15%
        min = 1,
        max = 1,
        looting = "rare",
    },
    {
        name = "m16b_mystic_stones:chestplate_reinforced_netherite",
        chance = 20, -- 5%
        min = 1,
        max = 1,
        looting = "rare",
    },
    {
        name = "m16b_mystic_stones:leggings_reinforced_netherite",
        chance = 10, -- 10%
        min = 1,
        max = 1,
        looting = "rare",
    },
    {
        name = "m16b_mystic_stones:boots_reinforced_netherite",
        chance = 20, -- 5%
        min = 1,
        max = 1,
        looting = "rare",
    },
    {
        name = "m16b_mystic_stones:wither_stone",
        chance = 10, -- 10%
        min = 1,
        max = 1,
        looting = "rare",
    },
    {
        name = "m16b_mystic_stones:void_stone",
        chance = 10, -- 50%
        min = 1,
        max = 1,
        looting = "rare",
    },
--[[
    {
        name = "m16b_mystic_stones:libro_incantato",
        chance = 2, -- 70%
        min = 1,
        max = 1,
        looting = "rare",
    },
]]--
    {
        name = "mcl_sculk:vein",
        chance = 2, -- 50%
        min = 1,
        max = 1,
        looting = "rare",
    },
}

local drops_varkal = table.copy (drops_common)
table.insert (drops_varkal, {
	name = "mcl_heads:varkal",
	chance = 6.67,
	min = 0,
	max = 0,
	mob_head = true,
})

------------------------------------------------------------------------
-- varkal.
------------------------------------------------------------------------

local varkal = table.merge (posing_humanoid, {
	description = S("Varkal, the Fallen"),
	type = "monster",
	spawn_class = "hostile",
	_spawn_category = "monster",
	hp_min = 1000,
	hp_max = 1000,
	xp_min = 30,
	xp_max = 30,
	head_swivel = "head.control",
	bone_eye_height = 6.3,
	head_eye_height = 1.74,
	curiosity = 7,
	head_pitch_multiplier=-1,
	breath_max = -1,
	wears_armor = "no_pickup",
	armor_drop_probability = {
		head = 0.085,
		torso = 0.085,
		legs = 0.085,
		feet = 0.085,
	},
	wielditem_drop_probability = 0.085,
	armor = {
		undead = 90,
		fleshy = 90,
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.95, 0.3},
	visual = "mesh",
	mesh = "mobs_mc_zombie.b3d",
	visual_size = {
		x = 1,
		y = 1.1,
	},
	textures = {
		{
			"mobs_mc_empty.png", -- armor
			"m16b_varkal.png", -- texture
		}
	},
	makes_footstep_sound = true,
	sounds = {
		random = {name="mobs_mc_varkal_growl", gain=0.5},
		war_cry = {name="mobs_mc_varkal_growl", gain=0.5},
		death = "mobs_mc_varkal_death",
		damage = "mobs_mc_varkal_hurt",
	},
	sound_params = {
		max_hear_distance = 16,
		gain = 0.5,
	},
	movement_speed = 5,
	damage = 8,
	reach = 3,
	group_attack = {
		"mobs_mc:varkal",
	},
	drops = drops_varkal,
	animation = {
		stand_start = 40, stand_end = 49, stand_speed = 2,
		walk_start = 0, walk_end = 39, speed_normal = 25,
		punch_start = 50, punch_end = 59, punch_speed = 20,
	},
	ignited_by_sunlight = false,
	floats = 0,
	attack_type = "melee",
	harmed_by_heal = false,
	is_boss = true,
	can_wield_items = "no_pickup",
	wielditem_info = {
		bone = "arm.right",
		position = {
			x = 0.7,
			y = 6.0,
			z = 0.0,
		},
		rotation = {
			x = 0,
			y = 0,
			z = 0,
		},
		toollike_position = {
			x = 0.0,
			y = 5.0,
			z = 4.0,
		},
		toollike_rotation = {
			x = 90,
			y = -45,
			z = -90,
		},
		blocklike_position = {
			x = 0,
			y = 6.0,
			z = 0,
		},
		blocklike_rotation = {
			x = 0,
			y = 180,
			z = 45,
		},
		crossbow_position = {
			x = 0,
			y = 6.0,
			z = 0,
		},
		crossbow_rotation = {
			x = 0,
			y = 180,
			z = 45,
		},
		bow_position = {
			x = 0,
			y = 6.0,
			z = 0,
		},
		bow_rotation = {
			x = 90,
			y = 130,
			z = 115,
		},
	},
	ignite_targets_while_burning = true,
	can_open_doors = false,
	_can_break_doors = false,
	tracking_distance = 35.0,
	view_range = 35.0,
	_persistent_physics_factors = {
		["mobs_mc:varkal_knockback_resistance"] = true,
		["mobs_mc:varkal_view_range_bonus"] = true,
		["mobs_mc:varkal_tracking_distance_bonus"] = true,
		["mobs_mc:varkal_spawn_reinforcements_chance"] = true,
		["mobs_mc:varkal_reinforcement_caller_attenuation"] = true,
		["mobs_mc:varkal_reinforcement_callee_attenuation"] = true,
	},
	_spawn_reinforcements_chance = 0.0,
	_varkal_punch_animation_timeout = 0,
	_humanoid_superclass = mob_class,
	_reinforcement_type = "m16b_mystic_stones:varkal",
})

------------------------------------------------------------------------
-- Varkal visuals.
------------------------------------------------------------------------

local varkal_poses = {
	default = {
		["arm.left.001"] = {
			nil,
            vector.new(0, -190, -90),
			nil,
		},
		["arm.right.001"] = {
			nil,
			vector.new (0, -160, -90),
			nil,
		},
	},
	aggressive = {
		["arm.left.001"] = {
			nil,
            vector.new(0, -190, -90),
			nil,
		},
		["arm.right.001"] = {
			nil,
			vector.new (90, -120, -89),
			nil,
		},
	},
}

mcl_mobs.define_composite_pose (varkal_poses, "jockey", {
	["leg.right"] = {
		nil,
		vector.new (-110, 35, 0),
	},
	["leg.left"] = {
		nil,
		vector.new (-110, -35, 0),
	},
})

varkal._arm_poses = varkal_poses

function varkal:select_arm_pose ()
	local basic_pose = "default"

	if self.attack
		and self._attack_delay
		and (self._attack_delay < self.melee_interval / 2) then
		basic_pose = "aggressive"
	end
	if self.jockey_vehicle then
		return "jockey_" .. basic_pose
	else
		return basic_pose
	end
end

------------------------------------------------------------------------
-- Varkal mechanics.
------------------------------------------------------------------------

function varkal:validate_attribute (field, value)
	if value == nil then
		value = 0.0
	end

	if field == "_spawn_reinforcements_chance" then
		return math.min (1, math.max (0, value))
	else
		return mob_class.validate_attribute (self, field, value)
	end
end

function varkal:varkal_post_spawn ()
	self:set_physics_factor_base ("_spawn_reinforcements_chance", math.random () * 0.1)
end

local CHICKEN_ATTACHMENT_POS = vector.new (0, 1.76, 0)

function varkal:find_chicken ()
	local self_pos = self.object:get_pos ()
	for object in core.objects_inside_radius (self_pos, 8) do
		local entity = object:get_luaentity ()
		if entity and entity.name == "mobs_mc:chicken"
			and not entity.dead
			and not entity._jockey_rider then
			return object
		end
	end
	return nil
end

function varkal:on_spawn ()
	local self_pos = self.object:get_pos ()
	local mob_factor = mcl_worlds.get_special_difficulty (self_pos)
	-- Enable picking up armor for a random subset of
	-- skeletons.
	if math.random () < 0.55 * mob_factor then
		self.wears_armor = true
		self.can_wield_items = true
	end
	self:generate_default_equipment (mob_factor, true, true)

	-- Randomize initial attributes.
	self:add_physics_factor ("knockback_resistance",
				 "mobs_mc:varkal_knockback_resistance",
				 math.random () * 0.05, "add")
	local d = mob_factor * 1.5 * math.random ()
	if d > 1.0 then
		self:add_physics_factor ("view_range", "mobs_mc:varkal_view_range_bonus",
					 d, "add_multiplied_total")
		self:add_physics_factor ("tracking_distance", "mobs_mc:varkal_tracking_distance_bonus",
					 d, "add_multiplied_total")
	end
	if math.random () < mob_factor * 0.05 then
		local chance = math.random () * 0.25 + 0.5
		self:add_physics_factor ("_spawn_reinforcements_chance",
					 "mobs_mc:varkal_spawn_reinforcements_chance",
					 chance, "add")
		-- https://bugs.mojang.com/browse/MC-219981:
		-- reinforcement-spawning varkals are supposed to
		-- receive a health bonus but it does not affect their
		-- current health.
		local health = math.random () * 3.0 + 1.0
		self._varkal_health_bonus = health
		self.object:set_properties ({
			hp_max = 20 + 20 * self._varkal_health_bonus,
		})

		-- Enable these varkals to spawn reinforcements.
		self._can_break_doors = true
	end
	if not self._no_chicken_jockeys then
		if self.child and math.random (100) <= 5 then
			local chicken = self:find_chicken ()
			if chicken then
				self:jock_to_existing (chicken, "", CHICKEN_ATTACHMENT_POS)
				local entity = chicken:get_luaentity ()
				entity._is_chicken_jockey = true
			end
		elseif self.child and math.random (100) <= 5 then
			local chicken = self:jock_to ("mobs_mc:chicken", CHICKEN_ATTACHMENT_POS)
			if chicken then
				local entity = chicken:get_luaentity ()
				entity._is_chicken_jockey = true
			end
		end
	end
	self:varkal_post_spawn ()
end

function varkal:mob_activate (staticdata, dtime)
	if not posing_humanoid.mob_activate (self, staticdata, dtime) then
		return false
	end
	self._visited_pois = {}
	if self._varkal_health_bonus then
		self.object:set_properties ({
			hp_max = 20 + 20 * self._varkal_health_bonus,
		})
	end
	if self.child then
		self:add_physics_factor ("movement_speed", "mobs_mc:baby_varkal_speed",
						0.5, "add_multiplied_base")
	end
	return true
end

function varkal:on_spawn ()
	local self_pos = self.object:get_pos ()
	local mob_factor = mcl_worlds.get_special_difficulty (self_pos)
	-- Enable picking up armor for a random subset of
	-- skeletons.
	if math.random () < 0.55 * mob_factor then
		self.wears_armor = true
		self.can_wield_items = true
	end
	self:varkal_generate_default_equipment (mob_factor)
	return true
end

function varkal:varkal_generate_default_equipment (mob_factor)
	self:generate_default_equipment (mob_factor, true, false)
	self:set_wielditem (ItemStack ("m16b_mystic_stones:sword_ancient"))
	self:enchant_default_weapon (mob_factor, pr)
end

------------------------------------------------------------------------
-- varkal AI.
------------------------------------------------------------------------

function varkal:gwp_initialize (targets, range, tolerance, penalties)
	-- Limit the pathfinding distance of varkals to 24, as greater
	-- values are not sustainable by this Lua pathfinder.
	if not range or range > 24.0 then
		range = 24.0
	end
	return mob_class.gwp_initialize (self, targets, range, tolerance, penalties)
end

function varkal:can_spawn_reinforcements (mcl_reason)
	local source = self.attack or mcl_reason.source
	local entity = source and source:get_luaentity ()
	return (source and source:is_player ()) or entity and entity.is_mob
end

local function is_dark (nodepos, x, y, z)
	local nodepos = vector.offset (nodepos, x, y, z)
	local light = core.get_node_light (nodepos)
	return light and light <= 4.0
end

local function is_clear (nodepos, x, y, z)
	local nodepos = vector.offset (nodepos, x, y, z)
	local node = core.get_node (nodepos)
	local def = core.registered_nodes[node.name]
	return def and not def.walkable and def.liquidtype == "none"
end

local function is_solid (nodepos, x, y, z)
	local nodepos = vector.offset (nodepos, x, y, z)
	local node = core.get_node (nodepos)
	local def = core.registered_nodes[node.name]
	return def and def.walkable and def.groups.solid
end

local function is_free_of_living_players (pos, radius)
	for player in mcl_util.connected_players (pos, radius) do
		if player:get_hp () > 0 then
			return false
		end
	end
	return true
end

local function is_living_entity (object)
	if not object then
		return nil
	end

	local entity = object:get_luaentity ()
	return object:is_player () or (entity and entity.is_mob)
end

function varkal:receive_damage (mcl_reason, damage)
	if not mob_class.receive_damage (self, mcl_reason, damage) then
		return false
	end

	if mcl_vars.difficulty >= 3 -- Hard
		and is_living_entity (self.attack or mcl_reason.source)
		and math.random () < self._spawn_reinforcements_chance
		and self:can_spawn_reinforcements (mcl_reason) then
		-- Perform 50 attempts to spawn reinforcements on
		-- positions between 7 to 40 blocks removed on some
		-- axes.
		local self_pos = self.object:get_pos ()
		local node_pos = mcl_util.get_nodepos (self_pos)

		for i = 1, 50 do
			local dx = math.random (7, 40) * math.random (-1, 1)
			local dy = math.random (7, 40) * math.random (-1, 1)
			local dz = math.random (7, 40) * math.random (-1, 1)
			local pos = vector.offset (node_pos, dx, dy, dz)

			if is_dark (pos, 0, 0, 0) and is_solid (pos, 0, -1, 0)
				and is_clear (pos, 0, 0, 0) and is_clear (pos, 0, 1, 0)
				and is_free_of_living_players (pos, 7.0) then
				local floor = vector.offset (pos, 0, -0.5, 0)
				local object = core.add_entity (floor, self._reinforcement_type)
				if object then
					local entity = object:get_luaentity ()
					self:add_physics_factor ("_spawn_reinforcements_chance",
								 "mobs_mc:varkal_reinforcement_caller_attenuation",
								 -0.05, "add", true)
					entity:add_physics_factor ("_spawn_reinforcements_chance",
								   "mobs_mc:varkal_reinforcement_callee_attenuation",
								   -0.05, "add", true)
					entity:do_attack (self.attack or mcl_reason.source, 15)
				end
			end
		end
	end
	return true
end

local function has_not_visited (poi, self)
	for _, visited in pairs (self._visited_pois) do
		if vector.equals (poi.min, visited) then
			return false
		end
	end
	return true
end

local function test_proximity_to_poi (a, b)
	return (a[3] or math.huge) < (b[3] or math.huge)
end

function varkal:poi_pacing_target (pos, width, height)
	local candidates = {}

	for i = 1, 10 do
		local dx = math.random (-width, width)
		local dy = math.random (-height, height)
		local dz = math.random (-width, width)
		local random_node = vector.offset (pos, dx, dy, dz)
		if mcl_villages.get_poi_heat (random_node) >= 1.0 then
			local poi, distance
				= mcl_villages.nearest_poi_in_radius (pos, 10.0,
								has_not_visited, self)
			table.insert (candidates, {
				random_node,
				poi and poi.min,
				distance,
			})
		end
	end
	table.sort (candidates, test_proximity_to_poi)
	return #candidates > 0 and candidates[1] or nil
end

local function varkal_navigate_village (self, self_pos, dtime)
	if self._navigating_village then
		local state = self:poll_navigation_state (self_pos, dtime)
		if state ~= "wait" then
			local poi = self._navigating_village
			table.insert (self._visited_pois, poi)
			self._navigating_village = nil
			return false
		end
		return true
	elseif self:check_timer ("check_navigate_village", 1.0)
		and (not mcl_util.is_daytime ()
			or mcl_worlds.pos_to_dimension (self_pos)
				~= "overworld") then
		local node_pos = mcl_util.get_nodepos (self_pos)
		local heat = mcl_villages.get_poi_heat (node_pos)

		if heat >= 3 then
			local target = self:poi_pacing_target (node_pos, 15, 7)
			if not target then
				return false
			end
			local _, poi, _ = unpack (target)
			if poi then
				self:session_navigate (poi, 1.0, 1.0, nil, nil, 1, 1)
				self._navigating_village = poi
				return "_navigating_village"
			end
		end
	end
end

function varkal:custom_attack ()
	mob_class.custom_attack (self)
	if self.child and math.random (2) == 1 then
		-- Baby varkals should potentially attempt to pace
		-- immediately after an attack.
		self._timers.seek_target = 0.5
		self._pace_asap = true
		self.attack = nil
		self:attack_end ()
	end
end

varkal.ai_functions = {
	mob_class.check_attack,
	varkal_navigate_village,
	mob_class.check_pace,
}

mcl_mobs.register_mob ("m16b_mystic_stones:varkal", varkal)

------------------------------------------------------------------------
-- varkal and variant spawning.
------------------------------------------------------------------------

mcl_mobs.spawn_setup ({
	name = "m16b_mystic_stones:varkal",
	type_of_spawning = "ground",
	dimension = "overworld",
	aoc = 9,
	biomes_except = {
		"MushroomIslandShore",
		"MushroomIsland"
	},
	chance = 1000,
})

-- Spawn eggs
mcl_mobs.register_egg ("m16b_mystic_stones:varkal", S("varkal, the Fallen"), "#00afaf", "#799c66", 0)

------------------------------------------------------------------------
-- Modern varkal & Husk spawning.
------------------------------------------------------------------------
--[[

local non_desert_biomes = {}
local desert_biomes = {}

for _, biome in pairs (mobs_mc.monster_biomes) do
	if not biome:find ("Desert") then
		table.insert (non_desert_biomes, biome)
	else
		table.insert (desert_biomes, biome)
	end
end

local varkal_spawner = table.merge (mobs_mc.monster_spawner, {
	name = "mobs_mc:varkal",
	weight = 95,
	pack_max = 4,
	pack_min = 4,
	biomes = non_desert_biomes,
})

function varkal_spawner:spawn (spawn_pos, idx, sdata, pack_size)
	if math.random () < 0.05 then
		return core.add_entity (spawn_pos, "mobs_mc:baby_varkal")
	else
		return core.add_entity (spawn_pos, "mobs_mc:varkal")
	end
end

local varkal_spawner_desert = table.merge (varkal_spawner, {
	weight = 19,
	biomes = desert_biomes,
})

local husk_spawner = table.merge (mobs_mc.monster_spawner, {
	name = "mobs_mc:husk",
	weight = 80,
	pack_max = 4,
	pack_min = 4,
	biomes = desert_biomes,
})

local monster_spawner = mobs_mc.monster_spawner

function husk_spawner:test_spawn_position (spawn_pos, node_pos, sdata, node_cache)
	return mcl_weather.is_outdoor (spawn_pos)
		and monster_spawner.test_spawn_position (self, spawn_pos,
							 node_pos, sdata,
							 node_cache)
end

function husk_spawner:spawn (spawn_pos, idx, sdata, pack_size)
	if math.random () < 0.05 then
		return core.add_entity (spawn_pos, "mobs_mc:baby_husk")
	else
		return core.add_entity (spawn_pos, "mobs_mc:husk")
	end
end

mcl_mobs.register_spawner (varkal_spawner)
mcl_mobs.register_spawner (varkal_spawner_desert)
mcl_mobs.register_spawner (husk_spawner)
]]--
