local S = minetest.get_translator(minetest.get_current_modname())

--Flint set
mcl_tools.register_set("flint", {
    craftable = true,
    material = "mcl_core:flint",
    uses = 90,
    level = 2,
    speed = 3,
    max_drop_level = 2,
    groups = { dig_speed_class = 2, enchantability = 10, mystic_stones_secondary = 1 }
}, {
    ["pick"] = {
        description = S("Flint Pickaxe"),
        inventory_image = "m16b_flint_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 3 }
        }
    },
    ["shovel"] = {
        description = S("Flint Shovel"),
        inventory_image = "m16b_flint_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 3 }
        }
    },
    ["sword"] = {
        description = S("Flint Sword"),
        inventory_image = "m16b_flint_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 5 }
        }
    },
    ["axe"] = {
        description = S("Flint Axe"),
        inventory_image = "m16b_flint_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 6 }
        }
    }
})

--Copper set
mcl_tools.register_set("copper", {
    craftable = true,
    material = "mcl_copper:copper_ingot",
    uses = 230,
    level = 3,
    speed = 4,
    max_drop_level = 2,
    groups = { dig_speed_class = 2, enchantability = 10, mystic_stones_secondary = 1 }
}, {
    ["pick"] = {
        description = S("Copper Pickaxe"),
        inventory_image = "m16b_copper_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 3 }
        }
    },
    ["shovel"] = {
        description = S("Copper Shovel"),
        inventory_image = "m16b_copper_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 3 }
        }
    },
    ["sword"] = {
        description = S("Copper Sword"),
        inventory_image = "m16b_copper_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 5 }
        }
    },
    ["axe"] = {
        description = S("Copper Axe"),
        inventory_image = "m16b_copper_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 8 }
        }
    }
})

--Exposed set
mcl_tools.register_set("exposed", {
    craftable = true,
    material = "mcl_copper:copper_ingot",
    uses = 230,
    level = 3,
    speed = 4,
    max_drop_level = 2,
    groups = { dig_speed_class = 2, enchantability = 10, mystic_stones_secondary = 1 }
}, {
    ["pick"] = {
        description = S("Exposed Pickaxe"),
        inventory_image = "m16b_exposed_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 3 }
        }
    },
    ["shovel"] = {
        description = S("Exposed Shovel"),
        inventory_image = "m16b_exposed_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 3 }
        }
    },
    ["sword"] = {
        description = S("Exposed Sword"),
        inventory_image = "m16b_exposed_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 5 }
        }
    },
    ["axe"] = {
        description = S("Exposed Axe"),
        inventory_image = "m16b_exposed_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 8 }
        }
    }
})

--Weathered set
mcl_tools.register_set("weathered", {
    craftable = true,
    material = "mcl_copper:copper_ingot",
    uses = 230,
    level = 3,
    speed = 4,
    max_drop_level = 2,
    groups = { dig_speed_class = 2, enchantability = 10, mystic_stones_secondary = 1 }
}, {
    ["pick"] = {
        description = S("Weathered Pickaxe"),
        inventory_image = "m16b_weathered_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 3 }
        }
    },
    ["shovel"] = {
        description = S("Weathered Shovel"),
        inventory_image = "m16b_weathered_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 3 }
        }
    },
    ["sword"] = {
        description = S("Weathered Sword"),
        inventory_image = "m16b_weathered_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 5 }
        }
    },
    ["axe"] = {
        description = S("Weathered Axe"),
        inventory_image = "m16b_weathered_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 8 }
        }
    }
})

--Oxidized set
mcl_tools.register_set("oxidized", {
    craftable = true,
    material = "mcl_copper:copper_ingot",
    uses = 230,
    level = 3,
    speed = 4,
    max_drop_level = 2,
    groups = { dig_speed_class = 2, enchantability = 10, mystic_stones_secondary = 1 }
}, {
    ["pick"] = {
        description = S("Oxidized Pickaxe"),
        inventory_image = "m16b_oxidized_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 3 }
        }
    },
    ["shovel"] = {
        description = S("Oxidized Shovel"),
        inventory_image = "m16b_oxidized_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 3 }
        }
    },
    ["sword"] = {
        description = S("Oxidized Sword"),
        inventory_image = "m16b_oxidized_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 5 }
        }
    },
    ["axe"] = {
        description = S("Oxidized Axe"),
        inventory_image = "m16b_oxidized_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 8 }
        }
    }
})

--Amethyst set
mcl_tools.register_set("amethyst", {
    craftable = false,
    material = "mcl_amethyst:amethyst_shard",
    uses = 240,
    level = 3,
    speed = 4,
    max_drop_level = 3,
    groups = { dig_speed_class = 2, enchantability = 18, mystic_stones_secondary = 1 }
}, {
    ["pick"] = {
        description = S("Amethyst Pickaxe"),
        inventory_image = "m16b_amethyst_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 4 }
        }
    },
    ["shovel"] = {
        description = S("Amethyst Shovel"),
        inventory_image = "m16b_amethyst_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 3 }
        }
    },
    ["sword"] = {
        description = S("Amethyst Sword"),
        inventory_image = "m16b_amethyst_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 6 }
        }
    },
    ["axe"] = {
        description = S("Amethyst Axe"),
        inventory_image = "m16b_amethyst_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 9 }
        }
    }
})

minetest.register_craft({
    output = "m16b_mystic_stones:pick_amethyst",
    recipe = {
        {"mcl_amethyst:amethyst_shard", "mcl_amethyst:amethyst_shard", "mcl_amethyst:amethyst_shard"},
        {"", "mcl_copper:copper_ingot", ""},
        {"", "mcl_copper:copper_ingot", ""},
    },
})

minetest.register_craft({
    output = "m16b_mystic_stones:shovel_amethyst",
    recipe = {
        {"mcl_amethyst:amethyst_shard"},
        {"mcl_copper:copper_ingot"},
        {"mcl_copper:copper_ingot"},
    },
})

minetest.register_craft({
    output = "m16b_mystic_stones:sword_amethyst",
    recipe = {
        {"mcl_amethyst:amethyst_shard"},
        {"mcl_amethyst:amethyst_shard"},
        {"mcl_copper:copper_ingot"},
    },
})

minetest.register_craft({
    output = "m16b_mystic_stones:axe_amethyst",
    recipe = {
        {"mcl_amethyst:amethyst_shard", "mcl_amethyst:amethyst_shard"},
        {"mcl_amethyst:amethyst_shard", "mcl_copper:copper_ingot"},
        {"", "mcl_copper:copper_ingot"},
    },
})

minetest.register_craft({
    output = "m16b_mystic_stones:axe_amethyst",
    recipe = {
        {"mcl_amethyst:amethyst_shard", "mcl_amethyst:amethyst_shard"},
        {"mcl_copper:copper_ingot", "mcl_amethyst:amethyst_shard"},
        {"mcl_copper:copper_ingot", ""},
    },
})

--Ancient set
mcl_tools.register_set("ancient", {
    craftable = true,
    material = "m16b_mystic_stones:ancient_ingot",
    uses = 2040,
    level = 6,
    speed = 10,
    max_drop_level = 4,
    groups = { dig_speed_class = 7, enchantability = 8, fire_immune = 1, mystic_stones_secondary = 1 }
}, {
    ["pick"] = {
        description = S("Ancient Pickaxe"),
        inventory_image = "m16b_ancient_pick.png",
        tool_capabilities = {
            full_punch_interval = 0.83333333,
            damage_groups = { fleshy = 5 }
        }
    },
    ["shovel"] = {
        description = S("Ancient Shovel"),
        inventory_image = "m16b_ancient_shovel.png",
        tool_capabilities = {
            full_punch_interval = 1,
            damage_groups = { fleshy = 4 }
        }
    },
    ["sword"] = {
        description = S("Ancient Sword"),
        inventory_image = "m16b_ancient_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.625,
            damage_groups = { fleshy = 10 }
        }
    },
    ["axe"] = {
        description = S("Ancient Axe"),
        inventory_image = "m16b_ancient_axe.png",
        tool_capabilities = {
            full_punch_interval = 1.25,
            damage_groups = { fleshy = 8 }
        }
    }
})
