local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)

local FIRE_SPIRIT_SPAWNER_MAX_LIGHT = 11

--[[
local function get_story_book2(cpos)
	local stack = ItemStack("mcl_books:written_book")
	local bookmeta = stack:get_meta()
	
	bookmeta:set_string("title", "Nether Camp")
	bookmeta:set_string("author", "Unknown")
	bookmeta:set_string("description", "Unknown")


-- Ancient House Story
	local pages = {
		"If you're reading this, it means I failed to defend the village.\nI was living in a peaceful and beautiful village when it happened...",
		"A stranger entered the village. We immediately welcomed him and took him around the village to see the various structures.\nFor a few months, everything seemed calm until the stranger didn't run away from the village.",
		"We didn't ask ourselves why he did it; we thought he was simply going to get supplies, but he disappeared.\nFrom the day he disappeared, the village was never the same:",
		"On the first day, pillagers attacked the village and destroyed many of the structures. On the second day, a huge storm set fire to many more, but that was only the beginning.",
		"On the third and fourth day, nothing happened, but the other villagers and I were still nervous because we didn't know when the next catastrophe might strike.",
		"On the fifth day, everything seemed calm, but he returned.\nThe stranger returned to the village, and within a day, the entire village was rebuilt.",
		"For weeks, we tried to ask him where he had gone or what he had done, but he wouldn't answer any of our questions.\nYears passed after his return, when terrible news arrived: the stranger was dead.",
		"As soon as they heard this news, the entire village began to reinforce the walls, add defenses, recruit soldiers, place lightning rods everywhere, and prepare for anything.",
		"But the one thing no one would have expected happened: one day, a miner found an underground structure with a chest.\nInside, there was a strange stone and a note.",
		"It was written in an ancient, arcane language that no one had ever seen before: it probably contained a warning about that strange stone, but we probably didn't follow it.",
		"A few days later, wizards and clerics were trying to understand the purpose of that strange stone when the houses began to sink into the ground.",
		"When it happened, I was inside my house and sank into the ground with it.\nFrom that moment on, I decided to write down what happened so that perhaps, in the future, someone would find this house and this book.",
		"In case you're reading this book, know this:\nThat stone had a strange design on it; it looked like a cave, but it also contained minerals.",
		"Anyway, I've been waiting for days for someone to find me; I'm starving and starting to run out of oxygen.\nI hope the other villagers are safe."
	}

	local fulltext = table.concat(pages, "\f")  -- "\f" is the page separator
	bookmeta:set_string("text", fulltext)

	return stack
end
]]--

-- Nether Camp

mcl_structures.register_structure("nether_camp",{
	place_on = {"mcl_nether:netherrack","mcl_crimson:crimson_nylium","mcl_crimson:warped_nylium","mcl_blackstone:soul_soil","mcl_blackstone:blackstone","mcl_nether:soul_sand"},
	flags = "all_floors",
	solid_ground = true,
	make_foundation = true,
	chunk_probability = 23,
	y_min = mcl_vars.mg_lava_nether_max - 1,
	y_max = mcl_vars.mg_nether_max - 30,
	biomes = { "Nether","SoulsandValley","WarpedForest","CrimsonForest" },
	sidelen = 16,
	filenames = {
		modpath.."/structures/schematics/m16b_nether_camp.mts",
		modpath.."/structures/schematics/m16b_nether_camp_fake.mts",
		modpath.."/structures/schematics/m16b_nether_camp_treasure.mts",
	},

after_place = function(pos)
    local p1 = vector.offset(pos, -6, 0, -6)  -- Punti di inizio (offset)
    local p2 = vector.offset(pos, 6, 5, 6)   -- Punti di fine (offset)
    local sp = core.find_nodes_in_area(p1, p2, {"mcl_mobspawners:spawner"})
        if not sp[1] then return end
    mcl_mobspawners.setup_spawner(sp[1], "m16b_mystic_stones:fire_spirit", 0, FIRE_SPIRIT_SPAWNER_MAX_LIGHT, 10, 8, 0)
end,

loot = {
  ["mcl_chests:chest_small"] = {{
    stacks_min = 6,
    stacks_max = 8,
    items = {
      -- (100%)
      { itemstring = "mcl_nether:nether_wart_item", weight = 100, amount_min = 10, amount_max = 10 },

      -- (90%)
      { itemstring = "mcl_fire:fire_charge", weight = 90, amount_min = 3, amount_max = 3 },

      -- (80%)
      { itemstring = "m16b_mystic_stones:fire_wheat_seeds", weight = 80, amount_min = 1, amount_max = 1 },
      { itemstring = "m16b_mystic_stones:fire_wheat_item", weight = 80, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_blackstone:nether_gold", weight = 80, amount_min = 10, amount_max = 10 },

      -- (60%)
      { itemstring = "mcl_nether:ancient_debris", weight = 60, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_nether:netherite_scrap", weight = 60, amount_min = 1, amount_max = 1 },

      -- (50%)
      { itemstring = "mcl_crimson:warped_fungus", weight = 50, amount_min = 4, amount_max = 4 },
      { itemstring = "mcl_crimson:crimson_fungus", weight = 50, amount_min = 4, amount_max = 4 },
      { itemstring = "mcl_nether:ancient_debris", weight = 50, amount_min = 2, amount_max = 2 },
      { itemstring = "m16b_mystic_stones:fire_flour", weight = 50, amount_min = 1, amount_max = 1 },

      -- (40%)
      { itemstring = "m16b_mystic_stones:fire_wheat_seeds", weight = 40, amount_min = 2, amount_max = 2 },
      { itemstring = "m16b_mystic_stones:fire_wheat_item", weight = 40, amount_min = 3, amount_max = 3 },
      { itemstring = "m16b_mystic_stones:fire_bread", weight = 40, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_nether:netherite_ingot", weight = 40, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_nether:ancient_debris", weight = 40, amount_min = 3, amount_max = 3 },
      { itemstring = "mcl_nether:netherite_scrap", weight = 40, amount_min = 2, amount_max = 2 },

--[[
      -- (25%)
      { itemstring = "mcl_books:written_book", weight = 25, func = function(stack, pr, pos)
          local book = get_story_book2(pos)
          return book
      end },
]]--

      -- (20%)
      { itemstring = "mcl_nether:netherite_ingot", weight = 20, amount_min = 2, amount_max = 2 },

      -- (10%)
      { itemstring = "m16b_mystic_stones:firestone_coal", weight = 10, amount_min = 1, amount_max = 1 },
      { itemstring = "m16b_mystic_stones:fire_stone", weight = 10, amount_min = 1, amount_max = 1 },

      -- (5%)
      { itemstring = "m16b_mystic_stones:flame_stone", weight = 5, amount_min = 1, amount_max = 1 },
      { itemstring = "m16b_mystic_stones:fire_rune", weight = 5, amount_min = 1, amount_max = 1 },

      -- (2%)
      { itemstring = "m16b_mystic_stones:fire_rune", weight = 2, amount_min = 2, amount_max = 2 },
      { itemstring = "mcl_mobitems:nether_star", weight = 2, amount_min = 1, amount_max = 1 },
    }
  }}
},

--[[
after_place = function(pos, rotation, pr)
	local chests = minetest.find_nodes_in_area_under_air(
		vector.offset(pos, -6, -4, -6),
		vector.offset(pos, 6, 4, 6),
		{"mcl_chests:chest_small"}
	)
	if chests and #chests > 0 then
		local chest_pos = chests[pr:next(1, #chests)]
		local inv = minetest.get_meta(chest_pos):get_inventory()
		inv:add_item("main", ItemStack("mcl_ocean:prismarine")) -- per esempio
	end
end,
]]--

})
