local S = minetest.get_translator(minetest.get_current_modname())

-- Heavy Mace
mcl_tools.register_set("mace", {
    material = "mcl_ocean:prismarine",
    craftable = false,
    uses = 500,
    level = 6,
    speed = 9.5,
    max_drop_level = 5,
    groups = { dig_speed_class = 2, fire_immune = 1, enchantability = 10, mystic_stones_secondary = 1 }
}, {
    ["heavy_mace"] = {
        description = S("Heavy Mace"),
        inventory_image = "m16b_heavy_mace.png",
        tool_capabilities = {
            full_punch_interval = 5,
            damage_groups = { fleshy = 14 }
        }
    }
})

minetest.register_craft({
	output = "m16b_mystic_stones:heavy_mace_mace",
	recipe = {
		{"", "", "mcl_lanterns:chain"},
		{"", "mcl_lanterns:chain", "m16b_mystic_stones:spiked_ball"},
		{"mcl_lanterns:chain", "", ""},

	},
})

-- Spiked Ball
minetest.register_craftitem("m16b_mystic_stones:spiked_ball", {
	description = S("Spiked Ball"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_spiked_ball.png",
	groups = { craftitem = 1, mystic_stones_secondary = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:spiked_ball",
	recipe = {
		{"mcl_core:iron_nugget", "", "mcl_core:iron_nugget"},
		{"", "mcl_core:ironblock", ""},
		{"mcl_core:iron_nugget", "", "mcl_core:iron_nugget"},

	},
})
