local S = core.get_translator(core.get_current_modname())
local F = core.formspec_escape
local C = core.colorize

local it_is_halloween = false
local date = os.date("*t")
if (
		date.month == 10 and (
			date.day == 29 or
			date.day == 30 or
			date.day == 31
		)
	) then
	it_is_halloween = true
end

local max_text_length =  12800
local max_title_length = 64

local bookshelf_inv = core.settings:get_bool("mcl_bookshelf_inventories", true)

local header = "no_prepend[]" .. mcl_vars.gui_nonbg .. mcl_vars.gui_bg_color ..
		"style_type[button;border=false;bgimg=mcl_books_button9.png;bgimg_pressed=mcl_books_button9_pressed.png;bgimg_middle=2,2]"

local function make_description(itemstack)
	local m = itemstack:get_meta()
	local title = m:get_string("title")
	local author = m:get_string("author")
	local generation = m:get_int("generation")
	if author == "" then
		return
	end

	local desc
	if generation == 0 then
		desc = S("“@1”", title)
	elseif generation == 1 then
		desc = S("Copy of “@1”", title)
	elseif generation == 2 then
		desc = S("Copy of Copy of “@1”", title)
	else
		desc = S("Tattered Book")
	end
	desc = desc .. "\n" .. C(mcl_colors.GRAY, S("by @1", author))
	m:set_string("description", desc)
end

local function cap_text_length(text, max_length)
	return string.sub(text, 1, max_length)
end

local function write(itemstack, user, pointed_thing)
	local rc = mcl_util.call_on_rightclick(itemstack, user, pointed_thing)
	if rc then return rc end

	local text = itemstack:get_meta():get_string("text")
	local formspec = "size[8,9]" ..
		header ..
		"background[-0.5,-0.5;9,10;mcl_books_book_bg.png]" ..
		"textarea[0.75,0.1;7.25,9;text;;" .. F(text) .. "]" ..
		"button[0.75,7.95;3,1;sign;" .. F(S("Sign")) .. "]" ..
		"button_exit[4.25,7.95;3,1;ok;" .. F(S("Done")) .. "]"
	core.show_formspec(user:get_player_name(), "m16b_mystic_stones:halloween_book0", formspec)
end

local function read(itemstack, user, pointed_thing)
	local rc = mcl_util.call_on_rightclick(itemstack, user, pointed_thing)
	if rc then return rc end

	local text = itemstack:get_meta():get_string("text")
	local formspec = "size[8,9]" ..
		header ..
		"background[-0.5,-0.5;9,10;mcl_books_book_bg.png]" ..
		"textarea[0.75,0.1;7.25,9;;" .. F(text) .. ";]" ..
		"button_exit[2.25,7.95;3,1;ok;" .. F(S("Done")) .. "]"
	core.show_formspec(user:get_player_name(), "m16b_mystic_stones:halloween_book", formspec)
end

-- Book Base
core.register_craftitem("m16b_mystic_stones:halloween_book0", {
	description = S("Book"),
	_tt_help = S("Write down some notes"),
	_doc_items_longdesc = S("This item can be used to write down some notes."),
	_doc_items_usagehelp = S(
			"Hold it in the hand, then rightclick to read the current notes and edit then. You can edit the text as often as you like. You can also sign the book which turns it into a written book which you can stack, but it can't be edited anymore.")
		.. "\n" ..
		S("A book can hold up to @1 characters. The title length is limited to @2 characters.", max_text_length, max_title_length),
	inventory_image = "mcl_books_book_writable.png",
	groups = { book = 1, not_in_creative_inventory = 1 },
	stack_max = 1,
	on_place = write,
	on_secondary_use = write,
})

core.register_on_player_receive_fields(function(player, formname, fields)
	if ((formname == "m16b_mystic_stones:halloween_book0") and fields and fields.text) then
		local stack = player:get_wielded_item()
		if (stack:get_name() and (stack:get_name() == "m16b_mystic_stones:halloween_book0")) then
			local meta = stack:get_meta()
			local text = cap_text_length(fields.text, max_text_length)
			if fields.ok then
				meta:set_string("text", text)
				player:set_wielded_item(stack)
			elseif fields.sign then
				local overlength = string.len(fields.text) - max_text_length
				local ov_warning = ""
				if overlength > 0 then
					ov_warning = "label[0.75, 2.5;".. F(C(mcl_colors.RED, S("Text is @1 characters too long for one book.\nIt will be capped at @2 characters.", overlength, max_text_length))).."]"
				end
				meta:set_string("text", text)
				player:set_wielded_item(stack)

				local name = player:get_player_name()
				local formspec = "size[8,9]" ..
					header ..
					"background[-0.5,-0.5;9,10;mcl_books_book_bg.png]" ..
					"field[0.75,1;7.25,1;title;" ..
					F(C("#000000", S("Enter book title:"))) .. ";]" ..
					"label[0.75,1.5;" ..
					F(C("#404040", S("by @1", name))) .. "]" ..
					ov_warning..
					"button_exit[0.75,7.95;3,1;sign;" .. F(S("Sign and Close")) .. "]" ..
					"tooltip[sign;" ..
					F(S("Note: The book will no longer be editable after signing")) .. "]" ..
					"button[4.25,7.95;3,1;cancel;" .. F(S("Cancel")) .. "]"
				core.show_formspec(player:get_player_name(), "m16b_mystic_stones:signing", formspec)
			end
		end
	elseif ((formname == "m16b_mystic_stones:signing") and fields and fields.sign and fields.title) then
		local newbook = ItemStack("m16b_mystic_stones:halloween_book")
		local book = player:get_wielded_item()
		local name = player:get_player_name()
		if book:get_name() == "m16b_mystic_stones:halloween_book0" then
			local title = fields.title
			if string.len(title) == 0 then
				title = S("Nameless Book")
			end
			title = cap_text_length(title, max_title_length)
			local meta = newbook:get_meta()
			local text = cap_text_length(book:get_meta():get_string("text"), max_text_length)
			meta:set_string("title", title)
			meta:set_string("author", name)
			meta:set_int("date", os.time())
			meta:set_string("text", text)
			-- The book copy counter. 0 = original, 1 = copy of original, 2 = copy of copy of original, …
			meta:set_int("generation", 0)

			tt.reload_itemstack_description(newbook)

			player:set_wielded_item(newbook)
		else
			core.log("error", "[mcl_books] " .. name .. " failed to sign a book!")
		end
	elseif ((formname == "m16b_mystic_stones:signing") and fields and fields.cancel) then
		local book = player:get_wielded_item()
		if book:get_name() == "m16b_mystic_stones:halloween_book0" then
			write(book, player, { type = "nothing" })
		end
	end
end)

-- Written Book
core.register_craftitem("m16b_mystic_stones:halloween_book", {
	description = S("Halloween Guide Book"),
	_doc_items_longdesc = S(
		"Written books contain some text written by someone. They can be read and copied, but not edited."
	),
	_doc_items_usagehelp = S("Hold it in your hand, then rightclick to read the book.") ..
		"\n\n" ..
		S(
			"To copy the text of the written book, place it into the crafting grid together with a book and quill (or multiple of those) and craft. The written book will not be consumed. Copies of copies can not be copied."
		),
	inventory_image = "book_halloween.png",
	groups = { not_in_creative_inventory = 1, book = 1, no_rename = 1 },
	stack_max = 16,
	on_place = read,
	on_secondary_use = read,
	_mcl_generate_description = make_description,
})

local function get_story_book(cpos)
	local stack = ItemStack("m16b_mystic_stones:halloween_book")
	local bookmeta = stack:get_meta()
	
	bookmeta:set_string("title", "Mystic Stones Guide Book For Halloween Event")
	bookmeta:set_string("author", "michi16bit")
	bookmeta:set_string("description", "The Guide Book Of Halloween Event")

	local pages = {
        "This is the Guide Book of the Halloween event!!!\nYou are ready for the event?\n",
        "The Halloween event item are three: Gravestone, Candy and the Candy Bundle.\n",
        "There are the craftings:\n\nGravestone:\n[mossy cobble stair][mossy cobble][mossy cobble stair]\n[mossy cobble][sign][mossy cobble]\n[mossy cobble][mossy cobble][mossy cobble]\n\n",
        "Candy:\n[sugar][orange dye][sugar]\n[red dye][sugar][red dye]\n[sugar][orange dye][sugar]\n\n",
        "Candy Bundle:\n[][leather][candy]\n[leather][candy][candy]\n[leather][leather][leather]\n\n",
        "There are three new stones: Graveyard, Ghost and Halloween Stone.\n",
        "There are the craftings:\n\nGraveyard Stone:\n[gravestone][gravestone][gravestone]\n[gravestone][strange stone][gravestone]\n[gravestone][gravestone][gravestone]\n\n",
        "Ghost Stone:\n[Jack o'Lantern][graveyard stone][Jack o'Lantern]\n[graveyard stone][mystic stone tier 3][graveyard stone]\n[Jack o'Lantern][graveyard stone][Jack o'Lantern]\n\n",
        "Halloween Stone\n[candy bundle][ghost stone][candy bundle]\n[ghost stone][mystic stone tier 5][ghost stone]\n[candy bundle][ghost stone][candy bundle]\n\n",
        "The events stones can give you powerfull stuff and armors in futures updates.\nHappy Halloween!!!!\n\n",
        "P.S.:All the event items are register for all the year, but are craftables only during the event."
	}

	local fulltext = table.concat(pages, "\f")  -- "\f" is the page separator
	bookmeta:set_string("text", fulltext)

	return stack
end

if it_is_halloween then

minetest.register_craft({
	output = "m16b_mystic_stones:halloween_book",
	recipe = {
		{"mcl_core:cobweb","mcl_farming:pumpkin_face_light","mcl_core:cobweb"},
		{"mcl_farming:pumpkin_face_light","mcl_books:book","mcl_farming:pumpkin_face_light"},
		{"mcl_core:cobweb","mcl_farming:pumpkin_face_light","mcl_core:cobweb"},

	},
})

end

minetest.register_on_craft(function(itemstack, player, old_craft_grid, craft_inv)
	local crafted_item = itemstack:get_name()
	if crafted_item == "m16b_mystic_stones:halloween_book" then
		-- Sostituisci l'item con il libro personalizzato
		local book = get_story_book()
		return book
	end
	return itemstack
end)
