local S = core.get_translator(core.get_current_modname())

local it_is_halloween = false
local date = os.date("*t")
if (
		date.month == 10 and (
			date.day == 29 or
			date.day == 30 or
			date.day == 31
		)
	) then
	it_is_halloween = true
end

-- Halloween Cobweb
core.register_node("m16b_mystic_stones:cobweb", {
	description = S("Halloween Cobweb"),
	drawtype = "signlike",
	tiles = {"m16b_halloween_cobweb.png"},
	inventory_image = "m16b_halloween_cobweb_item.png",
	wield_image = "m16b_halloween_cobweb_item.png",
	paramtype = "light",
	sunlight_propagates = true,
	paramtype2 = "wallmounted",
	walkable = false,
	climbable = true,
	buildable_to = true,
	selection_box = {
		type = "wallmounted",
	},
	groups = {
		handy = 1, axey = 1, shearsy = 1, swordy = 1, deco_block = 1,
		dig_by_piston = 1, destroy_by_lava_flow = 1, dig_by_water = 1,
	},
	sounds = sounds,
	node_placement_prediction = "",
	_mcl_hardness = 0.2,
	on_rotate = false,
})

-- Creeper Pumpkin Off
core.register_node("m16b_mystic_stones:halloween_pumpkin_off", {
	description = S("Creeper Jack o'Lantern"),
	_doc_items_longdesc = S("A jack o'lantern is a traditional Halloween decoration made from a pumpkin. It glows brightly."),
	is_ground_content = false,
	paramtype = "light",
	paramtype2 = "facedir",
	tiles = {"farming_pumpkin_top.png", "farming_pumpkin_top.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "m16b_halloween_pumpkin_off.png"},
	groups = {handy=1, axey=1, pumpkin=1, building_block=1, dig_by_piston=1, unsticky = 1},
	sounds = mcl_sounds.node_sound_wood_defaults(),
	on_rotate = on_rotate,
	_mcl_hardness = 1,
})

-- Creeper Pumpkin
core.register_node("m16b_mystic_stones:halloween_pumpkin", {
	description = S("Creeper Jack o'Lantern On"),
	_doc_items_longdesc = S("A jack o'lantern is a traditional Halloween decoration made from a pumpkin. It glows brightly."),
	is_ground_content = false,
	paramtype = "light",
	paramtype2 = "facedir",
	light_source = core.LIGHT_MAX,
	tiles = {"farming_pumpkin_top.png", "farming_pumpkin_top.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "m16b_halloween_pumpkin.png"},
	groups = {handy=1, axey=1, pumpkin=1, building_block=1, dig_by_piston=1, unsticky = 1},
	sounds = mcl_sounds.node_sound_wood_defaults(),
	on_rotate = on_rotate,
	_mcl_hardness = 1,
})

-- Zombie Pumpkin Off
core.register_node("m16b_mystic_stones:halloween_pumpkin_2_off", {
	description = S("Zombie Jack o'Lantern"),
	_doc_items_longdesc = S("A jack o'lantern is a traditional Halloween decoration made from a pumpkin. It glows brightly."),
	is_ground_content = false,
	paramtype = "light",
	paramtype2 = "facedir",
	tiles = {"farming_pumpkin_top.png", "farming_pumpkin_top.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "m16b_halloween_pumpkin_off2.png"},
	groups = {handy=1, axey=1, pumpkin=1, building_block=1, dig_by_piston=1, unsticky = 1},
	sounds = mcl_sounds.node_sound_wood_defaults(),
	on_rotate = on_rotate,
	_mcl_hardness = 1,
})

-- Zombie Pumpkin
core.register_node("m16b_mystic_stones:halloween_pumpkin_2", {
	description = S("Zombie Jack o'Lantern On"),
	_doc_items_longdesc = S("A jack o'lantern is a traditional Halloween decoration made from a pumpkin. It glows brightly."),
	is_ground_content = false,
	paramtype = "light",
	paramtype2 = "facedir",
	light_source = core.LIGHT_MAX,
	tiles = {"farming_pumpkin_top.png", "farming_pumpkin_top.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "m16b_halloween_pumpkin2.png"},
	groups = {handy=1, axey=1, pumpkin=1, building_block=1, dig_by_piston=1, unsticky = 1},
	sounds = mcl_sounds.node_sound_wood_defaults(),
	on_rotate = on_rotate,
	_mcl_hardness = 1,
})

-- Alien Pumpkin Off
core.register_node("m16b_mystic_stones:halloween_pumpkin_3_off", {
	description = S("Alien Jack o'Lantern"),
	_doc_items_longdesc = S("A jack o'lantern is a traditional Halloween decoration made from a pumpkin. It glows brightly."),
	is_ground_content = false,
	paramtype = "light",
	paramtype2 = "facedir",
	tiles = {"farming_pumpkin_top.png", "farming_pumpkin_top.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "m16b_halloween_pumpkin_off3.png"},
	groups = {handy=1, axey=1, pumpkin=1, building_block=1, dig_by_piston=1, unsticky = 1},
	sounds = mcl_sounds.node_sound_wood_defaults(),
	on_rotate = on_rotate,
	_mcl_hardness = 1,
})

-- Alien Pumpkin
core.register_node("m16b_mystic_stones:halloween_pumpkin_3", {
	description = S("Alien Jack o'Lantern On"),
	_doc_items_longdesc = S("A jack o'lantern is a traditional Halloween decoration made from a pumpkin. It glows brightly."),
	is_ground_content = false,
	paramtype = "light",
	paramtype2 = "facedir",
	light_source = core.LIGHT_MAX,
	tiles = {"farming_pumpkin_top.png", "farming_pumpkin_top.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "m16b_halloween_pumpkin3.png"},
	groups = {handy=1, axey=1, pumpkin=1, building_block=1, dig_by_piston=1, unsticky = 1},
	sounds = mcl_sounds.node_sound_wood_defaults(),
	on_rotate = on_rotate,
	_mcl_hardness = 1,
})

-- Halloween Pumpkin Off
core.register_node("m16b_mystic_stones:halloween_pumpkin_4_off", {
	description = S("Halloween Jack o'Lantern"),
	_doc_items_longdesc = S("A jack o'lantern is a traditional Halloween decoration made from a pumpkin. It glows brightly."),
	is_ground_content = false,
	paramtype = "light",
	paramtype2 = "facedir",
	tiles = {"farming_pumpkin_top.png", "farming_pumpkin_top.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "m16b_halloween_pumpkin_off4.png"},
	groups = {handy=1, axey=1, pumpkin=1, building_block=1, dig_by_piston=1, unsticky = 1},
	sounds = mcl_sounds.node_sound_wood_defaults(),
	on_rotate = on_rotate,
	_mcl_hardness = 1,
})

-- Halloween Pumpkin
core.register_node("m16b_mystic_stones:halloween_pumpkin_4", {
	description = S("Halloween Jack o'Lantern On"),
	_doc_items_longdesc = S("A jack o'lantern is a traditional Halloween decoration made from a pumpkin. It glows brightly."),
	is_ground_content = false,
	paramtype = "light",
	paramtype2 = "facedir",
	light_source = core.LIGHT_MAX,
	tiles = {"farming_pumpkin_top.png", "farming_pumpkin_top.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "farming_pumpkin_side.png", "m16b_halloween_pumpkin4.png"},
	groups = {handy=1, axey=1, pumpkin=1, building_block=1, dig_by_piston=1, unsticky = 1},
	sounds = mcl_sounds.node_sound_wood_defaults(),
	on_rotate = on_rotate,
	_mcl_hardness = 1,
})

if it_is_halloween then
minetest.register_craft({
	output = "m16b_mystic_stones:cobweb",
	recipe = {
		{"","","mcl_mobitems:string"},
		{"","mcl_core:stick",""},
		{"mcl_mobitems:string","",""},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:halloween_pumpkin_off",
	recipe = {
		{"mcl_tools:shears","mcl_farming:pumpkin"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:halloween_pumpkin",
	recipe = {
		{"m16b_mystic_stones:halloween_pumpkin_off"},
		{"mcl_torches:torch"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:halloween_pumpkin_2_off",
	recipe = {
		{"mcl_farming:pumpkin"},
		{"mcl_tools:shears"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:halloween_pumpkin_2",
	recipe = {
		{"m16b_mystic_stones:halloween_pumpkin_2_off"},
		{"mcl_torches:torch"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:halloween_pumpkin_3_off",
	recipe = {
		{"mcl_farming:pumpkin","mcl_tools:shears"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:halloween_pumpkin_3",
	recipe = {
		{"m16b_mystic_stones:halloween_pumpkin_3_off"},
		{"mcl_torches:torch"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:halloween_pumpkin_4_off",
	recipe = {
		{"mcl_tools:shears"},
		{"mcl_farming:pumpkin"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:halloween_pumpkin_4",
	recipe = {
		{"m16b_mystic_stones:halloween_pumpkin_4_off"},
		{"mcl_torches:torch"},

	},
})
end
