local S = minetest.get_translator(minetest.get_current_modname())

local it_is_halloween = false
local date = os.date("*t")
if (
		date.month == 10 and (
			date.day == 29 or
			date.day == 30 or
			date.day == 31
		)
	) then
	it_is_halloween = true
end

-- Villager Costume
mcl_armor.register_set({
	name = "halloween_villager",
	descriptions = {
		head = S("Halloween Villager Mask"),
		torso = S("Halloween Villager Costume"),
		legs = S("Halloween Villager Pants"),
		feet = S("Halloween Villager Boots"),
	},	durability = 50,
	points = {
		head = 0,
		torso = 0,
		legs = 0,
		feet = 0,
	},
	groups = { mystic_stones_secondary = 1 },
	toughness = 2,
	repair_material = "mcl_mobitems:leather",
	sound_equip = "mcl_armor_equip_leather",
	sound_unequip = "mcl_armor_unequip_leather",
})

-- Evoker Costume
mcl_armor.register_set({
	name = "halloween_evoker",
	descriptions = {
		head = S("Halloween Evoker Mask"),
		torso = S("Halloween Evoker Costume"),
		legs = S("Halloween Evoker Pants"),
		feet = S("Halloween Evoker Boots"),
	},	durability = 50,
	points = {
		head = 0,
		torso = 0,
		legs = 0,
		feet = 0,
	},
	groups = { mystic_stones_secondary = 1 },
	toughness = 2,
	repair_material = "mcl_mobitems:leather",
	sound_equip = "mcl_armor_equip_leather",
	sound_unequip = "mcl_armor_unequip_leather",
})

-- Masks
mcl_armor.register_set({
	name = "halloween_mask",
	descriptions = {
		head = S("Halloween Spider Mask"),
		torso = S("Halloween Enderman Mask"),
		legs = S("Halloween Piglin Brute Mask"),
		feet = S("Halloween Cow Mask"),
	},	durability = 50,
	points = {
		head = 0,
		torso = 0,
		legs = 0,
		feet = 0,
	},
	groups = { mystic_stones_secondary = 1 },
	toughness = 2,
	repair_material = "mcl_mobitems:leather",
	sound_equip = "mcl_armor_equip_leather",
	sound_unequip = "mcl_armor_unequip_leather",
})

if it_is_halloween then
-- Villager Costume
minetest.register_craft({
	output = "m16b_mystic_stones:helmet_halloween_villager",
	recipe = {
		{"mcl_dyes:green", "mcl_mobitems:leather", "mcl_dyes:green"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_halloween_villager",
	recipe = {
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"mcl_dyes:green", "mcl_mobitems:leather", "mcl_dyes:green"},
		{"mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_halloween_villager",
	recipe = {
		{"mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather"},
		{"mcl_dyes:green", "", "mcl_dyes:green"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_halloween_villager",
	recipe = {
		{"", "", ""},
		{"mcl_dyes:green", "", "mcl_dyes:green"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},

	},
})

-- Evoker Costume
minetest.register_craft({
	output = "m16b_mystic_stones:helmet_halloween_evoker",
	recipe = {
		{"mcl_dyes:grey", "mcl_mobitems:leather", "mcl_dyes:grey"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_halloween_evoker",
	recipe = {
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"mcl_dyes:grey", "mcl_mobitems:leather", "mcl_dyes:grey"},
		{"mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_halloween_evoker",
	recipe = {
		{"mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather"},
		{"mcl_dyes:grey", "", "mcl_dyes:grey"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_halloween_evoker",
	recipe = {
		{"", "", ""},
		{"mcl_dyes:grey", "", "mcl_dyes:grey"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},

	},
})

-- Masks
minetest.register_craft({
	output = "m16b_mystic_stones:helmet_halloween_mask",
	recipe = {
		{"mcl_dyes:black", "mcl_mobitems:leather", "mcl_dyes:black"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_halloween_mask",
	recipe = {
		{"mcl_dyes:purple", "mcl_mobitems:leather", "mcl_dyes:purple"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_halloween_mask",
	recipe = {
		{"mcl_dyes:red", "mcl_mobitems:leather", "mcl_dyes:red"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_halloween_mask",
	recipe = {
		{"mcl_dyes:brown", "mcl_mobitems:leather", "mcl_dyes:brown"},
		{"mcl_mobitems:leather", "", "mcl_mobitems:leather"},
		{"", "", ""},

	},
})
end
