local S = minetest.get_translator(minetest.get_current_modname())

local it_is_halloween = false
local date = os.date("*t")
if (
		date.month == 10 and (
			date.day == 29 or
			date.day == 30 or
			date.day == 31
		)
	) then
	it_is_halloween = true
end

-- Okeanos Trident
mcl_tools.register_set("okeanos", {
    material = "mcl_ocean:prismarine",
    craftable = false,
    uses = 2000,
    level = 6,
    speed = 9.5,
    max_drop_level = 5,
    groups = { dig_speed_class = 6, fire_immune = 1, enchantability = 15, mystic_stones = 1 }
}, {
    ["trident"] = {
        description = S("Okeanos Trident"),
        -- Imposta l'immagine del tridente in base ad Halloween
        inventory_image = it_is_halloween and "m16b_okeanos_trident_halloween.png" or "m16b_okeanos_trident.png",
        tool_capabilities = {
            full_punch_interval = 0.79,
            damage_groups = { fleshy = 20 }
        }
    }
})
