local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)

local GUARDIAN_SPAWNER_MAX_LIGHT = 14

local cold_oceans = {
	"RoofedForest_ocean",
	"BirchForestM_ocean",
	"BirchForest_ocean",
	"IcePlains_deep_ocean",
	"ExtremeHillsM_deep_ocean",
	"SunflowerPlains_ocean",
	"MegaSpruceTaiga_deep_ocean",
	"ExtremeHillsM_ocean",
	"SunflowerPlains_deep_ocean",
	"BirchForest_deep_ocean",
	"IcePlainsSpikes_ocean",
	"StoneBeach_ocean",
	"ColdTaiga_deep_ocean",
	"Forest_deep_ocean",
	"FlowerForest_deep_ocean",
	"MegaTaiga_ocean",
	"StoneBeach_deep_ocean",
	"IcePlainsSpikes_deep_ocean",
	"ColdTaiga_ocean",
	"ExtremeHills+_deep_ocean",
	"ExtremeHills_ocean",
	"Forest_ocean",
	"MegaTaiga_deep_ocean",
	"MegaSpruceTaiga_ocean",
	"ExtremeHills+_ocean",
	"RoofedForest_deep_ocean",
	"IcePlains_ocean",
	"FlowerForest_ocean",
	"ExtremeHills_deep_ocean",
	"Taiga_ocean",
	"BirchForestM_deep_ocean",
	"Taiga_deep_ocean",
}

--[[
local function get_story_book2(cpos)
	local stack = ItemStack("mcl_books:written_book")
	local bookmeta = stack:get_meta()
	
	bookmeta:set_string("title", "Nether Camp")
	bookmeta:set_string("author", "Unknown")
	bookmeta:set_string("description", "Unknown")


-- Ancient House Story
	local pages = {
		"If you're reading this, it means I failed to defend the village.\nI was living in a peaceful and beautiful village when it happened...",
		"A stranger entered the village. We immediately welcomed him and took him around the village to see the various structures.\nFor a few months, everything seemed calm until the stranger didn't run away from the village.",
		"We didn't ask ourselves why he did it; we thought he was simply going to get supplies, but he disappeared.\nFrom the day he disappeared, the village was never the same:",
		"On the first day, pillagers attacked the village and destroyed many of the structures. On the second day, a huge storm set fire to many more, but that was only the beginning.",
		"On the third and fourth day, nothing happened, but the other villagers and I were still nervous because we didn't know when the next catastrophe might strike.",
		"On the fifth day, everything seemed calm, but he returned.\nThe stranger returned to the village, and within a day, the entire village was rebuilt.",
		"For weeks, we tried to ask him where he had gone or what he had done, but he wouldn't answer any of our questions.\nYears passed after his return, when terrible news arrived: the stranger was dead.",
		"As soon as they heard this news, the entire village began to reinforce the walls, add defenses, recruit soldiers, place lightning rods everywhere, and prepare for anything.",
		"But the one thing no one would have expected happened: one day, a miner found an underground structure with a chest.\nInside, there was a strange stone and a note.",
		"It was written in an ancient, arcane language that no one had ever seen before: it probably contained a warning about that strange stone, but we probably didn't follow it.",
		"A few days later, wizards and clerics were trying to understand the purpose of that strange stone when the houses began to sink into the ground.",
		"When it happened, I was inside my house and sank into the ground with it.\nFrom that moment on, I decided to write down what happened so that perhaps, in the future, someone would find this house and this book.",
		"In case you're reading this book, know this:\nThat stone had a strange design on it; it looked like a cave, but it also contained minerals.",
		"Anyway, I've been waiting for days for someone to find me; I'm starving and starting to run out of oxygen.\nI hope the other villagers are safe."
	}

	local fulltext = table.concat(pages, "\f")  -- "\f" is the page separator
	bookmeta:set_string("text", fulltext)

	return stack
end
]]--

-- Guardian Camp

mcl_structures.register_structure("guardian_camp",{
	place_on = {"group:sand","mcl_core:gravel","mcl_core:dirt","mcl_core:clay","group:material_stone"},
	spawn_by = {"mcl_core:water_source"},
	flags = "all_floors",
	solid_ground = true,
	make_foundation = true,
	chunk_probability = 10,
	y_min = mcl_vars.mg_overworld_min,
	y_max = -2,
	biomes = cold_oceans,
	sidelen = 20,
	filenames = {
		modpath.."/structures/schematics/m16b_guardian_camp.mts",
	},

after_place = function(pos)
    local p1 = vector.offset(pos, -7, 0, -7)  -- Punti di inizio (offset)
    local p2 = vector.offset(pos, 7, 7, 7)   -- Punti di fine (offset)
    local sp = core.find_nodes_in_area(p1, p2, {"mcl_mobspawners:spawner"})
        if not sp[1] then return end
    mcl_mobspawners.setup_spawner(sp[1], "mobs_mc:guardian", 0, GUARDIAN_SPAWNER_MAX_LIGHT, 10, 8, 0)
end,

loot = {
["mcl_barrels:barrel_closed"] = {{
    stacks_min = 6,
    stacks_max = 8,
    items = {
      -- (100%) 
      { itemstring = "mcl_ocean:kelp", weight = 100, amount_min = 4, amount_max = 4 },
      { itemstring = "mcl_ocean:seagrass", weight = 100, amount_min = 4, amount_max = 4 },

      -- (90%)
      { itemstring = "mcl_ocean:prismarine", weight = 90, amount_min = 2, amount_max = 4 },
      { itemstring = "mcl_potions:water", weight = 90, amount_min = 1, amount_max = 1 },

      -- (80%)
      { itemstring = "mcl_ocean:prismarine_brick", weight = 80, amount_min = 2, amount_max = 4 },
      { itemstring = "mcl_ocean:prismarine_shard", weight = 80, amount_min = 2, amount_max = 4 },
      { itemstring = "mcl_ocean:sea_pickle_1_dead_brain_coral_block", weight = 80, amount_min = 2, amount_max = 4 },

      -- (70%)
      { itemstring = "mcl_potions:water_breathing", weight = 70, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_jukebox:record_chirp", weight = 70, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_mobitems:glow_ink_sac", weight = 70, amount_min = 2, amount_max = 4 },

      -- (60%)
      { itemstring = "mcl_ocean:prismarine_dark", weight = 60, amount_min = 2, amount_max = 4 },
      { itemstring = "mcl_ocean:prismarine_crystals", weight = 60, amount_min = 2, amount_max = 4 },

      -- (50%)
      { itemstring = "mcl_mobitems:nautilus_shell", weight = 50, amount_min = 2, amount_max = 3 },
      { itemstring = "mcl_sponges:sponge_wet", weight = 50, amount_min = 2, amount_max = 4 },
      { itemstring = "mcl_ocean:sea_lantern", weight = 50, amount_min = 2, amount_max = 4 },

      -- (40%)
      { itemstring = "mcl_mobitems:heart_of_the_sea", weight = 40, amount_min = 1, amount_max = 2 },

      -- (30%)
	  { itemstring = "mcl_armor:boots_leather_enchanted", weight = 30,func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end },
	  { itemstring = "mcl_armor:helmet_leather_enchanted", weight = 30,func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end },
      { itemstring = "mcl_conduits:conduit", weight = 30, amount_min = 1, amount_max = 1 },

      -- (25%)
--[[
      { itemstring = "mcl_books:written_book", weight = 25, func = function(stack, pr, pos)
          local book = get_story_book2(pos)
          return book
      end },
]]--

      -- (20%)
      { itemstring = "mcl_books:book", weight = 20, func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end }, 
	  { itemstring = "mcl_armor:leggings_leather_enchanted", weight = 20,func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end },
      { itemstring = "mcl_mobitems:leather", weight = 20, amount_min = 3, amount_max = 5 },

      -- (10%)
	  { itemstring = "mcl_armor:chestplate_leather_enchanted", weight = 10,func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end },
      { itemstring = "m16b_mystic_stones:water_stone", weight = 10, amount_min = 1, amount_max = 1 },

      -- (5%)
      { itemstring = "m16b_mystic_stones:boots_river", weight = 5, amount_min = 1, amount_max = 1 },
      { itemstring = "m16b_mystic_stones:helmet_river", weight = 5, amount_min = 1, amount_max = 1 },

      -- (3%)
      { itemstring = "m16b_mystic_stones:leggings_river", weight = 3, amount_min = 1, amount_max = 1 },
      { itemstring = "m16b_mystic_stones:river_stone", weight = 3, amount_min = 1, amount_max = 1 },

      -- (2%)
      { itemstring = "m16b_mystic_stones:chestplate_river", weight = 2, amount_min = 1, amount_max = 1 },
      { itemstring = "m16b_mystic_stones:ocean_stone", weight = 2, amount_min = 1, amount_max = 1 },

      -- (1%)
      { itemstring = "m16b_mystic_stones:tsunami_stone", weight = 1, amount_min = 1, amount_max = 1 },
    }
  }}
},

--[[
after_place = function(pos, rotation, pr)
	local chests = minetest.find_nodes_in_area_under_air(
		vector.offset(pos, -6, -4, -6),
		vector.offset(pos, 6, 4, 6),
		{"mcl_chests:chest_small"}
	)
	if chests and #chests > 0 then
		local chest_pos = chests[pr:next(1, #chests)]
		local inv = minetest.get_meta(chest_pos):get_inventory()
		inv:add_item("main", ItemStack("mcl_ocean:prismarine")) -- per esempio
	end
end,
]]--

})
