local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)

local spawnon = {"mcl_deepslate:deepslate_bricks_cracked"}

-- Varkal Castel

mcl_structures.register_structure("varkal_arena", {
    place_on = {"mcl_core:grass_block", "mcl_core:dirt_with_grass", "mcl_core:stone"},
    flags = "all_floors",
    solid_ground = true,
    make_foundation = true,
    chunk_probability = 10,
    y_max = 100,
    y_min = 5,
    biomes = { "Plains", "Forest", "SunflowerPlains" },
    sidelen = 30,
    filenames = {
        modpath.."/structures/schematics/m16b_varkal_arena.mts",
    },

     after_place = function(pos)
        -- Mob Spawners
        local p1 = vector.offset(pos, -40, -5, -40)
        local p2 = vector.offset(pos, 40, 40, 40)

        local spawners = core.find_nodes_in_area(p1, p2, {"mcl_mobspawners:spawner"})
        for _, sp in pairs(spawners) do
            mcl_mobspawners.setup_spawner(sp, "mobs_mc:skeleton", 0, 14, 10, 8, 0)
        end

        -- Varkal Spawn
        local p1 = vector.offset(pos,-9,0,-9)
        local p2 = vector.offset(pos,9,32,9)
        mcl_structures.spawn_mobs("m16b_mystic_stones:varkal", spawnon, p1, p2, pr, 5)
    end,

    loot = {
        ["mcl_chests:trapped_chest_small"] = {{
            stacks_min = 6,
            stacks_max = 10,
            items = {
                { itemstring = "m16b_mystic_stones:fake_goldblock", weight = 80, amount_min = 1, amount_max = 3 },
                { itemstring = "mcl_core:gold_nugget", weight = 80, amount_min = 1, amount_max = 3 },
                { itemstring = "mcl_core:iron_nugget", weight = 80, amount_min = 1, amount_max = 3 },
                { itemstring = "mcl_core:dirt", weight = 80, amount_min = 1, amount_max = 5 },
                { itemstring = "mcl_amethyst:amethyst_cluster", weight = 70, amount_min = 1, amount_max = 3 },
                { itemstring = "m16b_mystic_stones:axe_flint", weight = 60, amount_min = 1, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:pick_flint", weight = 60, amount_min = 1, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:shovel_flint", weight = 60, amount_min = 1, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:sword_flint", weight = 60, amount_min = 1, amount_max = 1 },
                { itemstring = "mcl_core:flint", weight = 80, amount_min = 2, amount_max = 6 },
                { itemstring = "mcl_compass:compass_recovery", weight = 40, amount_min = 1, amount_max = 1 },
                { itemstring = "mcl_mobitems:nametag", weight = 30, amount_min = 1, amount_max = 2 },
                { itemstring = "mcl_spyglass:spyglass", weight = 40, amount_min = 1, amount_max = 1 },
                { itemstring = "mcl_sus_nodes:brush", weight = 30, amount_min = 1, amount_max = 1 },
                { itemstring = "mcl_ocean:dried_kelp", weight = 50, amount_min = 1, amount_max = 7 },
                { itemstring = "mcl_sculk:vein", weight = 60, amount_min = 1, amount_max = 3     },
                { itemstring = "mcl_sculk:sculk", weight = 30, amount_min = 1, amount_max = 2 },
                { itemstring = "mcl_sculk:echo_shard", weight = 10, amount_min = 1, amount_max = 1 },
                { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 1, amount_max = 10 },
            }
        }},
        ["mcl_chests:chest_small"] = {{
            stacks_min = 6,
            stacks_max = 10,
            items = {
                { itemstring = "m16b_mystic_stones:wither_stone", weight = 1, amount_min = 0, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:void_stone", weight = 2, amount_min = 0, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:sword_death", weight = 0.5, amount_min = 0, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:ancient_ingot", weight = 2, amount_min = 1, amount_max = 2 },
                { itemstring = "m16b_mystic_stones:ancient_ingot_block", weight = 1, amount_min = 0, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:axe_ancient", weight = 1, amount_min = 1, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:pick_ancient", weight = 1, amount_min = 1, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:shovel_ancient", weight = 1, amount_min = 1, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:sword_ancient", weight = 1, amount_min = 1, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:leggings_ancient", weight = 1, amount_min = 1, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:chestplate_ancient", weight = 1, amount_min = 1, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:helmet_ancient", weight = 1, amount_min = 1, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:boots_ancient", weight = 1, amount_min = 1, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:heavy_mace_mace", weight = 20, amount_min = 0, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:spiked_ball", weight = 30, amount_min = 0, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:damned_ingot", weight = 5, amount_min = 0, amount_max = 1 },
                { itemstring = "m16b_mystic_stones:damnation_stone", weight = 10, amount_min = 0, amount_max = 1 },
                { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 1, amount_max = 10 },
                { itemstring = "mcl_books:book", weight = 40, func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end }, 
            }
        }},
        ["mcl_barrels:barrel_closed"] = {{
            stacks_min = 6,
            stacks_max = 10,
            items = {
                { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 1, amount_max = 10 },
                { itemstring = "mcl_core:apple_gold_enchanted", weight = 20, amount_min = 1, amount_max = 3 },
                { itemstring = "mcl_core:apple_gold", weight = 40, amount_min = 1, amount_max = 6 },
                { itemstring = "mcl_farming:carrot_item_gold", weight = 50, amount_min = 0, amount_max = 7 },
                { itemstring = "mcl_lush_caves:glow_berry", weight = 90, amount_min = 4, amount_max = 10 },
                { itemstring = "mcl_farming:potato_item_baked", weight = 60, amount_min = 2, amount_max = 4 },
                { itemstring = "mcl_core:apple", weight = 50, amount_min = 3, amount_max = 6 },
                { itemstring = "mcl_farming:bread", weight = 70, amount_min = 1, amount_max = 11 },
                { itemstring = "mcl_sus_stew:stew", weight = 100, amount_min = 1, amount_max = 2 },
                { itemstring = "mcl_mobitems:rotten_flesh", weight = 100, amount_min = 3, amount_max = 7 },
                { itemstring = "mcl_fishing:pufferfish_raw", weight = 70, amount_min = 1, amount_max = 2 },
                { itemstring = "mcl_farming:cookie", weight = 80, amount_min = 2, amount_max = 4 },
                { itemstring = "mcl_farming:sweet_berry", weight = 100, amount_min = 5, amount_max = 10 },
                { itemstring = "mcl_farming:beetroot_item", weight = 70, amount_min = 1, amount_max = 4 },
            }
        }}
    }
})

mcl_structures.register_structure_spawn({
    name = "m16b_mystic_stones:varkal",
    y_min = mcl_vars.mg_overworld_min,
    y_max = mcl_vars.mg_overworld_max,
    chance = 10,
    interval = 12000,
    limit = 1,
    spawnon = spawnon,
})
