local S = core.get_translator(core.get_current_modname())

-- Netherite Iron
mcl_armor.register_set({
	name = "netherite_iron",
	descriptions = {
		head = S("Netherite Iron Helmet"),
		torso = S("Netherite Iron Chestplate"),
		legs = S("Netherite Iron Leggings"),
		feet = S("Netherite Iron Boots"),
	},	durability = 570,
	enchantability = 10,
	points = {
		head = 4,
		torso = 8,
		legs = 6,
		feet = 4,
	},
	groups = { fire_immune=1, mystic_stones = 1 },
	toughness = 2,
	repair_material = "mcl_nether:netherite_ingot",
	sound_equip = "mcl_armor_equip_diamond",
	sound_unequip = "mcl_armor_unequip_diamond",
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_netherite_iron",
	recipe = {
		{"mcl_core:iron_ingot", "mcl_core:iron_ingot", "mcl_core:iron_ingot"},
		{"mcl_core:iron_ingot", "mcl_armor:helmet_netherite", "mcl_core:iron_ingot"},
		{"mcl_core:iron_ingot", "mcl_core:iron_ingot", "mcl_core:iron_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_netherite_iron",
	recipe = {
		{"mcl_core:iron_ingot", "mcl_core:iron_ingot", "mcl_core:iron_ingot"},
		{"mcl_core:iron_ingot", "mcl_armor:chestplate_netherite", "mcl_core:iron_ingot"},
		{"mcl_core:iron_ingot", "mcl_core:iron_ingot", "mcl_core:iron_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_netherite_iron",
	recipe = {
		{"mcl_core:iron_ingot", "mcl_core:iron_ingot", "mcl_core:iron_ingot"},
		{"mcl_core:iron_ingot", "mcl_armor:leggings_netherite", "mcl_core:iron_ingot"},
		{"mcl_core:iron_ingot", "mcl_core:iron_ingot", "mcl_core:iron_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_netherite_iron",
	recipe = {
		{"mcl_core:iron_ingot", "mcl_core:iron_ingot", "mcl_core:iron_ingot"},
		{"mcl_core:iron_ingot", "mcl_armor:boots_netherite", "mcl_core:iron_ingot"},
		{"mcl_core:iron_ingot", "mcl_core:iron_ingot", "mcl_core:iron_ingot"},

	},
})

-- Netherite Gold
mcl_armor.register_set({
	name = "netherite_gold",
	descriptions = {
		head = S("Netherite Gold Helmet"),
		torso = S("Netherite Gold Chestplate"),
		legs = S("Netherite Gold Leggings"),
		feet = S("Netherite Gold Boots"),
	},	durability = 590,
	enchantability = 15,
	points = {
		head = 5,
		torso = 8,
		legs = 7,
		feet = 4,
	},
	groups = { fire_immune=1, mystic_stones = 1 },
	toughness = 2,
	repair_material = "mcl_nether:netherite_ingot",
	sound_equip = "mcl_armor_equip_diamond",
	sound_unequip = "mcl_armor_unequip_diamond",
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_netherite_gold",
	recipe = {
		{"mcl_core:gold_ingot", "mcl_core:gold_ingot", "mcl_core:gold_ingot"},
		{"mcl_core:gold_ingot", "m16b_mystic_stones:helmet_netherite_iron", "mcl_core:gold_ingot"},
		{"mcl_core:gold_ingot", "mcl_core:gold_ingot", "mcl_core:gold_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_netherite_gold",
	recipe = {
		{"mcl_core:gold_ingot", "mcl_core:gold_ingot", "mcl_core:gold_ingot"},
		{"mcl_core:gold_ingot", "m16b_mystic_stones:chestplate_netherite_iron", "mcl_core:gold_ingot"},
		{"mcl_core:gold_ingot", "mcl_core:gold_ingot", "mcl_core:gold_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_netherite_gold",
	recipe = {
		{"mcl_core:gold_ingot", "mcl_core:gold_ingot", "mcl_core:gold_ingot"},
		{"mcl_core:gold_ingot", "m16b_mystic_stones:leggings_netherite_iron", "mcl_core:gold_ingot"},
		{"mcl_core:gold_ingot", "mcl_core:gold_ingot", "mcl_core:gold_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_netherite_gold",
	recipe = {
		{"mcl_core:gold_ingot", "mcl_core:gold_ingot", "mcl_core:gold_ingot"},
		{"mcl_core:gold_ingot", "m16b_mystic_stones:boots_netherite_iron", "mcl_core:gold_ingot"},
		{"mcl_core:gold_ingot", "mcl_core:gold_ingot", "mcl_core:gold_ingot"},

	},
})

-- Netherite Diamond
mcl_armor.register_set({
	name = "netherite_diamond",
	descriptions = {
		head = S("Netherite Diamond Helmet"),
		torso = S("Netherite Diamond Chestplate"),
		legs = S("Netherite Diamond Leggings"),
		feet = S("Netherite Diamond Boots"),
	},	durability = 600,
	enchantability = 12,
	points = {
		head = 5,
		torso = 8,
		legs = 7,
		feet = 5,
	},
	groups = { fire_immune=1, mystic_stones = 1 },
	toughness = 2,
	repair_material = "mcl_nether:netherite_ingot",
	sound_equip = "mcl_armor_equip_diamond",
	sound_unequip = "mcl_armor_unequip_diamond",
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_netherite_diamond",
	recipe = {
		{"mcl_core:diamond", "mcl_core:diamond", "mcl_core:diamond"},
		{"mcl_core:diamond", "m16b_mystic_stones:helmet_netherite_gold", "mcl_core:diamond"},
		{"mcl_core:diamond", "mcl_core:diamond", "mcl_core:diamond"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_netherite_diamond",
	recipe = {
		{"mcl_core:diamond", "mcl_core:diamond", "mcl_core:diamond"},
		{"mcl_core:diamond", "m16b_mystic_stones:chestplate_netherite_gold", "mcl_core:diamond"},
		{"mcl_core:diamond", "mcl_core:diamond", "mcl_core:diamond"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_netherite_diamond",
	recipe = {
		{"mcl_core:diamond", "mcl_core:diamond", "mcl_core:diamond"},
		{"mcl_core:diamond", "m16b_mystic_stones:leggings_netherite_gold", "mcl_core:diamond"},
		{"mcl_core:diamond", "mcl_core:diamond", "mcl_core:diamond"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_netherite_diamond",
	recipe = {
		{"mcl_core:diamond", "mcl_core:diamond", "mcl_core:diamond"},
		{"mcl_core:diamond", "m16b_mystic_stones:boots_netherite_gold", "mcl_core:diamond"},
		{"mcl_core:diamond", "mcl_core:diamond", "mcl_core:diamond"},

	},
})

-- Reinforced Netherite
mcl_armor.register_set({
	name = "reinforced_netherite",
	descriptions = {
		head = S("Reinforced Netherite Helmet"),
		torso = S("Reinforced Netherite Chestplate"),
		legs = S("Reinforced Netherite Leggings"),
		feet = S("Reinforced Netherite Boots"),
	},	durability = 650,
	enchantability = 10,
	points = {
		head = 7,
		torso = 9,
		legs = 8,
		feet = 6,
	},
	groups = { fire_immune=1, mystic_stones = 1 },
	toughness = 2,
	repair_material = "mcl_nether:netherite_ingot",
	sound_equip = "mcl_armor_equip_diamond",
	sound_unequip = "mcl_armor_unequip_diamond",
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_reinforced_netherite",
	recipe = {
		{"mcl_nether:netherite_scrap", "mcl_redstone_torch:redstoneblock", "mcl_nether:netherite_scrap"},
		{"mcl_nether:nether_brick", "m16b_mystic_stones:helmet_netherite_diamond", "mcl_nether:nether_brick"},
		{"mcl_nether:nether_brick", "mcl_nether:netherite_ingot", "mcl_nether:nether_brick"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_reinforced_netherite",
	recipe = {
		{"mcl_nether:netherite_scrap", "mcl_nether:netherite_scrap", "mcl_nether:netherite_scrap"},
		{"mcl_nether:nether_brick", "m16b_mystic_stones:chestplate_netherite_diamond", "mcl_nether:nether_brick"},
		{"mcl_nether:nether_brick", "mcl_nether:netherite_ingot", "mcl_nether:nether_brick"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_reinforced_netherite",
	recipe = {
		{"mcl_nether:netherite_scrap", "mcl_nether:netherite_scrap", "mcl_nether:netherite_scrap"},
		{"mcl_nether:nether_brick", "m16b_mystic_stones:leggings_netherite_diamond", "mcl_nether:nether_brick"},
		{"mcl_nether:nether_brick", "", "mcl_nether:nether_brick"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_reinforced_netherite",
	recipe = {
        {"mcl_nether:nether_brick", "m16b_mystic_stones:boots_netherite_diamond", "mcl_nether:nether_brick"},
		{"mcl_nether:netherite_ingot", "", "mcl_nether:netherite_ingot"},

	},
})



-- Copper
mcl_armor.register_set({
	name = "copper",
	descriptions = {
		head = S("Copper Helmet"),
		torso = S("Copper Chestplate"),
		legs = S("Copper Leggings"),
		feet = S("Copper Boots"),
	},	durability = 650,
	enchantability = 10,
	points = {
		head = 2,
		torso = 5,
		legs = 4,
		feet = 2,
	},
	groups = { mystic_stones = 1 },
	craft_material = "mcl_copper:copper_ingot",
	repair_material = "mcl_copper:copper_ingot",
	sound_equip = "mcl_armor_equip_iron",
	sound_unequip = "mcl_armor_unequip_iron",
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_copper",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:helmet_exposed"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_copper",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:chestplate_exposed"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_copper",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:leggings_exposed"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_copper",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:boots_exposed"},
	},
})

mcl_armor.register_set({
	name = "exposed",
	descriptions = {
		head = S("Exposed Copper Helmet"),
		torso = S("Exposed Copper Chestplate"),
		legs = S("Exposed Copper Leggings"),
		feet = S("Exposed Copper Boots"),
	},	durability = 640,
	enchantability = 12,
	points = {
		head = 3,
		torso = 5,
		legs = 4,
		feet = 2,
	},
	groups = { mystic_stones = 1 },
	repair_material = "mcl_copper:copper_ingot",
	sound_equip = "mcl_armor_equip_iron",
	sound_unequip = "mcl_armor_unequip_iron",
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_exposed",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:helmet_weathered"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_exposed",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:chestplate_weathered"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_exposed",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:leggings_weathered"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_exposed",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:boots_weathered"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_exposed",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:helmet_copper"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_exposed",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:chestplate_copper"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_exposed",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:leggings_copper"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_exposed",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:boots_copper"},
	},
})

mcl_armor.register_set({
	name = "weathered",
	descriptions = {
		head = S("Weathered Copper Helmet"),
		torso = S("Weathered Copper Chestplate"),
		legs = S("Weathered Copper Leggings"),
		feet = S("Weathered Copper Boots"),
	},	durability = 630,
	enchantability = 14,
	points = {
		head = 3,
		torso = 5,
		legs = 4,
		feet = 3,
	},
	groups = { mystic_stones = 1 },
	repair_material = "mcl_copper:copper_ingot",
	sound_equip = "mcl_armor_equip_iron",
	sound_unequip = "mcl_armor_unequip_iron",
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_weathered",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:helmet_oxidized"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_weathered",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:chestplate_oxidized"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_weathered",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:leggings_oxidized"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_weathered",
	recipe = {
		{"mcl_tools:axe_stone", "m16b_mystic_stones:boots_oxidized"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_weathered",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:helmet_exposed"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_weathered",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:chestplate_exposed"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_weathered",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:leggings_exposed"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_weathered",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:boots_exposed"},
	},
})

mcl_armor.register_set({
	name = "oxidized",
	descriptions = {
		head = S("Oxidized Copper Helmet"),
		torso = S("Oxidized Copper Chestplate"),
		legs = S("Oxidized Copper Leggings"),
		feet = S("Oxidized Copper Boots"),
	},	durability = 620,
	enchantability = 16,
	points = {
		head = 3,
		torso = 6,
		legs = 4,
		feet = 3,
	},
	groups = { mystic_stones = 1 },
	repair_material = "mcl_copper:copper_ingot",
	sound_equip = "mcl_armor_equip_iron",
	sound_unequip = "mcl_armor_unequip_iron",
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_oxidized",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:helmet_weathered"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_oxidized",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:chestplate_weathered"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_oxidized",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:leggings_weathered"},
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_oxidized",
	recipe = {
		{"mcl_buckets:bucket_water", "m16b_mystic_stones:boots_weathered"},
	},
})



-- Amethyst
mcl_armor.register_set({
	name = "amethyst",
	descriptions = {
		head = S("Amethyst Helmet"),
		torso = S("Amethyst Chestplate"),
		legs = S("Amethyst Leggings"),
		feet = S("Amethyst Boots"),
	},	durability = 660,
	enchantability = 17,
	points = {
		head = 3,
		torso = 5,
		legs = 4,
		feet = 2,
	},
	groups = { mystic_stones = 1 },
	craft_material = "mcl_amethyst:amethyst_shard",
	repair_material = "mcl_amethyst:amethyst_shard",
	sound_equip = "mcl_armor_equip_diamond",
	sound_unequip = "mcl_armor_unequip_diamond",
})

-- Ancient Armor
mcl_armor.register_set({
	name = "ancient",
	descriptions = {
		head = S("Ancient Helmet"),
		torso = S("Ancient Chestplate"),
		legs = S("Ancient Leggings"),
		feet = S("Ancient Boots"),
	},	durability = 600,
	enchantability = 18,
	points = {
		head = 4,
		torso = 9,
		legs = 6,
		feet = 4,
	},
	groups = { fire_immune=1, mystic_stones = 1 },
	toughness = 3,
	repair_material = "mcl_sculk:sculk",
	sound_equip = "mcl_armor_equip_leather",
	sound_unequip = "mcl_armor_unequip_leather",
})

minetest.register_craft({
	output = "m16b_mystic_stones:helmet_ancient",
	recipe = {
		{"mcl_sculk:catalyst", "m16b_mystic_stones:ancient_ingot", "mcl_sculk:catalyst"},
		{"m16b_mystic_stones:ancient_ingot", "", "m16b_mystic_stones:ancient_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:chestplate_ancient",
	recipe = {
		{"m16b_mystic_stones:ancient_ingot", "", "m16b_mystic_stones:ancient_ingot"},
		{"mcl_sculk:catalyst", "m16b_mystic_stones:ancient_ingot", "mcl_sculk:catalyst"},
		{"m16b_mystic_stones:ancient_ingot", "mcl_sculk:catalyst", "m16b_mystic_stones:ancient_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:leggings_ancient",
	recipe = {
		{"mcl_sculk:catalyst", "m16b_mystic_stones:ancient_ingot", "mcl_sculk:catalyst"},
		{"m16b_mystic_stones:ancient_ingot", "", "m16b_mystic_stones:ancient_ingot"},
		{"m16b_mystic_stones:ancient_ingot", "", "m16b_mystic_stones:ancient_ingot"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones:boots_ancient",
	recipe = {
		{"mcl_sculk:catalyst", "", "mcl_sculk:catalyst"},
		{"m16b_mystic_stones:ancient_ingot", "", "m16b_mystic_stones:ancient_ingot"},

	},
})

local modpath = minetest.get_modpath("m16b_mystic_stones")

dofile(modpath .. "/armors/?.lua")
