local S = core.get_translator(core.get_current_modname())
local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)

mcl_trees.register_wood("lightning",{
	readable_name = "Lightning",
	sign_color="#cee549",
	tree_schems= {
		{ file = modpath.."/biomes/schematics/m16b_lightning_tree.mts"},
		{ file = modpath.."/biomes/schematics/m16b_lightning_tree2.mts"},
		{ file = modpath.."/biomes/schematics/m16b_lightning_tree3.mts"},
		{ file = modpath.."/biomes/schematics/m16b_lightning_tree4.mts"},
	},
	tree = { tiles = {"m16b_light_tree_top.png", "m16b_light_tree_top.png","m16b_light_tree_side.png"} },
	leaves = {
		tiles = { "m16b_lightning_leaves.png" },
		color = "#eaf213",
	},
	drop_apples = true,
	wood = { tiles = {"m16b_lightning_wood.png"}},
	stripped = {
		tiles = {"mcl_stripped_lightning_log_top.png", "mcl_stripped_lightning_log_top.png","mcl_stripped_lightning_log_side.png"}
	},
	stripped_bark = {
		tiles = {"mcl_stripped_lightning_log_side.png"}
	},
	fence = {
		tiles = { "m16b_lightning_wood.png" },
	},
	fence_gate = {
		tiles = { "m16b_lightning_wood.png" },
	},
	sapling = {
		tiles = {"default_sapling.png"},
		inventory_image = "default_sapling.png",
		wield_image = "default_sapling.png",
	},
	door = {
		inventory_image = "m16b_lightning_door.png",
		tiles_bottom = {"m16b_lightning_door_lower.png", "m16b_lightning_door_lower.png"},
		tiles_top = {"m16b_lightning_door_upper.png", "m16b_lightning_door_upper.png"}
	},
	trapdoor = {
		tile_front = "m16b_lightning_trapdoor.png",
		tile_side = "m16b_lightning_trapdoor_side.png",
		wield_image = "m16b_lightning_trapdoor.png",
	},
	potted_sapling = {
		image = "default_sapling.png",
	},
})

core.register_node("m16b_mystic_stones:lightdirt", {
	description = S("Lightdirt"),
	_doc_items_longdesc = S("Lightdirt is a type of dirt found in lightning forests. Only a few plants are able to survive on it."),
	tiles = {"m16b_lightdirt_top.png", "default_dirt.png", {name="m16b_lightdirt_side.png", tileable_vertical=false}},
	groups = {handy=1, shovely=1, dirt=2, soil=1, soil_sapling=2, soil_sugarcane=1, soil_bamboo = 1, soil_fungus=1, enderman_takable=1, building_block=1, supports_mushrooms=1, converts_to_moss=1, mystic_stones=1},
	drop = "mcl_core:dirt",
	sounds = mcl_sounds.node_sound_dirt_defaults(),
	on_construct = mcl_core.on_snowable_construct,
	_on_shovel_place = mcl_core.make_dirtpath,
	_mcl_hardness = 0.5,
	_mcl_silk_touch_drop = true,
})
