local S = minetest.get_translator(minetest.get_current_modname())

-- Damnation Stone
minetest.register_craftitem("m16b_mystic_stones:damnation_stone", {
	description = S("Damnation Stone"),
	_tt_help = S("The Stone of the Damnation."),
	inventory_image = "m16b_damnation_stone.png",
	groups = { craftitem = 1, fire_immune = 1, mystic_stones = 1 },
})
minetest.register_craft({
	output = "m16b_mystic_stones:damnation_stone",
	recipe = {
		{"", "m16b_mystic_stones:stone", ""},
		{"m16b_mystic_stones:stone", "mcl_sculk:vein", "m16b_mystic_stones:stone"},
		{"", "m16b_mystic_stones:stone", ""},

	},
})

-- Damned Ingot
minetest.register_craftitem("m16b_mystic_stones:damned_ingot", {
	description = S("Damned Ingot"),
	_tt_help = S("An ancient, damned ingot."),
	inventory_image = "m16b_damned_ingot.png",
	groups = { craftitem = 1, fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones:damned_ingot",
	recipe = {
		{"", "mcl_core:iron_ingot", ""},
		{"mcl_core:iron_ingot", "m16b_mystic_stones:damnation_stone", "mcl_core:iron_ingot"},
		{"", "mcl_core:iron_ingot", ""},

	},
})

-- Varkal Sword
mcl_tools.register_set("sword", {
    material = "m16b_mystic_stones:damned_ingot",
    craftable = false,
    uses = 2000,
    level = 6,
    speed = 9.5,
    max_drop_level = 5,
    groups = { dig_speed_class = 6, fire_immune = 1, enchantability = 15, mystic_stones = 1 }
}, {
    ["varkal"] = {
        description = S("Varkal's Damned Sword"),
        inventory_image = "m16b_varkal_sword.png",
        tool_capabilities = {
            full_punch_interval = 0.79,
            damage_groups = { fleshy = 13 }
        }
    }
})

minetest.register_craft({
	output = "m16b_mystic_stones:varkal_sword",
	recipe = {
		{"", "m16b_mystic_stones:damned_ingot", ""},
		{"m16b_mystic_stones:damned_ingot", "m16b_mystic_stones:varkal_soul", "m16b_mystic_stones:damned_ingot"},
		{"", "m16b_mystic_stones:sword_ancient", ""},

	},
})
