local modname = core.get_current_modname()
local modpath = core.get_modpath(modname)

local WITCH_SPAWNER_MAX_LIGHT = 14

local function get_story_book(cpos)
	local stack = ItemStack("mcl_books:written_book")
	local bookmeta = stack:get_meta()
	
	bookmeta:set_string("title", "Witch House")
	bookmeta:set_string("author", "A Witch")
	bookmeta:set_string("description", "Unknown")


-- Witch House Story
	local pages = {
        "Finally, my sisters and I have finally discovered the secret that has always been kept from us!\n",
        "Magical runes can be made more powerful!\n",
        "For millennia, we've searched for a way to do so, and we've finally found it.\n",
        "We need four of the previous stones, some gold, and diamonds.\n",
        "From now on, the world will fear us witches!!!\n",
        "With the immense power of these new runes, we will finally be able to rule the magical kingdom.\n",
        "Now I must tell my sisters, so we can begin the journey to power.\n",
        "Years have passed since the last sentence was written, and the project is not going well. The supreme magicians discovered us and cursed our homes so we couldn't leave to gather materials.\n",
        "But I heard that a warrior managed to obtain one of those runes.\n",
        "From what I've heard, that warrior had fled his village to undertake the journey, but after obtaining the rune, he disappeared forever."
	}

	local fulltext = table.concat(pages, "\f")  -- "\f" is the page separator
	bookmeta:set_string("text", fulltext)

	return stack
end

-- Witch House

mcl_structures.register_structure("witch_house",{
	place_on = {"mcl_core:podzol"},
	flags = "all_floors",
	solid_ground = true,
	make_foundation = true,
	chunk_probability = 1,
    y_max = 60,
    y_min = 1,
	biomes = { "ColdTaiga", "MegaTaiga", "MegaSpruceTaiga", "Taiga" },
	sidelen = 20,
	filenames = {
		modpath.."/structures/schematics/m16b_witch_house.mts",
	},

    after_place = function(pos, rotation, pr)
        -- Witch Spawner
        local p1 = vector.offset(pos, -7, 0, -7)
        local p2 = vector.offset(pos, 7, 5, 7)
        local sp = core.find_nodes_in_area(p1, p2, {"mcl_mobspawners:spawner"})
        if sp[1] then
            mcl_mobspawners.setup_spawner(sp[1], "mobs_mc:witch", 0, WITCH_SPAWNER_MAX_LIGHT, 10, 8, 0)
        end

        -- Witch Book
        local chests = minetest.find_nodes_in_area_under_air(
            vector.offset(pos, -7, 0, -7),
            vector.offset(pos, 7, 7, 7),
            {"mcl_chests:chest_small"}
        )
        if chests and #chests > 0 then
            local chest_pos = chests[pr:next(1, #chests)]
            local inv = minetest.get_meta(chest_pos):get_inventory()
            inv:add_item("main", get_story_book(chest_pos))
        end
    end,

loot = {
  ["mcl_chests:chest_small"] = {{
    stacks_min = 6,
    stacks_max = 8,
    items = {
      -- (100%)
      { itemstring = "mcl_books:book", weight = 100, func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end },  
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 1, amount_max = 3 },
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 2, amount_max = 3 },
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 1, amount_max = 2 },
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 4, amount_max = 4 },

      -- (90%)
      { itemstring = "mcl_books:book", weight = 90, func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end },  
      { itemstring = "mcl_mobitems:rotten_flesh", weight = 90, amount_min = 3, amount_max = 7 },
      { itemstring = "mcl_nether:nether_wart_item", weight = 90, amount_min = 5, amount_max = 5 },

      -- (80%)
      { itemstring = "mcl_books:book", weight = 80, func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end }, 
      { itemstring = "mcl_mobitems:rotten_flesh", weight = 80, amount_min = 8, amount_max = 12 },
      { itemstring = "mcl_nether:nether_wart_item", weight = 80, amount_min = 6, amount_max = 6 },
      { itemstring = "mcl_core:apple", weight = 80, amount_min = 1, amount_max = 2 },
      { itemstring = "mcl_nether:glowstone_dust", weight = 80, amount_min = 1, amount_max = 2 },

      -- (70%)
      { itemstring = "mcl_books:book", weight = 70, func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end }, 
      { itemstring = "mcl_nether:nether_wart_item", weight = 70, amount_min = 7, amount_max = 7 },
      { itemstring = "mcl_core:apple", weight = 70, amount_min = 3, amount_max = 4 },
      { itemstring = "mcl_mobitems:spider_eye", weight = 70, amount_min = 7, amount_max = 9 },
      { itemstring = "mcl_mobitems:milk_bucket", weight = 70, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_core:apple_gold", weight = 70, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_lightning_rods:rod", weight = 70, amount_min = 1, amount_max = 1 },

      -- (60%)
      { itemstring = "mcl_nether:glowstone_dust", weight = 60, amount_min = 3, amount_max = 4 },
      { itemstring = "mcl_core:apple_gold", weight = 60, amount_min = 2, amount_max = 2 },

      -- (50%)
      { itemstring = "mcl_core:apple_gold", weight = 50, amount_min = 3, amount_max = 3 },
      { itemstring = "mcl_potions:awkward", weight = 50, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_armor:sentry", weight = 50, amount_min = 1, amount_max = 1 },

      -- (40%)
      { itemstring = "mcl_brewing:stand_000", weight = 40, amount_min = 1, amount_max = 1 },
      { itemstring = "m16b_mystic_stones:stone", weight = 40, amount_min = 1, amount_max = 1 },

      -- (30%)
      { itemstring = "mcl_armor:sentry", weight = 30, amount_min = 3, amount_max = 3 },
      { itemstring = "mcl_experience:bottle", weight = 30, amount_min = 1, amount_max = 2 },
	  { itemstring = "mcl_armor:boots_chain_enchanted", weight = 30,func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end },

      -- (25%)
      { itemstring = "mcl_books:written_book", weight = 25, func = function(stack, pr, pos)
          local book = get_story_book(pos)
          return book
      end },

	  { itemstring = "mcl_armor:helmet_chain_enchanted", weight = 25,func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end },
      { itemstring = "m16b_mystic_stones:stone", weight = 25, amount_min = 2, amount_max = 2 },

      -- (20%)
	  { itemstring = "mcl_armor:chestplate_chain_enchanted", weight = 20,func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end },
	  { itemstring = "mcl_armor:leggings_chain_enchanted", weight = 20,func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end },
      { itemstring = "mcl_experience:bottle", weight = 20, amount_min = 3, amount_max = 4 },
      { itemstring = "mcl_totems:totem", weight = 20, amount_min = 1, amount_max = 1 },

      -- (10%)
      { itemstring = "m16b_mystic_stones:stone", weight = 10, amount_min = 3, amount_max = 3 },
      { itemstring = "mcl_armor:sentry", weight = 10, amount_min = 5, amount_max = 5 },

      -- (5%)
      { itemstring = "mcl_totems:totem", weight = 5, amount_min = 1, amount_max = 1 },
      { itemstring = "mcl_compass:compass_recovery", weight = 5, amount_min = 1, amount_max = 1 },

      -- (3 %)
      { itemstring = "m16b_mystic_stones:mystic_stone", weight = 3, amount_min = 1, amount_max = 2 },
      { itemstring = "mcl_vaults:trail_key", weight = 3, amount_min = 1, amount_max = 1 },

      -- (2 %)
      { itemstring = "m16b_mystic_stones:mystic_stone2", weight = 2, amount_min = 1, amount_max = 2 },
      { itemstring = "mcl_vaults:ominous_trail_key", weight = 2, amount_min = 1, amount_max = 1 },

      -- (1 %)
      { itemstring = "m16b_mystic_stones:mystic_stone3", weight = 1, amount_min = 1, amount_max = 2 },
    }
  }},

["mcl_barrels:barrel_closed"] = {{
    stacks_min = 6,
    stacks_max = 8,
    items = {
      -- (100%) 
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 1, amount_max = 3 },
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 2, amount_max = 3 },
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 1, amount_max = 2 },
      { itemstring = "mcl_core:cobweb", weight = 100, amount_min = 4, amount_max = 4 },
      { itemstring = "mcl_mobitems:rotten_flesh", weight = 100, amount_min = 3, amount_max = 4 },
      { itemstring = "mcl_farming:potato_item_poison", weight = 100, amount_min = 3, amount_max = 4 },

      -- (90%)
      { itemstring = "mcl_mobitems:rotten_flesh", weight = 90, amount_min = 5, amount_max = 5 },
      { itemstring = "mcl_farming:cookie", weight = 90, amount_min = 1, amount_max = 2 },
      { itemstring = "mcl_core:sugar", weight = 90, amount_min = 1, amount_max = 2 },

      -- (80%)
      { itemstring = "mcl_farming:cookie", weight = 80, amount_min = 3, amount_max = 3 },
      { itemstring = "mcl_core:sugar", weight = 80, amount_min = 3, amount_max = 5 },
      { itemstring = "mcl_nether:nether_wart_item", weight = 80, amount_min = 1, amount_max = 3 },
      { itemstring = "mcl_mobitems:milk_bucket", weight = 80, amount_min = 1, amount_max = 1 },

      -- (70%)
      { itemstring = "mcl_farming:cookie", weight = 70, amount_min = 4, amount_max = 4 },
      { itemstring = "mcl_farming:potato_item_poison    ", weight = 70, amount_min = 5, amount_max = 5 },
      { itemstring = "mcl_mobitems:spider_eye", weight = 70, amount_min = 5, amount_max = 5 },
      { itemstring = "mcl_lush_caves:glow_berry", weight = 70, amount_min = 1, amount_max = 2 },
      { itemstring = "mcl_farming:carrot_item_gold", weight = 70, amount_min = 1, amount_max = 1 },

      -- (60%)
      { itemstring = "mcl_farming:carrot_item_gold", weight = 60, amount_min = 2, amount_max = 3 },
      { itemstring = "mcl_mobitems:spider_eye", weight = 60, amount_min = 6, amount_max = 6 },
      { itemstring = "mcl_lush_caves:glow_berry", weight = 60, amount_min = 3, amount_max = 3 },
      { itemstring = "mcl_nether:nether_wart_item", weight = 60, amount_min = 4, amount_max = 6 },
      { itemstring = "mcl_fishing:pufferfish_raw", weight = 60, amount_min = 1, amount_max = 2 },

      -- (50%)
      { itemstring = "mcl_farming:carrot_item_gold", weight = 50, amount_min = 4, amount_max = 4 },
      { itemstring = "mcl_farming:potato_item_poison", weight = 50, amount_min = 6, amount_max = 7 },
      { itemstring = "mcl_fishing:pufferfish_raw", weight = 50, amount_min = 3, amount_max = 3 },
      { itemstring = "mcl_fishing:salmon_raw", weight = 50, amount_min = 3, amount_max = 5 },

      -- (40%)
      { itemstring = "mcl_fishing:pufferfish_raw", weight = 40, amount_min = 4, amount_max = 4 },
      { itemstring = "mcl_fishing:salmon_raw", weight = 40, amount_min = 6, amount_max = 6 },

      -- (30%)
      { itemstring = "mcl_core:apple_gold", weight = 30, amount_min = 1, amount_max = 2 },

      -- (20%)
      { itemstring = "mcl_core:apple_gold", weight = 20, amount_min = 3, amount_max = 4 },
      { itemstring = "mcl_potions:fermented_spider_eye", weight = 20, amount_min = 2, amount_max = 4 },
      { itemstring = "mcl_lush_caves:glow_berry", weight = 20, amount_min = 4, amount_max = 6 },

      -- (10%)
      { itemstring = "mcl_core:apple_gold", weight = 10, amount_min = 5, amount_max = 6 },
      { itemstring = "mcl_potions:fermented_spider_eye", weight = 10, amount_min = 5, amount_max = 6 },
      { itemstring = "mcl_potions:speckled_melon", weight = 10, amount_min = 2, amount_max = 3 },
      { itemstring = "mcl_mobitems:rabbit_foot", weight = 10, amount_min = 4, amount_max = 6 },

      -- (5%)
      { itemstring = "mcl_mobitems:rabbit_foot", weight = 5, amount_min = 7, amount_max = 7 },

      -- (3%)
      { itemstring = "mcl_potions:speckled_melon", weight = 3, amount_min = 4, amount_max = 5 },

      -- (2%)
      { itemstring = "mcl_books:book", weight = 2, func = function(stack, pr) mcl_enchanting.enchant_uniform_randomly(stack, {"soul_speed"}, pr) end }, 
    }
  }}
}

})
