local S = minetest.get_translator(minetest.get_current_modname())

-- Ancient Ingot
core.register_craftitem("m16b_mystic_stones_vl:ancient_ingot", {
	description = S("Ancient Ingot"),
	_doc_items_longdesc = S("Ancient Ingot. It is used to craft armor and tools."),
	inventory_image = "m16b_ancient_ingot.png",
	groups = { craftitem=1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:ancient_ingot",
	recipe = {
		{"mcl_sculk:sculk", "mcl_core:gold_ingot"},
		{"mcl_core:gold_ingot", "mcl_sculk:sculk"},

	},
})

-- Ancient Ingot Block
core.register_node("m16b_mystic_stones_vl:ancient_ingot_block", {
	description = S("Ancient Ingot Block"),
	_doc_items_longdesc = S("A block of ancient ingots is mostly a decorative block but also useful as a compact storage of ancient ingots."),
	tiles = {"m16b_ancient_ingot_block.png"},
	is_ground_content = false,
	groups = {pickaxey = 3, building_block = 1, mystic_stones = 1},
	sounds = mcl_sounds.node_sound_metal_defaults(),
	_mcl_blast_resistance = 6,
	_mcl_hardness = 5,
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:ancient_ingot_block",
	recipe = {
		{"m16b_mystic_stones_vl:ancient_ingot", "m16b_mystic_stones_vl:ancient_ingot", "m16b_mystic_stones_vl:ancient_ingot"},
		{"m16b_mystic_stones_vl:ancient_ingot", "m16b_mystic_stones_vl:ancient_ingot", "m16b_mystic_stones_vl:ancient_ingot"},
		{"m16b_mystic_stones_vl:ancient_ingot", "m16b_mystic_stones_vl:ancient_ingot", "m16b_mystic_stones_vl:ancient_ingot"},
	},
})
