local S = minetest.get_translator(minetest.get_current_modname())
local modpath = minetest.get_modpath("m16b_mystic_stones_vl")

local it_is_halloween = false
local date = os.date("*t")
if (
		date.month == 10 and (
			date.day == 29 or
			date.day == 30 or
			date.day == 31
		)
	) then
	it_is_halloween = true
end

-- Halloween Stone
minetest.register_craftitem("m16b_mystic_stones_vl:halloween_stone", {
	description = S("Halloween Stone"),
	_tt_help = core.colorize(mcl_colors.GOLD, S("The Halloween Stone.")),
	inventory_image = "m16b_halloween_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

-- Ghost Stone
minetest.register_craftitem("m16b_mystic_stones_vl:ghost_stone", {
	description = S("Ghost Stone"),
	_tt_help = core.colorize(mcl_colors.GOLD, S("The Ghost Stone of.")),
	inventory_image = "m16b_ghost_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

-- Graveyard Stone
minetest.register_craftitem("m16b_mystic_stones_vl:graveyard_stone", {
	description = S("Graveyard Stone"),
	_tt_help = core.colorize(mcl_colors.GOLD, S("The Graveyard Stone of.")),
	inventory_image = "m16b_graveyard_stone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

-- Items
-- Gravestone
minetest.register_craftitem("m16b_mystic_stones_vl:gravestone", {
	description = S("Gravestone"),
	_tt_help = core.colorize(mcl_colors.GOLD, S("A Gravestone.")),
	inventory_image = "m16b_gravestone.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

-- Candy
minetest.register_craftitem("m16b_mystic_stones_vl:candy", {
	description = S("Halloween Candy"),
	_tt_help = core.colorize(mcl_colors.GOLD, S("A Candy")),
	inventory_image = "m16b_candy.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

-- Candy Bundle
minetest.register_craftitem("m16b_mystic_stones_vl:candy_bundle", {
	description = S("Halloween Candy Bundle"),
	_tt_help = core.colorize(mcl_colors.GOLD, S("An Halloween Candy Bundle.")),
	inventory_image = "m16b_candy_bundle.png",
	groups = { fire_immune = 1, mystic_stones = 1 },
})

if it_is_halloween then

minetest.register_craft({
	output = "m16b_mystic_stones_vl:halloween_stone",
	recipe = {
		{"m16b_mystic_stones_vl:candy_bundle", "m16b_mystic_stones_vl:ghost_stone", "m16b_mystic_stones_vl:candy_bundle"},
		{"m16b_mystic_stones_vl:ghost_stone", "m16b_mystic_stones_vl:mystic_stone5", "m16b_mystic_stones_vl:ghost_stone"},
		{"m16b_mystic_stones_vl:candy_bundle", "m16b_mystic_stones_vl:ghost_stone", "m16b_mystic_stones_vl:candy_bundle"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:ghost_stone",
	recipe = {
		{"mcl_farming:pumpkin_face_light", "m16b_mystic_stones_vl:graveyard_stone", "mcl_farming:pumpkin_face_light"},
		{"m16b_mystic_stones_vl:graveyard_stone", "m16b_mystic_stones_vl:mystic_stone3", "m16b_mystic_stones_vl:graveyard_stone"},
		{"mcl_farming:pumpkin_face_light", "m16b_mystic_stones_vl:graveyard_stone", "mcl_farming:pumpkin_face_light"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:graveyard_stone",
	recipe = {
		{"m16b_mystic_stones_vl:gravestone", "m16b_mystic_stones_vl:gravestone", "m16b_mystic_stones_vl:gravestone"},
		{"m16b_mystic_stones_vl:gravestone", "m16b_mystic_stones_vl:stone", "m16b_mystic_stones_vl:gravestone"},
		{"m16b_mystic_stones_vl:gravestone", "m16b_mystic_stones_vl:gravestone", "m16b_mystic_stones_vl:gravestone"},

	},
})

-- Items
minetest.register_craft({
	output = "m16b_mystic_stones_vl:gravestone",
	recipe = {
		{"mcl_stairs:stair_mossycobble", "mcl_core:mossycobble", "mcl_stairs:stair_mossycobble"},
		{"mcl_core:mossycobble", "group:sign", "mcl_core:mossycobble"},
		{"mcl_core:mossycobble", "mcl_core:mossycobble", "mcl_core:mossycobble"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:candy",
	recipe = {
		{"mcl_core:sugar", "mcl_dyes:orange", "mcl_core:sugar"},
		{"mcl_dyes:red", "mcl_core:sugar", "mcl_dyes:red"},
		{"mcl_core:sugar", "mcl_dyes:orange", "mcl_core:sugar"},

	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:candy_bundle",
	recipe = {
		{"", "mcl_mobitems:leather", "m16b_mystic_stones_vl:candy"},
		{"mcl_mobitems:leather", "m16b_mystic_stones_vl:candy", "m16b_mystic_stones_vl:candy"},
		{"mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather"},

	},
})
end

dofile(modpath .. "/events/halloween_costumes.lua")
dofile(modpath .. "/events/halloween_blocks.lua")
