local S = minetest.get_translator(minetest.get_current_modname())
local wield_scale = mcl_vars.tool_wield_scale

-- Damnation Stone
minetest.register_craftitem("m16b_mystic_stones_vl:damnation_stone", {
	description = S("Damnation Stone"),
	_tt_help = S("The Stone of the Damnation."),
	inventory_image = "m16b_damnation_stone.png",
	groups = { craftitem = 1, fire_immune = 1, mystic_stones = 1 },
})
minetest.register_craft({
	output = "m16b_mystic_stones_vl:damnation_stone",
	recipe = {
		{"", "m16b_mystic_stones_vl:stone", ""},
		{"m16b_mystic_stones_vl:stone", "mcl_sculk:vein", "m16b_mystic_stones_vl:stone"},
		{"", "m16b_mystic_stones_vl:stone", ""},

	},
})

-- Damned Ingot
minetest.register_craftitem("m16b_mystic_stones_vl:damned_ingot", {
	description = S("Damned Ingot"),
	_tt_help = S("An ancient, damned ingot."),
	inventory_image = "m16b_damned_ingot.png",
	groups = { craftitem = 1, fire_immune = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:damned_ingot",
	recipe = {
		{"", "mcl_core:iron_ingot", ""},
		{"mcl_core:iron_ingot", "m16b_mystic_stones_vl:damnation_stone", "mcl_core:iron_ingot"},
		{"", "mcl_core:iron_ingot", ""},

	},
})

-- Varkal Sword
minetest.register_tool("m16b_mystic_stones_vl:varkal_sword", {
	description = S("Varkal Sword"),
	inventory_image = "m16b_varkal_sword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, varkal_sword=1, dig_speed_class=6, enchantability=15, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 0.79,
		max_drop_level=5,
		damage_groups = {fleshy=13},
		punch_attack_uses = 2000,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "m16b_mystic_stones_vl:damned_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 3, level = 2, uses = 90 },
		swordy_cobweb = { speed = 3, level = 2, uses = 90 }
	},
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:varkal_sword",
	recipe = {
		{"", "m16b_mystic_stones_vl:damned_ingot", ""},
		{"m16b_mystic_stones_vl:damned_ingot", "m16b_mystic_stones_vl:varkal_soul", "m16b_mystic_stones_vl:damned_ingot"},
		{"", "m16b_mystic_stones_vl:sword_ancient", ""},

	},
})
