local S = minetest.get_translator(minetest.get_current_modname())
local wield_scale = mcl_vars.tool_wield_scale

local it_is_halloween = false
local date = os.date("*t")
if (
		date.month == 10 and (
			date.day == 29 or
			date.day == 30 or
			date.day == 31
		)
	) then
	it_is_halloween = true
end

-- Copper
minetest.register_tool("m16b_mystic_stones_vl:sword_copper", {
	description = S("Copper Sword"),
	_doc_items_longdesc = sword_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_copper_sword_halloween.png" or "m16b_copper_sword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, sword=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=2,
		damage_groups = {fleshy=5},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 4, level = 3, uses = 230 },
		swordy_cobweb = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:pick_copper", {
	description = S("Copper Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_copper_pick_halloween.png" or "m16b_copper_pick.png",
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=2,
		damage_groups = {fleshy=3},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:shovel_copper", {
	description = S("Copper Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_copper_shovel_halloween.png" or "m16b_copper_shovel.png",
	wield_scale = wield_scale,
	groups = { tool=1, shovel=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=2,
		damage_groups = {fleshy=3},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:axe_copper", {
	description = S("Copper Axe"),
	_doc_items_longdesc = axe_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_copper_axe_halloween.png" or "m16b_copper_axe.png",
	wield_scale = wield_scale,
	groups = { tool=1, axe=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=2,
		damage_groups = {fleshy=8},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 4, level = 3, uses = 230 }
	},
})


-- Exposed
minetest.register_tool("m16b_mystic_stones_vl:sword_exposed", {
	description = S("Exposed Sword"),
	_doc_items_longdesc = sword_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_exposed_sword_halloween.png" or "m16b_exposed_sword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, sword=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=2,
		damage_groups = {fleshy=5},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 4, level = 3, uses = 230 },
		swordy_cobweb = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:pick_exposed", {
	description = S("Exposed Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_exposed_pick_halloween.png" or "m16b_exposed_pick.png",
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=2,
		damage_groups = {fleshy=3},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:shovel_exposed", {
	description = S("Exposed Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_exposed_shovel_halloween.png" or "m16b_exposed_shovel.png",
	wield_scale = wield_scale,
	groups = { tool=1, shovel=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=2,
		damage_groups = {fleshy=3},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:axe_exposed", {
	description = S("Exposed Axe"),
	_doc_items_longdesc = axe_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_exposed_axe_halloween.png" or "m16b_exposed_axe.png",
	wield_scale = wield_scale,
	groups = { tool=1, axe=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=2,
		damage_groups = {fleshy=8},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 4, level = 3, uses = 230 }
	},
})


-- Weathered
minetest.register_tool("m16b_mystic_stones_vl:sword_weathered", {
	description = S("Weathered Sword"),
	_doc_items_longdesc = sword_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_weathered_sword_halloween.png" or "m16b_weathered_sword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, sword=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=2,
		damage_groups = {fleshy=5},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 4, level = 3, uses = 230 },
		swordy_cobweb = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:pick_weathered", {
	description = S("Weathered Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_weathered_pick_halloween.png" or "m16b_weathered_pick.png",
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=2,
		damage_groups = {fleshy=3},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:shovel_weathered", {
	description = S("Weathered Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_weathered_shovel_halloween.png" or "m16b_weathered_shovel.png",
	wield_scale = wield_scale,
	groups = { tool=1, shovel=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=2,
		damage_groups = {fleshy=3},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:axe_weathered", {
	description = S("Weathered Axe"),
	_doc_items_longdesc = axe_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_weathered_axe_halloween.png" or "m16b_weathered_axe.png",
	wield_scale = wield_scale,
	groups = { tool=1, axe=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=2,
		damage_groups = {fleshy=8},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 4, level = 3, uses = 230 }
	},
})


-- Oxidized
minetest.register_tool("m16b_mystic_stones_vl:sword_oxidized", {
	description = S("Oxidized Sword"),
	_doc_items_longdesc = sword_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_oxidized_sword_halloween.png" or "m16b_oxidized_sword.png",
	wield_scale = wield_scale,
	groups = { weapon=1, sword=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 0.625,
		max_drop_level=2,
		damage_groups = {fleshy=5},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		swordy = { speed = 4, level = 3, uses = 230 },
		swordy_cobweb = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:pick_oxidized", {
	description = S("Oxidized Pickaxe"),
	_doc_items_longdesc = pickaxe_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_oxidized_pick_halloween.png" or "m16b_oxidized_pick.png",
	wield_scale = wield_scale,
	groups = { tool=1, pickaxe=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		-- 1/1.2
		full_punch_interval = 0.83333333,
		max_drop_level=2,
		damage_groups = {fleshy=3},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		pickaxey = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:shovel_oxidized", {
	description = S("Oxidized Shovel"),
	_doc_items_longdesc = shovel_longdesc,
	_doc_items_usagehelp = shovel_use,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_oxidized_shovel_halloween.png" or "m16b_oxidized_shovel.png",
	wield_scale = wield_scale,
	groups = { tool=1, shovel=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1,
		max_drop_level=2,
		damage_groups = {fleshy=3},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		shovely = { speed = 4, level = 3, uses = 230 }
	},
})

minetest.register_tool("m16b_mystic_stones_vl:axe_oxidized", {
	description = S("Oxidized Axe"),
	_doc_items_longdesc = axe_longdesc,
	_doc_items_hidden = false,
	inventory_image = it_is_halloween and "m16b_oxidized_axe_halloween.png" or "m16b_oxidized_axe.png",
	wield_scale = wield_scale,
	groups = { tool=1, axe=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 1.25,
		max_drop_level=2,
		damage_groups = {fleshy=8},
		punch_attack_uses = 230,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_copper:copper_ingot",
	_mcl_toollike_wield = true,
	_mcl_diggroups = {
		axey = { speed = 4, level = 3, uses = 230 }
	},
})
