local S = minetest.get_translator(minetest.get_current_modname())
local wield_scale = mcl_vars.tool_wield_scale

-- Heavy Mace
minetest.register_tool("m16b_mystic_stones_vl:mace", {
	description = S("Heavy Mace"),
	inventory_image = "m16b_heavy_mace.png",
	wield_scale = 1.3*mcl_vars.tool_wield_scale,
	groups = { weapon=1, heavy_mace=1, dig_speed_class=2, enchantability=10, mystic_stones = 1 },
	tool_capabilities = {
		full_punch_interval = 5,
		max_drop_level=5,
		damage_groups = {fleshy=14},
		punch_attack_uses = 500,
	},
	sound = { breaks = "default_tool_breaks" },
	_repair_material = "mcl_core:iron_ingot",
	_mcl_toollike_wield = true,
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:mace",
	recipe = {
		{"", "", "mcl_lanterns:chain"},
		{"", "mcl_lanterns:chain", "m16b_mystic_stones_vl:spiked_ball"},
		{"mcl_lanterns:chain", "", ""},

	},
})

-- Spiked Ball
minetest.register_craftitem("m16b_mystic_stones_vl:spiked_ball", {
	description = S("Spiked Ball"),
	_doc_items_longdesc = S(""),
	inventory_image = "m16b_spiked_ball.png",
	groups = { craftitem = 1, mystic_stones = 1 },
})

minetest.register_craft({
	output = "m16b_mystic_stones_vl:spiked_ball",
	recipe = {
		{"mcl_core:iron_nugget", "", "mcl_core:iron_nugget"},
		{"", "mcl_core:ironblock", ""},
		{"mcl_core:iron_nugget", "", "mcl_core:iron_nugget"},

	},
})
