local S = minetest.get_translator(minetest.get_current_modname())

local function increase_damage(damage_group, factor)
	return function(itemstack, level)
		local tool_capabilities = itemstack:get_tool_capabilities()
		tool_capabilities.damage_groups[damage_group] = (tool_capabilities.damage_groups[damage_group] or 0) + level * factor
		itemstack:get_meta():set_tool_capabilities(tool_capabilities)
	end
end

-- Heaviness
mcl_enchanting.enchantments.heaviness = {
	name = S("Heaviness"),
	max_level = 3,
	primary = {heavy_mace = true},
	secondary = {},
	disallow = {},
	incompatible = {},
	weight = 5,
	description = S("Increases damage."),
	curse = false,
	on_enchant = increase_damage("fleshy", 2),
	requires_tool = false,
	treasure = false,
	power_range_table = {{1, 21}, {12, 32}, {23, 43}},
	inv_combat_tab = true,
	inv_tool_tab = false,
	anvil_item_factor = 2,
	anvil_book_factor = 3,
}

-- Dovrebbe aumentare di molto il knockback
-- Heavy Knockback
mcl_enchanting.enchantments.heavy_knockback = {
	name = S("Heavy Knockback"),
	max_level = 4,
	primary = {heavy_mace = true},
	secondary = {},
	disallow = {},
	incompatible = {},
	weight = 5,
	description = S("Increases knockback."),
	curse = false,
	on_enchant = function() end,
	requires_tool = false,
	treasure = false,
	power_range_table = {{5, 61}, {25, 71}, {45, 81}, {65, 91}},
	inv_combat_tab = true,
	inv_tool_tab = false,
	anvil_item_factor = 2,
	anvil_book_factor = 1,
}

-- Undead Slayer 
mcl_enchanting.enchantments.trident_smite = {
	name = S("Undead Slayer"),
	max_level = 1,
	primary = {heavy_mace = true},
	secondary = {},
	disallow = {},
	incompatible = {},
	weight = 5,
	description = S("Increases damage to undead mobs."),
	curse = false,
	on_enchant = increase_damage("undead", 30),
	requires_tool = false,
	treasure = false,
	power_range_table = {{5, 25}},
	inv_combat_tab = true,
	inv_tool_tab = false,
	anvil_item_factor = 3,
	anvil_book_factor = 6,
}
