local S = core.get_translator(core.get_current_modname())

--Log
mcl_core.register_tree_trunk("lightningtree", S("Lightning Wood"), S("Lightning Bark"), S("The trunk of a lightning tree."), "m16b_light_tree_top.png", "m16b_light_tree_side.png", "m16b_mystic_stones_vl:stripped_lightning")
--Stripped
mcl_core.register_stripped_trunk("stripped_lightning", S("Stripped Lightning Log"), S("Stripped Lightning Wood"), S("The stripped trunk of a lightning tree."), S("The stripped wood of a lightning tree."), "mcl_stripped_lightning_log_top.png", "mcl_stripped_lightning_log_side.png")
--Planks
mcl_core.register_wooden_planks("lightningwood", S("Lightning Wood Planks"), {"m16b_lightning_wood.png"})
--Sapling
mcl_core.register_sapling("lightningsapling", S("Lightning Sapling"),
	S("When placed on soil (such as dirt) and exposed to light, a lightning sapling will grow into a lightning tree after some time."),
	nil, "default_sapling.png", {-5/16, -0.5, -5/16, 5/16, 0.5, 5/16})
--Leaves
mcl_core.register_leaves("lightningleaves", S("Lightning Leaves"), S("Lightning leaves are grown from lightning trees."), {"m16b_lightning_leaves.png"}, "#eaf213", "color", "mcl_core_palette_foliage.png", "m16b_mystic_stones_vl:lightningsapling", true, {20, 16, 12, 10}, 1)
--Sign
--tree_shem
--fence
--gate
--door
--trapdoor
--boat
--lightdirt
core.register_node("m16b_mystic_stones_vl:lightdirt", {
	description = S("Lightdirt"),
	_doc_items_longdesc = S("Lightdirt is a type of dirt found in lightning forests. Only a few plants are able to survive on it."),
	tiles = {"m16b_lightdirt_top.png", "default_dirt.png", {name="m16b_lightdirt_side.png", tileable_vertical=false}},
	groups = {handy=1, shovely=1, dirt=2, soil=1, soil_sapling=2, soil_sugarcane=1, soil_bamboo = 1, soil_fungus=1, enderman_takable=1, building_block=1, supports_mushrooms=1, converts_to_moss=1, mystic_stones=1},
	drop = "mcl_core:dirt",
	sounds = mcl_sounds.node_sound_dirt_defaults(),
	on_construct = mcl_core.on_snowable_construct,
	_on_shovel_place = mcl_core.make_dirtpath,
	_mcl_hardness = 0.5,
	_mcl_silk_touch_drop = true,
})
