local S = core.get_translator(core.get_current_modname())
local modpath = minetest.get_modpath("m16b_mystic_stones_vl")

local function increase_damage(damage_group, factor)
	return function(itemstack, level)
		local tool_capabilities = itemstack:get_tool_capabilities()
		tool_capabilities.damage_groups[damage_group] = (tool_capabilities.damage_groups[damage_group] or 0) + level * factor
		itemstack:get_meta():set_tool_capabilities(tool_capabilities)
	end
end

-- Lava Walker
mcl_enchanting.enchantments.lava_walker = {
	name = S("Lava Walker"),
	max_level = 2,
	primary = {},
	secondary = {armor_feet = true},
	disallow = {non_combat_armor = true},
	incompatible = {frost_walker = true},
	weight = 5,
	description = S("Turns lava beneath the player into magma blocks and prevents the damage from magma blocks."),
	curse = false,
	on_enchant = function() end,
	requires_tool = false,
	treasure = false,
	power_range_table = {{20, 45}, {40, 55}},
	inv_combat_tab = true,
	inv_tool_tab = false,
	anvil_item_factor = 4,
	anvil_book_factor = 2,
}

walkover.register_global(function(pos, _, player)
	local boots = player:get_inventory():get_stack("armor", 5)
	local lava_walker = mcl_enchanting.get_enchantment(boots, "lava_walker")
	if lava_walker <= 0 then
		return
	end
	local radius = lava_walker + 2
	local minp = {x = pos.x - radius, y = pos.y, z = pos.z - radius}
	local maxp = {x = pos.x + radius, y = pos.y, z = pos.z + radius}
    local target_blocks = {"mcl_core:lava_source", "mcl_nether:nether_lava_source"}
    local positions = minetest.find_nodes_in_area_under_air(minp, maxp, target_blocks)

	for _, p in ipairs(positions) do
		if vector.distance(pos, p) <= radius then
			minetest.set_node(p, {name = "m16b_mystic_stones_vl:magma_0"})
		end
	end
end)

-- Mida's Curse
mcl_enchanting.enchantments.mida_curse = {
	name = S("Mida's Curse"),
	max_level = 1,
	primary = {},
	secondary = {armor_feet = true},
	disallow = {non_combat_armor = true},
	incompatible = {},
	weight = 5,
	description = S("Turns dirt beneath the player into gold blocks and prevents the damage from magma blocks."),
	curse = true,
	on_enchant = function() end,
	requires_tool = false,
	treasure = false,
	power_range_table = {{20, 45}},
	inv_combat_tab = true,
	inv_tool_tab = false,
	anvil_item_factor = 4,
	anvil_book_factor = 2,
}

walkover.register_global(function(pos, _, player)
	local boots = player:get_inventory():get_stack("armor", 5)
	local lava_walker = mcl_enchanting.get_enchantment(boots, "mida_curse")
	if lava_walker <= 0 then
		return
	end
	local radius = lava_walker + 6
	local minp = {x = pos.x - radius, y = pos.y, z = pos.z - radius}
	local maxp = {x = pos.x + radius, y = pos.y, z = pos.z + radius}
    local target_blocks = {"mcl_core:dirt", "mcl_core:dirt_with_grass"}
    local positions = minetest.find_nodes_in_area_under_air(minp, maxp, target_blocks)

	for _, p in ipairs(positions) do
		if vector.distance(pos, p) <= radius then
			minetest.set_node(p, {name = "m16b_mystic_stones_vl:fake_goldblock"})
		end
	end
end)

-- Desharpness
mcl_enchanting.enchantments.desharpness = {
	name = S("Desharpness"),
	max_level = 5,
	primary = {sword = true},
	secondary = {axe = true},
	disallow = {},
	incompatible = {},
	weight = 5,
	description = S("Increases damage."),
	curse = true,
	on_enchant = increase_damage("fleshy", -2),
	requires_tool = false,
	treasure = false,
	power_range_table = {{1, 21}, {12, 32}, {23, 43}, {34, 54}, {45, 65}},
	inv_combat_tab = true,
	inv_tool_tab = false,
	anvil_item_factor = 1,
	anvil_book_factor = 1,
}

-- Do You Want More Damage????
mcl_enchanting.enchantments.death_sword = {
	name = S("Do You Want More Damage????"),
	max_level = 1,
	primary = {death = true},
	secondary = {},
	disallow = {},
	incompatible = {},
	weight = 5,
	description = S("Increases damage."),
	curse = true,
	on_enchant = increase_damage("fleshy", -90),
	requires_tool = false,
	treasure = false,
	power_range_table = {{1, 21}},
	inv_combat_tab = true,
	inv_tool_tab = false,
	anvil_item_factor = 1,
	anvil_book_factor = 1,
}

--[[
-- Lightning Blade
mcl_enchanting.enchantments.lightning = {
    name = S("Lightning Blade"),
    max_level = 2,
    primary = {sword = true},
    secondary = {},
    disallow = {},
    incompatible = {},
    weight = 2,
    description = S("Calls down lightning on the target."),
    curse = false,
    on_enchant = function() end,
    requires_tool = false,
    treasure = false,
    power_range_table = {{10, 61}, {30, 71}},
    inv_combat_tab = true,
    inv_tool_tab = false,
    anvil_item_factor = 4,
    anvil_book_factor = 2,
}

-- Evento quando un player viene colpito da un altro player
core.register_on_punchplayer(function(player, hitter)
    if not hitter then return end

    -- Prendi l'arma che il colpitore ha in mano
    local wielditem = mcl_util.get_wielditem(hitter)
    if not wielditem then return end

    -- Controlla se l'arma ha l'incantesimo "lightning"
    local lightning_level = mcl_enchanting.get_enchantment(wielditem, "lightning")
    if lightning_level and lightning_level > 0 then
        -- Fa cadere il fulmine sulla posizione del player colpito
        for i = 1, lightning_level do
            mcl_lightning.strike(player:get_pos())
        end
    end
end)

-- Poison Blade
mcl_enchanting.enchantments.poison_blade = {
	name = S("Poison Blade"),
	max_level = 4,
	primary = {sword = true},
	secondary = {},
	disallow = {},
	incompatible = {},
	weight = 2,
	description = S("Poisoning Target."),
	curse = false,
	on_enchant = function() end,
	requires_tool = false,
	treasure = false,
	power_range_table = {{10, 61}, {30, 71}, {50, 81}, {70, 91}},
	inv_combat_tab = true,
	inv_tool_tab = false,
	anvil_item_factor = 4,
	anvil_book_factor = 2,
}

core.register_on_punchplayer(function(player, hitter)
	local wielditem = hitter and mcl_util.get_wielditem (hitter)
	if wielditem then
		local poison_blade_level = mcl_enchanting.get_enchantment(wielditem, "poison_blade")
		if poison_blade_level > 0 then
			mcl_potions.withering_func(player, poison_blade_level * 4)
		end
	end
end)

mcl_potions.withering_func(pl, 1, 2)
]]--


dofile(modpath .. "/enchant/init.lua")
