local S = core.get_translator(core.get_current_modname())

-- Lava Walker Magma (4 nodes)
for i=0,3 do
	local ice = {}
	function ice.increase_age(pos, ice_near, first_melt)
		-- Increase age of magma age or turn to water source if too old
		local nn = minetest.get_node(pos).name
		local age = tonumber(string.sub(nn, -1))
		local dim = mcl_worlds.pos_to_dimension(pos)
		if age == nil then return end
		if age < 3 then
			minetest.swap_node(pos, { name = "m16b_mystic_stones_vl:magma_"..(age+1) })
		else
			if dim ~= "end" then
				minetest.set_node(pos, { name = "mcl_core:lava_source" })
			else
				minetest.remove_node(pos)
			end
		end
		-- Spread aging to neighbor blocks, but not recursively
		if first_melt and i == 3 then
			for j=1, #ice_near do
				ice.increase_age(ice_near[j], false)
			end
		end
	end
	local use_doc = i == 0
	local longdesc
	if use_doc then
		longdesc = S("magma is a short-lived solid block. It melts into a water source within a few seconds.")
	end
	minetest.register_node("m16b_mystic_stones_vl:magma_"..i, {
		description = S("Magma"),
		_doc_items_create_entry = use_doc,
		_doc_items_longdesc = longdesc,
		drawtype = ice_drawtype,
		tiles = {"m16b_magma_"..i..".png"},
		is_ground_content = false,
		paramtype = "light",
		use_texture_alpha = ice_texture_alpha,
		groups = {handy=1, not_in_creative_inventory=1},
    	light_source = 14,
		drop = "",
		sounds = mcl_sounds.node_sound_ice_defaults(),
		on_construct = function(pos)
			local timer = minetest.get_node_timer(pos)
			timer:start(1.5)
		end,
		on_timer = function(pos)
			local ice_near = minetest.find_nodes_in_area(
				{ x = pos.x - 1, y = pos.y - 1, z = pos.z - 1 },
				{ x = pos.x + 1, y = pos.y + 1, z = pos.z + 1 },
				{ "group:frosted_ice" }
			)
			-- Check condition to increase age
			if (#ice_near < 4 and minetest.get_node_light(pos) > (11 - i)) or math.random(1, 3) == 1 then
				ice.increase_age(pos, ice_near, true)
			end
			local timer = minetest.get_node_timer(pos)
			timer:start(1.5)
		end,
		_mcl_blast_resistance = 0.5,
		_mcl_hardness = 0.5,
	})

	-- Add entry aliases for the Help
	if minetest.get_modpath("doc") and i > 0 then
		doc.add_entry_alias("nodes", "m16b_mystic_stones_vl:magma_0", "nodes", "m16b_mystic_stones_vl:magma_"..i)
	end
end

-- Fake Gold Block
minetest.register_node("m16b_mystic_stones_vl:fake_goldblock", {
	description = S("Gold Block"),
	_doc_items_longdesc = S(""),
	tiles = {"default_gold_block.png"},
	is_ground_content = false,
	sounds = mcl_sounds.node_sound_stone_defaults(),
	groups = {pickaxey=5, building_block=1, material_stone=1, unmovable_by_piston = 1},
	_mcl_blast_resistance = 1200,
	_mcl_hardness = 50,
})
